/*
 * Decompiled with CFR 0.152.
 */
package com.pcube.management.common;

import com.pcube.management.common.ArrayUtilities;
import com.pcube.management.common.SystemProperties;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Category;

public class Configuration {
    private static Category logcat = Category.getInstance(Configuration.class);
    private String base;
    private Properties config;
    private Properties mirror;

    public Configuration(Properties properties) {
        this(null, properties);
    }

    public Configuration(Configuration configuration) {
        this(null, configuration);
    }

    public Configuration(String string, Properties properties) {
        this.config = properties != null ? properties : new Properties();
        this.mirror = (Properties)this.config.clone();
        this.base = Configuration.parseBase(string);
    }

    public Configuration(String string, Configuration configuration) {
        this.config = (Properties)configuration.config.clone();
        this.mirror = (Properties)configuration.mirror.clone();
        this.base = Configuration.parseBase(string);
    }

    public Properties getConfigurationAsProperties() {
        return (Properties)this.config.clone();
    }

    public String getProperty(String string, String string2) {
        String string3 = SystemProperties.get(this.base + string, this.config.getProperty(string, string2));
        this.mirror.put(string, string3 != null ? string3 : "N/A");
        return string3;
    }

    public boolean getProperty(String string, boolean bl) {
        String string2 = this.getProperty(string, bl + "");
        return Boolean.valueOf(string2);
    }

    public int getProperty(String string, int n) {
        String string2 = this.getProperty(string, n + "");
        try {
            return Integer.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            logcat.error((Object)("Could not translate '" + string2 + "' to int for property name '" + string + "'."), (Throwable)numberFormatException);
            this.mirror.put(string, n + "");
            return n;
        }
    }

    public long getProperty(String string, long l) {
        String string2 = this.getProperty(string, l + "");
        try {
            return Long.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            logcat.error((Object)("Could not translate '" + string2 + "' to int for property name '" + string + "'."), (Throwable)numberFormatException);
            this.mirror.put(string, l + "");
            return l;
        }
    }

    public char getProperty(String string, char c) {
        String string2 = this.getProperty(string, c + "");
        if (string2.length() != 1) {
            logcat.error((Object)("Could not translate '" + string2 + "' to char for property name '" + string + "'."));
            this.mirror.put(string, c + "");
            return c;
        }
        return string2.charAt(0);
    }

    public String getProperty(String string) {
        return this.getProperty(string, null);
    }

    public String[] getKeysThatStartWith(String string) {
        Object object;
        Vector<Object[]> vector = new Vector<Object[]>();
        Enumeration<Object> enumeration = this.config.keys();
        while (enumeration.hasMoreElements()) {
            object = (Object[])enumeration.nextElement();
            if (!object.startsWith(string)) continue;
            vector.addElement((Object[])object);
        }
        enumeration = System.getProperties().keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (!object.startsWith(string) || this.config.containsKey(object)) continue;
            vector.addElement((Object[])object);
        }
        object = new String[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public String[] getCurrentConfiguration() {
        String[] stringArray = new String[this.mirror.size()];
        Enumeration<Object> enumeration = this.mirror.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            stringArray[n++] = object + "=" + this.mirror.get(object);
        }
        ArrayUtilities.sort(stringArray);
        return stringArray;
    }

    public String getBase() {
        return this.base;
    }

    private static final String parseBase(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        return string.endsWith(".") ? string : string + ".";
    }
}

