/*
 * Decompiled with CFR 0.152.
 */
package com.pcube.management.common;

import com.pcube.management.common.ThrowableDumpHelper;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Vector;

class DumpStringsHelper
extends ThrowableDumpHelper {
    private VectorWriter vectorWriter = new VectorWriter();

    DumpStringsHelper() {
    }

    String[] getDumpStrings(Throwable throwable) {
        if (throwable == null) {
            return new String[0];
        }
        this.preDumpInit();
        this.vectorWriter.clear();
        this.dump(throwable, 0);
        return this.vectorWriter.toStringArray();
    }

    protected void appendExceptionTitle(String string) {
    }

    protected void appendTitle(String string) {
        this.vectorWriter.println(string);
    }

    protected void appendSubTitle(String string) {
        this.vectorWriter.println(string);
    }

    protected void appendThrowableStackTrace(Throwable throwable) {
        throwable.printStackTrace(this.vectorWriter);
    }

    static class NullWriter
    extends Writer {
        NullWriter() {
        }

        public void close() {
        }

        public void flush() {
        }

        public void write(char[] cArray, int n, int n2) {
        }
    }

    static class VectorWriter
    extends PrintWriter {
        private Vector v = new Vector();

        VectorWriter() {
            super(new NullWriter());
        }

        public void println(Object object) {
            this.v.addElement(object.toString());
        }

        public void println(char[] cArray) {
            this.v.addElement(new String(cArray));
        }

        public void print(String string) {
            this.v.addElement(string);
        }

        public void println(String string) {
            this.v.addElement(string);
        }

        public String[] toStringArray() {
            int n = this.v.size();
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = (String)this.v.elementAt(i);
            }
            return stringArray;
        }

        public void clear() {
            this.v.setSize(0);
        }
    }
}

