/*
 * Decompiled with CFR 0.152.
 */
package com.pcube.management.common;

import com.pcube.management.common.DumpHtmlStringHelper;
import com.pcube.management.common.DumpStringHelper;
import com.pcube.management.common.DumpStringsHelper;
import com.pcube.management.common.ExceptionWrapper;
import com.pcube.management.common.ExceptionWrapperHandler;
import com.pcube.management.common.ExceptionsSetWrapper;
import com.sun.jdmk.ProxyMBeanInstantiationException;
import com.sun.jdmk.comm.CommunicationException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.WriteAbortedException;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Vector;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;

public class Exceptions {
    private static final DumpStringsHelper dummy = new DumpStringsHelper();
    private static Vector handlers = new Vector();
    private static HashMap handlersHash = new HashMap();

    public static Throwable getFirstWrappedOfType(Throwable throwable, Class clazz) {
        if (clazz.isAssignableFrom(throwable.getClass())) {
            return throwable;
        }
        HashMap hashMap = new HashMap();
        while (Exceptions.isWrapper(throwable)) {
            if (hashMap.containsKey(throwable)) {
                return null;
            }
            hashMap.put(throwable, null);
            if (!clazz.isAssignableFrom((throwable = Exceptions.getWrappedThrowable(throwable)).getClass())) continue;
            return throwable;
        }
        return null;
    }

    public static Throwable getRoot(Throwable throwable) {
        HashMap hashMap = new HashMap();
        while (Exceptions.isWrapper(throwable)) {
            if (hashMap.containsKey(throwable)) {
                return throwable;
            }
            hashMap.put(throwable, null);
            throwable = Exceptions.getWrappedThrowable(throwable);
        }
        return throwable;
    }

    public static String getRootMessage(Throwable throwable) {
        String string = Exceptions.getRoot(throwable).getMessage();
        if (string == null) {
            return "";
        }
        return string;
    }

    public static boolean isWrapper(Throwable throwable) {
        return Exceptions.getWrappedThrowable(throwable) != null;
    }

    public static Throwable getWrappedThrowable(Throwable throwable) {
        try {
            if (throwable instanceof ExceptionWrapper) {
                return ((ExceptionWrapper)((Object)throwable)).getWrappedThrowable();
            }
            if (throwable instanceof ExceptionsSetWrapper) {
                Throwable[] throwableArray = ((ExceptionsSetWrapper)((Object)throwable)).getWrappedThrowables();
                if (throwableArray == null) {
                    return null;
                }
                for (int i = 0; i < throwableArray.length; ++i) {
                    if (throwableArray[i] == null) continue;
                    return throwableArray[i];
                }
                return null;
            }
            for (int i = 0; i < handlers.size(); ++i) {
                Class clazz = (Class)handlers.get(i);
                if (!clazz.isAssignableFrom(throwable.getClass())) continue;
                ExceptionWrapperHandler exceptionWrapperHandler = (ExceptionWrapperHandler)handlersHash.get(clazz);
                return exceptionWrapperHandler.getWrappedThrowable(throwable);
            }
            return null;
        }
        catch (Throwable throwable2) {
            throwable2.printStackTrace();
            return null;
        }
    }

    public static void removeWrapper(Class clazz) {
        handlers.remove(clazz);
        handlersHash.remove(clazz);
    }

    public static void addWrapper(Class clazz, ExceptionWrapperHandler exceptionWrapperHandler) {
        if (!handlers.contains(clazz)) {
            handlers.add(clazz);
        }
        handlersHash.put(clazz, exceptionWrapperHandler);
    }

    public static void addWrapperAfter(Class clazz, ExceptionWrapperHandler exceptionWrapperHandler, Class clazz2) {
        int n;
        if (handlers.contains(clazz)) {
            handlers.remove(clazz);
        }
        if ((n = handlers.indexOf(clazz2, 0)) == -1) {
            n = handlers.size() - 1;
        }
        handlers.insertElementAt(clazz, n + 1);
        handlersHash.put(clazz, exceptionWrapperHandler);
    }

    public static void addWrapperBefore(Class clazz, ExceptionWrapperHandler exceptionWrapperHandler, Class clazz2) {
        int n;
        if (handlers.contains(clazz)) {
            handlers.remove(clazz);
        }
        if ((n = handlers.indexOf(clazz2, 0)) == -1) {
            n = 0;
        }
        handlers.insertElementAt(clazz, n);
        handlersHash.put(clazz, exceptionWrapperHandler);
    }

    public static String getExceptionDumpString(Throwable throwable, boolean bl) {
        DumpStringHelper dumpStringHelper = bl ? new DumpHtmlStringHelper() : new DumpStringHelper();
        return dumpStringHelper.getDumpString(throwable);
    }

    public static String[] getExceptionDumpStrings(Throwable throwable) {
        DumpStringsHelper dumpStringsHelper = new DumpStringsHelper();
        return dumpStringsHelper.getDumpStrings(throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getFirstLineInStackTraceThatStartsWith(Throwable throwable, String string) {
        try {
            StringReader stringReader = new StringReader(new DumpStringHelper().getDumpString(throwable));
            BufferedReader bufferedReader = new BufferedReader(stringReader);
            try {
                String string2 = null;
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (!(string2 = string2.trim()).startsWith(string)) continue;
                    String string3 = string2;
                    return string3;
                }
                String string4 = "no-line";
                return string4;
            }
            finally {
                stringReader.close();
                bufferedReader.close();
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
    }

    static {
        try {
            Exceptions.addWrapper(InvocationTargetException.class, new ExceptionWrapperHandler(){

                public Throwable getWrappedThrowable(Throwable throwable) {
                    return ((InvocationTargetException)throwable).getTargetException();
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            Exceptions.addWrapper(WriteAbortedException.class, new ExceptionWrapperHandler(){

                public Throwable getWrappedThrowable(Throwable throwable) {
                    return ((WriteAbortedException)throwable).detail;
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            Exceptions.addWrapper(RemoteException.class, new ExceptionWrapperHandler(){

                public Throwable getWrappedThrowable(Throwable throwable) {
                    return ((RemoteException)throwable).detail;
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            Exceptions.addWrapper(MBeanException.class, new ExceptionWrapperHandler(){

                public Throwable getWrappedThrowable(Throwable throwable) {
                    return ((MBeanException)throwable).getTargetException();
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            Exceptions.addWrapper(ReflectionException.class, new ExceptionWrapperHandler(){

                public Throwable getWrappedThrowable(Throwable throwable) {
                    return ((ReflectionException)throwable).getTargetException();
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            Exceptions.addWrapper(RuntimeOperationsException.class, new ExceptionWrapperHandler(){

                public Throwable getWrappedThrowable(Throwable throwable) {
                    return ((RuntimeOperationsException)throwable).getTargetException();
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            Exceptions.addWrapper(RuntimeMBeanException.class, new ExceptionWrapperHandler(){

                public Throwable getWrappedThrowable(Throwable throwable) {
                    return ((RuntimeMBeanException)throwable).getTargetException();
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            Exceptions.addWrapper(RuntimeErrorException.class, new ExceptionWrapperHandler(){

                public Throwable getWrappedThrowable(Throwable throwable) {
                    return ((RuntimeErrorException)throwable).getTargetError();
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            Exceptions.addWrapper(CommunicationException.class, new ExceptionWrapperHandler(){

                public Throwable getWrappedThrowable(Throwable throwable) {
                    return ((CommunicationException)throwable).getTargetException();
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            Exceptions.addWrapper(ProxyMBeanInstantiationException.class, new ExceptionWrapperHandler(){

                public Throwable getWrappedThrowable(Throwable throwable) {
                    return ((ProxyMBeanInstantiationException)throwable).getTargetException();
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            DumpStringHelper dumpStringHelper = new DumpStringHelper();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

