/*
 * Decompiled with CFR 0.152.
 */
package com.pcube.management.common;

import com.pcube.management.common.IPUtilities;

public class GenericIpRange {
    protected long lowIP;
    protected long highIP;

    public GenericIpRange() {
        this.lowIP = 0L;
        this.highIP = 0L;
    }

    public GenericIpRange(long l, long l2) {
        this.lowIP = l;
        this.highIP = l2;
    }

    public long getMinIpAddr() {
        return this.lowIP;
    }

    public long getMaxIpAddr() {
        return this.highIP;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof GenericIpRange) {
            return ((GenericIpRange)object).getMinIpAddr() == this.lowIP && ((GenericIpRange)object).getMaxIpAddr() == this.highIP;
        }
        return false;
    }

    public GenericIpRange intersection(GenericIpRange genericIpRange) {
        if (this.getMinIpAddr() > genericIpRange.getMaxIpAddr()) {
            return null;
        }
        if (this.getMaxIpAddr() < genericIpRange.getMinIpAddr()) {
            return null;
        }
        return new GenericIpRange(Math.max(this.getMinIpAddr(), genericIpRange.getMinIpAddr()), Math.min(this.getMaxIpAddr(), genericIpRange.getMaxIpAddr()));
    }

    public GenericIpRange[] diff(GenericIpRange genericIpRange) {
        if (this.intersection(genericIpRange) == null) {
            return new GenericIpRange[]{this};
        }
        if (this.equals(this.intersection(genericIpRange))) {
            return null;
        }
        if (genericIpRange.equals(this.intersection(genericIpRange))) {
            if (this.getMinIpAddr() == genericIpRange.getMinIpAddr()) {
                return new GenericIpRange[]{new GenericIpRange(genericIpRange.getMaxIpAddr() + 1L, this.getMaxIpAddr())};
            }
            if (this.getMaxIpAddr() == genericIpRange.getMaxIpAddr()) {
                return new GenericIpRange[]{new GenericIpRange(this.getMinIpAddr(), genericIpRange.getMinIpAddr() - 1L)};
            }
            return new GenericIpRange[]{new GenericIpRange(this.getMinIpAddr(), genericIpRange.getMinIpAddr() - 1L), new GenericIpRange(genericIpRange.getMaxIpAddr() + 1L, this.getMaxIpAddr())};
        }
        if (this.getMinIpAddr() < genericIpRange.getMinIpAddr()) {
            return new GenericIpRange[]{new GenericIpRange(this.getMinIpAddr(), genericIpRange.getMinIpAddr() - 1L)};
        }
        if (this.getMaxIpAddr() > genericIpRange.getMaxIpAddr()) {
            return new GenericIpRange[]{new GenericIpRange(genericIpRange.getMaxIpAddr() + 1L, this.getMaxIpAddr())};
        }
        throw new AssertionError((Object)"diff calculation is inconsistent");
    }

    public String toString() {
        return IPUtilities.ipLongToString(this.lowIP) + "-" + IPUtilities.ipLongToString(this.highIP);
    }
}

