/*
 * Decompiled with CFR 0.152.
 */
package com.pcube.management.common;

import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;

public class HashUtilities {
    public static void printSorted(Object[] objectArray, Object[] objectArray2, PrintWriter printWriter, int n) {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            hashMap.put(objectArray[i], objectArray2[i]);
        }
        HashUtilities.printSorted(hashMap, printWriter, n);
    }

    public static void printSorted(Properties properties, PrintWriter printWriter, int n) {
        Enumeration<?> enumeration = properties.propertyNames();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            hashMap.put(string, properties.getProperty(string, ""));
        }
        HashUtilities.printSorted(hashMap, printWriter, n);
    }

    public static void printSorted(HashMap hashMap, PrintWriter printWriter, int n) {
        Set set = hashMap.keySet();
        Object[] objectArray = set.toArray();
        int n2 = 0;
        if (n < 0) {
            n2 = -1 * n;
        } else {
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i].toString().length() <= n2) continue;
                n2 = objectArray[i].toString().length();
            }
            if (n > 0) {
                n2 = Math.min(n2, n);
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        Arrays.sort(objectArray, new Comparator(){

            public int compare(Object object, Object object2) {
                return object.toString().compareTo(object2.toString());
            }
        });
        for (int i = 0; i < objectArray.length; ++i) {
            HashUtilities.printKeyValuePair(objectArray[i].toString(), hashMap.get(objectArray[i]), printWriter, n2, stringBuffer, 0, null);
        }
    }

    protected static void printKeyValuePair(String string, Object object, PrintWriter printWriter, int n, StringBuffer stringBuffer, int n2, HashMap hashMap) {
        HashUtilities.printSpaces(printWriter, stringBuffer, n2);
        printWriter.print(string);
        if (string.length() < n) {
            HashUtilities.printSpaces(printWriter, stringBuffer, n - string.length());
        }
        if (object == null) {
            printWriter.println(" = ");
        } else if (!object.getClass().isArray()) {
            printWriter.println(" = " + object);
        } else {
            if (hashMap == null) {
                hashMap = new HashMap();
            }
            int n3 = Array.getLength(object);
            if (!hashMap.containsKey(object)) {
                hashMap.put(object, null);
                printWriter.println(" = (" + object.getClass().getName() + ")(" + n3 + ")");
                for (int i = 0; i < n3; ++i) {
                    HashUtilities.printKeyValuePair(string + "[" + i + "]", Array.get(object, i), printWriter, string.length() + 4, stringBuffer, n2 + 4, hashMap);
                }
            } else {
                printWriter.println(" = (" + object.getClass().getName() + ")(" + n3 + ") - already been dumped (endless cycle?)");
            }
        }
    }

    protected static void printSpaces(PrintWriter printWriter, StringBuffer stringBuffer, int n) {
        if (stringBuffer.length() < n) {
            for (int i = stringBuffer.length(); i < n; ++i) {
                stringBuffer.append(" ");
            }
        }
        printWriter.print(stringBuffer.toString().substring(0, n));
    }
}

