/*
 * Decompiled with CFR 0.152.
 */
package com.pcube.management.common;

import com.pcube.management.common.Community;
import com.pcube.management.common.GenericIpRange;
import com.pcube.management.common.IpRange;
import com.pcube.management.common.IpRangeAndExpirationTime;
import com.pcube.management.common.TunneledIpRange;
import com.pcube.management.common.Vlan;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.log4j.Category;

public class IPUtilities {
    private static Category logcat = Category.getInstance(IPUtilities.class);
    private static String VPN_SEPARATOR = "@";

    public static String converstHostNameToIp(String string) throws UnknownHostException {
        InetAddress inetAddress = InetAddress.getByName(string);
        return inetAddress.getHostAddress();
    }

    public static String converstIPToHostName(String string) throws UnknownHostException {
        InetAddress inetAddress = InetAddress.getByName(string);
        return inetAddress.getHostName();
    }

    public static boolean compareAddress(String string, String string2) throws UnknownHostException {
        InetAddress inetAddress = InetAddress.getByName(string);
        InetAddress inetAddress2 = InetAddress.getByName(string2);
        return inetAddress.equals(inetAddress2);
    }

    public static long createIpAddress(String string) throws NumberFormatException {
        if ((string.startsWith("0x") || string.startsWith("0X")) && !string.substring(2).startsWith("-")) {
            try {
                return Long.parseLong(string.substring(2), 16);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (!string.startsWith("-") && string.indexOf(46) == -1) {
            try {
                return Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return IPUtilities.parseDottedIpToLong(string);
    }

    public static long parseDottedIpToLong(String string) throws NumberFormatException {
        long l = 0L;
        int n = -1;
        int n2 = -1;
        for (int i = 0; i < 4; ++i) {
            int n3;
            n2 = string.indexOf(46, n + 1);
            if (n2 < 0) {
                if (i == 3) {
                    n2 = string.length();
                } else {
                    throw new NumberFormatException("can't parse " + string + " into an IP");
                }
            }
            try {
                n3 = Integer.parseInt(string.substring(n + 1, n2));
            }
            catch (NumberFormatException numberFormatException) {
                n3 = 0;
                throw new NumberFormatException("can't parse " + string + " into an IP");
            }
            if (n3 < 0 || n3 > 255) {
                throw new NumberFormatException("can't parse " + string + " into an IP");
            }
            l |= (long)n3 << (3 - i) * 8 & (long)(255 << (3 - i) * 8);
            n = n2;
        }
        if (n2 != string.length()) {
            throw new NumberFormatException("can't parse " + string + " into an IP");
        }
        return l;
    }

    public static IpRange[] parseToRanges(String[] stringArray) throws NumberFormatException {
        IpRange[] ipRangeArray = null;
        if (stringArray != null) {
            ipRangeArray = new IpRange[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                ipRangeArray[i] = IPUtilities.parseToRange(stringArray[i]);
            }
        }
        return ipRangeArray;
    }

    public static TunneledIpRange[] parseToTunneledIpRanges(String[] stringArray) throws NumberFormatException {
        TunneledIpRange[] tunneledIpRangeArray = null;
        if (stringArray != null) {
            tunneledIpRangeArray = new TunneledIpRange[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                tunneledIpRangeArray[i] = IPUtilities.parseToTunneledIpRange(stringArray[i]);
            }
        }
        return tunneledIpRangeArray;
    }

    public static TunneledIpRange parseToTunneledIpRange(String string) throws NumberFormatException {
        if (string != null) {
            int n = string.indexOf(VPN_SEPARATOR);
            if (n == -1) {
                return new TunneledIpRange(string);
            }
            String string2 = string.substring(0, n);
            IpRange ipRange = IPUtilities.parseToRange(string2);
            String string3 = string.substring(n + 1);
            return new TunneledIpRange(ipRange, string3);
        }
        return null;
    }

    public static IpRange parseToRange(String string) throws NumberFormatException {
        IpRange ipRange = null;
        if (string != null) {
            int n = string.indexOf(47);
            long l = 0L;
            byte by = 32;
            if (n > 0) {
                l = IPUtilities.parseDottedIpToLong(string.substring(0, n));
                by = Byte.parseByte(string.substring(n + 1));
            } else {
                l = IPUtilities.parseDottedIpToLong(string);
            }
            ipRange = IpRange.createFromSignificantBits(l, by);
        }
        return ipRange;
    }

    public static GenericIpRange parseToGenericRange(String string) throws NumberFormatException {
        if (string != null) {
            int n = string.indexOf(45);
            long l = IPUtilities.parseDottedIpToLong(string.substring(0, n));
            long l2 = IPUtilities.parseDottedIpToLong(string.substring(n + 1));
            return new GenericIpRange(l, l2);
        }
        return null;
    }

    public static long createIPAddress(String string, String string2, String string3, String string4) throws NumberFormatException {
        int n = IPUtilities.createByte(string) & 0xFF;
        int n2 = IPUtilities.createByte(string2) & 0xFF;
        int n3 = IPUtilities.createByte(string3) & 0xFF;
        int n4 = IPUtilities.createByte(string4) & 0xFF;
        int n5 = 0;
        n5 = n << 24 | n2 << 16 | n3 << 8 | n4;
        return (long)n5 & 0xFFFFFFFFL;
    }

    private static byte createByte(String string) throws NumberFormatException {
        int n = string.startsWith("0x") ? Integer.parseInt(string.substring(2), 16) : Integer.parseInt(string);
        if (n >= 0 && n <= 255) {
            return (byte)n;
        }
        throw new NumberFormatException(string + " Allowed range is 0-255");
    }

    private static String[] extractIpBytes(long l) {
        String[] stringArray = new String[4];
        for (int i = 0; i < 4; ++i) {
            int n = (int)(l & 0xFFL);
            stringArray[3 - i] = n + "";
            l >>= 8;
        }
        return stringArray;
    }

    public static String ipLongToString(long l) {
        String[] stringArray = IPUtilities.extractIpBytes(l);
        return stringArray[0] + '.' + stringArray[1] + '.' + stringArray[2] + '.' + stringArray[3];
    }

    public static void main(String[] stringArray) {
        try {
            String string = "255.255.255.255";
            System.out.println("Parse " + string + " long = " + IPUtilities.parseDottedIpToLong(string) + " = 0x" + Long.toHexString(IPUtilities.parseDottedIpToLong(string)));
            string = "196.1.2.3";
            System.out.println("Parse " + string + " long = " + IPUtilities.parseDottedIpToLong(string) + " = 0x" + Long.toHexString(IPUtilities.parseDottedIpToLong(string)));
            string = "1.2.3.4";
            System.out.println("Parse " + string + " long = " + IPUtilities.parseDottedIpToLong(string) + " = 0x" + Long.toHexString(IPUtilities.parseDottedIpToLong(string)));
            System.out.println(IPUtilities.converstHostNameToIp("pcubepc138"));
            System.out.println(IPUtilities.converstHostNameToIp("pcubepc139"));
            System.out.println(IPUtilities.converstHostNameToIp("10.1.1.253"));
            System.out.println(IPUtilities.converstHostNameToIp("10.1.1.140"));
            System.out.println(IPUtilities.converstIPToHostName("pcubepc138"));
            System.out.println(IPUtilities.converstIPToHostName("pcubepc139"));
            System.out.println(IPUtilities.converstIPToHostName("10.1.1.253"));
            System.out.println(IPUtilities.converstIPToHostName("10.1.1.140"));
            System.out.println(IPUtilities.compareAddress("10.1.1.140", "pcubepc139"));
            System.out.println(IPUtilities.compareAddress("10.1.1.140", "10.1.1.140"));
            System.out.println(IPUtilities.compareAddress("10.1.1.140", "10.1.1.253"));
            System.out.println(IPUtilities.compareAddress("10.1.1.140", "pcubepc138"));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.exit(1);
        }
    }

    public static IpRange[] convertIpAndExpTimeArrayToIpArray(IpRangeAndExpirationTime[] ipRangeAndExpirationTimeArray) {
        IpRange[] ipRangeArray = null;
        if (ipRangeAndExpirationTimeArray != null) {
            ipRangeArray = new IpRange[ipRangeAndExpirationTimeArray.length];
            for (int i = 0; i < ipRangeAndExpirationTimeArray.length; ++i) {
                ipRangeArray[i] = (IpRange)ipRangeAndExpirationTimeArray[i].getIpRange().clone();
            }
        }
        return ipRangeArray;
    }

    public static IpRangeAndExpirationTime[] convertIpArrayToIpAndExpTimeArray(IpRange[] ipRangeArray) {
        IpRangeAndExpirationTime[] ipRangeAndExpirationTimeArray = null;
        if (ipRangeArray != null) {
            ipRangeAndExpirationTimeArray = new IpRangeAndExpirationTime[ipRangeArray.length];
            for (int i = 0; i < ipRangeArray.length; ++i) {
                ipRangeAndExpirationTimeArray[i] = new IpRangeAndExpirationTime((IpRange)ipRangeArray[i].clone());
            }
        }
        return ipRangeAndExpirationTimeArray;
    }

    public static String[] convertIpArrayToStringArray(IpRange[] ipRangeArray) {
        String[] stringArray = null;
        if (ipRangeArray != null) {
            stringArray = new String[ipRangeArray.length];
            for (int i = 0; i < ipRangeArray.length; ++i) {
                stringArray[i] = ipRangeArray[i].toString();
            }
        }
        return stringArray;
    }

    public static String[] convertIpArrayAndVpnToStringArray(IpRange[] ipRangeArray, String string) {
        String[] stringArray = null;
        if (ipRangeArray != null && string != null) {
            stringArray = new String[ipRangeArray.length];
            for (int i = 0; i < ipRangeArray.length; ++i) {
                stringArray[i] = ipRangeArray[i].toString() + '@' + string;
            }
        }
        return stringArray;
    }

    public static final IpRange[] createIpRanges(long[] lArray, int[] nArray) {
        if (lArray == null || lArray.length == 0) {
            return new IpRange[0];
        }
        IpRange[] ipRangeArray = new IpRange[lArray.length];
        for (int i = 0; i < ipRangeArray.length; ++i) {
            ipRangeArray[i] = IpRange.createFromSignificantBits(lArray[i], (byte)nArray[i]);
        }
        return ipRangeArray;
    }

    public static final IpRangeAndExpirationTime[] createIpRangesAndExpTime(long[] lArray, int[] nArray, long[] lArray2) {
        IpRange[] ipRangeArray = IPUtilities.createIpRanges(lArray, nArray);
        if (ipRangeArray.length == 0) {
            return new IpRangeAndExpirationTime[0];
        }
        IpRangeAndExpirationTime[] ipRangeAndExpirationTimeArray = new IpRangeAndExpirationTime[ipRangeArray.length];
        for (int i = 0; i < ipRangeAndExpirationTimeArray.length; ++i) {
            ipRangeAndExpirationTimeArray[i] = new IpRangeAndExpirationTime(ipRangeArray[i], lArray2[i]);
        }
        return ipRangeAndExpirationTimeArray;
    }

    public static final TunneledIpRange[] createTunneledIpRanges(long[] lArray, int[] nArray, String[] stringArray) {
        IpRange[] ipRangeArray = IPUtilities.createIpRanges(lArray, nArray);
        if (ipRangeArray.length == 0) {
            return new TunneledIpRange[0];
        }
        TunneledIpRange[] tunneledIpRangeArray = new TunneledIpRange[ipRangeArray.length];
        for (int i = 0; i < tunneledIpRangeArray.length; ++i) {
            tunneledIpRangeArray[i] = new TunneledIpRange(ipRangeArray[i], stringArray[i]);
        }
        return tunneledIpRangeArray;
    }

    public static final TunneledIpRange[] createTunneledIpRanges(long[] lArray, int[] nArray, String[] stringArray, long[] lArray2) {
        IpRange[] ipRangeArray = IPUtilities.createIpRanges(lArray, nArray);
        if (ipRangeArray.length == 0) {
            return new TunneledIpRange[0];
        }
        TunneledIpRange[] tunneledIpRangeArray = new TunneledIpRange[ipRangeArray.length];
        for (int i = 0; i < tunneledIpRangeArray.length; ++i) {
            tunneledIpRangeArray[i] = lArray2[i] == -1L ? new TunneledIpRange(ipRangeArray[i], stringArray[i]) : new TunneledIpRange(ipRangeArray[i], new Community(lArray2[i], stringArray[i]));
        }
        return tunneledIpRangeArray;
    }

    public static final Community[] createCommunities(long[] lArray, String[] stringArray) {
        if (lArray == null) {
            return new Community[0];
        }
        Community[] communityArray = new Community[lArray.length];
        for (int i = 0; i < communityArray.length; ++i) {
            communityArray[i] = new Community(lArray[i], stringArray[i]);
        }
        return communityArray;
    }

    public static final Vlan[] createTunnelIDs(int[] nArray) {
        if (nArray == null) {
            return new Vlan[0];
        }
        Vlan[] vlanArray = new Vlan[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            vlanArray[i] = new Vlan(nArray[i]);
        }
        return vlanArray;
    }
}

