/*
 * Decompiled with CFR 0.152.
 */
package com.pcube.management.common;

import com.pcube.management.common.ArrayUtilities;
import com.pcube.management.common.InvocationDescriptor;
import com.pcube.management.framework.client.Batch;
import com.pcube.management.framework.functionality.Arguments;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class InvocationDescriptorImpl
implements InvocationDescriptor,
Serializable,
Externalizable {
    private int type;
    private ObjectName objectName;
    private String operationName;
    private Object[] params;
    private String[] signature;
    private String attributeName;
    private Attribute attribute;
    private String[] attributeNames;
    private AttributeList attributes;
    private Batch batch;
    private int batchMaxSize;
    protected String tostring = "InvocationDescriptorImpl";

    public InvocationDescriptorImpl() {
    }

    public InvocationDescriptorImpl(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) {
        this.type = 0;
        this.objectName = objectName;
        this.operationName = string;
        this.params = objectArray;
        this.signature = stringArray;
    }

    public InvocationDescriptorImpl(ObjectName objectName, String string) {
        this.type = 1;
        this.objectName = objectName;
        this.attributeName = string;
    }

    public InvocationDescriptorImpl(ObjectName objectName, String[] stringArray) {
        this.type = 3;
        this.objectName = objectName;
        this.attributeNames = stringArray;
    }

    public InvocationDescriptorImpl(ObjectName objectName, Attribute attribute) {
        this.type = 2;
        this.objectName = objectName;
        this.attribute = attribute;
    }

    public InvocationDescriptorImpl(ObjectName objectName, AttributeList attributeList) {
        this.type = 4;
        this.objectName = objectName;
        this.attributes = attributeList;
    }

    public InvocationDescriptorImpl(Batch batch, int n) {
        this.type = 5;
        this.batch = batch;
        this.batchMaxSize = n;
    }

    public int getType() {
        return this.type;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public Object[] getParams() {
        return this.params;
    }

    public String[] getSignature() {
        return this.signature;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public String[] getAttributeNames() {
        return this.attributeNames;
    }

    public AttributeList getAttributes() {
        return this.attributes;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.type = objectInput.readInt();
        switch (this.type) {
            case 0: {
                this.objectName = (ObjectName)objectInput.readObject();
                this.operationName = (String)objectInput.readObject();
                this.params = (Object[])objectInput.readObject();
                this.signature = (String[])objectInput.readObject();
                break;
            }
            case 1: {
                this.objectName = (ObjectName)objectInput.readObject();
                this.attributeName = (String)objectInput.readObject();
                break;
            }
            case 2: {
                this.objectName = (ObjectName)objectInput.readObject();
                this.attribute = (Attribute)objectInput.readObject();
                break;
            }
            case 3: {
                this.objectName = (ObjectName)objectInput.readObject();
                this.attributeNames = (String[])objectInput.readObject();
                break;
            }
            case 4: {
                this.objectName = (ObjectName)objectInput.readObject();
                this.attributes = (AttributeList)objectInput.readObject();
                break;
            }
            case 5: {
                this.batch = (Batch)objectInput.readObject();
                this.batchMaxSize = objectInput.readInt();
            }
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.type);
        switch (this.type) {
            case 0: {
                objectOutput.writeObject(this.objectName);
                objectOutput.writeObject(this.operationName);
                objectOutput.writeObject(this.params);
                objectOutput.writeObject(this.signature);
                break;
            }
            case 1: {
                objectOutput.writeObject(this.objectName);
                objectOutput.writeObject(this.attributeName);
                break;
            }
            case 2: {
                objectOutput.writeObject(this.objectName);
                objectOutput.writeObject(this.attribute);
                break;
            }
            case 3: {
                objectOutput.writeObject(this.objectName);
                objectOutput.writeObject(this.attributeNames);
                break;
            }
            case 4: {
                objectOutput.writeObject(this.objectName);
                objectOutput.writeObject(this.attributes);
                break;
            }
            case 5: {
                objectOutput.writeObject(this.batch);
                objectOutput.writeInt(this.batchMaxSize);
            }
        }
    }

    public Batch getBatch() {
        return this.batch;
    }

    public int getBatchMaxSize() {
        return this.batchMaxSize;
    }

    public String toString() {
        return " type= " + this.type + " ObjectName= " + this.objectName.toString() + " Operation name= " + this.operationName;
    }

    public void dump() {
        System.out.println("type:" + this.type);
        System.out.println("object:" + this.objectName.toString());
        System.out.println("operation:" + this.operationName);
        System.out.println("param:");
        if (this.params != null) {
            for (int i = 0; i < this.params.length; ++i) {
                if (this.params[i] != null && this.params[i] instanceof Arguments) {
                    Arguments arguments = (Arguments)this.params[i];
                    System.out.println("Arguments dump:");
                    arguments.dump(System.out);
                    continue;
                }
                System.out.println("Params dump");
                ArrayUtilities.printObject(System.out, (Object)this.params, "param");
            }
        }
        System.out.println("Signature:");
        ArrayUtilities.printObject(System.out, (Object)this.signature, "signature");
    }
}

