/*
 * Decompiled with CFR 0.152.
 */
package com.pcube.management.common;

import com.pcube.management.common.InvocationDescriptor;
import com.pcube.management.common.MBeanServerOperationDescriptor;
import com.pcube.management.framework.functionality.Arguments;
import com.sun.jdmk.ProxyHandler;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.loading.DefaultLoaderRepository;

public class InvocationHelper {
    private static final String STRING_CLASS_NAME = "java.lang.String";
    private static Hashtable signaturesTranslations = new Hashtable();

    public static Class[] stringArrayToClassArray(String[] stringArray) throws ClassNotFoundException {
        Class[] classArray = new Class[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("int")) {
                classArray[i] = Integer.TYPE;
                continue;
            }
            if (stringArray[i].equals("boolean")) {
                classArray[i] = Boolean.TYPE;
                continue;
            }
            if (stringArray[i].equals("float")) {
                classArray[i] = Float.TYPE;
                continue;
            }
            if (stringArray[i].equals("double")) {
                classArray[i] = Double.TYPE;
                continue;
            }
            if (stringArray[i].equals("byte")) {
                classArray[i] = Byte.TYPE;
                continue;
            }
            if (stringArray[i].equals("short")) {
                classArray[i] = Short.TYPE;
                continue;
            }
            if (stringArray[i].equals("long")) {
                classArray[i] = Long.TYPE;
                continue;
            }
            if (stringArray[i].equals("char")) {
                classArray[i] = Character.TYPE;
                continue;
            }
            String string = InvocationHelper.normalizeSignature(stringArray[i]);
            try {
                classArray[i] = DefaultLoaderRepository.loadClass(string);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                classArray[i] = Class.forName(string);
            }
        }
        return classArray;
    }

    private static String normalizeSignature(String string) {
        String string2 = (String)signaturesTranslations.get(string);
        if (string2 != null) {
            return string2;
        }
        if (string.endsWith("[]")) {
            string = InvocationHelper.normalizeArray(string);
        }
        return string;
    }

    private static String normalizeArray(String string) {
        if (string.endsWith("[]")) {
            return "[" + InvocationHelper.normalizeArray(string.substring(0, string.length() - 2));
        }
        return "L" + string + ";";
    }

    public static boolean compareSignatures(String string, String string2) {
        string = InvocationHelper.normalizeSignature(string);
        string2 = InvocationHelper.normalizeSignature(string2);
        return string.equals(string2);
    }

    public static Object[] instantiateStrings(String[] stringArray, String[] stringArray2) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Object[] objectArray = new Object[stringArray.length];
        Class[] classArray = new Class[]{String.class};
        for (int i = 0; i < stringArray.length; ++i) {
            objectArray[i] = stringArray[i].equals("int") ? new Integer(stringArray2[i]) : (stringArray[i].equals("boolean") ? (Serializable)new Boolean(stringArray2[i]) : (Serializable)(stringArray[i].equals("float") ? (Number)new Float(stringArray2[i]) : (Number)(stringArray[i].equals("double") ? (Number)new Double(stringArray2[i]) : (Number)(stringArray[i].equals("byte") ? (Number)new Byte(stringArray2[i]) : (Number)(stringArray[i].equals("short") ? (Number)new Short(stringArray2[i]) : (Number)(stringArray[i].equals("long") ? new Long(stringArray2[i]) : Class.forName(stringArray[i]).getConstructor(classArray).newInstance(stringArray2[i])))))));
        }
        return objectArray;
    }

    public static String[] stringToStringArray(String string, String string2) {
        if (string == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        int n = vector.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public static final String[] createSignature(Object[] objectArray) {
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = objectArray[i] == null ? STRING_CLASS_NAME : objectArray[i].getClass().getName();
        }
        return stringArray;
    }

    public static Object executeDescriptor(InvocationDescriptor invocationDescriptor, ProxyHandler proxyHandler) throws Exception {
        Object object = null;
        switch (invocationDescriptor.getType()) {
            case 0: {
                object = proxyHandler.invoke(invocationDescriptor.getObjectName(), invocationDescriptor.getOperationName(), invocationDescriptor.getParams(), invocationDescriptor.getSignature());
                break;
            }
            case 1: {
                object = proxyHandler.getAttribute(invocationDescriptor.getObjectName(), invocationDescriptor.getAttributeName());
                break;
            }
            case 2: {
                proxyHandler.setAttribute(invocationDescriptor.getObjectName(), invocationDescriptor.getAttribute());
                break;
            }
            case 3: {
                object = proxyHandler.getAttributes(invocationDescriptor.getObjectName(), invocationDescriptor.getAttributeNames());
                break;
            }
            case 4: {
                object = proxyHandler.setAttributes(invocationDescriptor.getObjectName(), invocationDescriptor.getAttributes());
                break;
            }
            case 5: {
                object = invocationDescriptor.getBatch().execute(proxyHandler);
            }
            default: {
                throw new IllegalArgumentException("Illegal invocation type:");
            }
        }
        return object;
    }

    public static Object executeDescriptor(MBeanServerOperationDescriptor mBeanServerOperationDescriptor, MBeanServer mBeanServer) throws Exception {
        Serializable serializable = null;
        switch (mBeanServerOperationDescriptor.getType()) {
            case 3: {
                serializable = mBeanServer.createMBean(mBeanServerOperationDescriptor.getClassName(), mBeanServerOperationDescriptor.getObjectName());
                break;
            }
            case 0: {
                serializable = mBeanServer.getMBeanInfo(mBeanServerOperationDescriptor.getObjectName());
                break;
            }
            case 1: {
                serializable = new Boolean(mBeanServer.isRegistered(mBeanServerOperationDescriptor.getObjectName()));
                break;
            }
            case 2: {
                mBeanServer.unregisterMBean(mBeanServerOperationDescriptor.getObjectName());
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal mbean server operation type:");
            }
        }
        return serializable;
    }

    public static final Arguments createArgumentsFromResult(Object object) {
        if (object == null) {
            return new Arguments();
        }
        if (object instanceof Arguments) {
            return (Arguments)object;
        }
        if (object instanceof Object[]) {
            return new Arguments((Object[])object);
        }
        throw new IllegalArgumentException("can't convert to arguments " + object);
    }

    static {
        signaturesTranslations.put("int[]", new int[0].getClass().getName());
        signaturesTranslations.put("float[]", new float[0].getClass().getName());
        signaturesTranslations.put("double[]", new double[0].getClass().getName());
        signaturesTranslations.put("boolean[]", new boolean[0].getClass().getName());
        signaturesTranslations.put("char[]", new char[0].getClass().getName());
        signaturesTranslations.put("byte[]", new byte[0].getClass().getName());
        signaturesTranslations.put("short[]", new short[0].getClass().getName());
        signaturesTranslations.put("long[]", new long[0].getClass().getName());
    }
}

