/*
 * Decompiled with CFR 0.152.
 */
package com.pcube.management.common;

import com.pcube.management.common.GenericIpRange;
import com.pcube.management.common.IPUtilities;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class IpRange
extends GenericIpRange
implements Cloneable,
Serializable {
    protected long ipAddress;
    protected long ipMask;

    public IpRange() {
        super(0L, 0L);
        this.ipAddress = 0L;
        this.ipMask = 0L;
    }

    public IpRange(long l, byte by) {
        this(l, IpRange.rangeToMask(by));
    }

    public IpRange(long l, long l2) throws IllegalArgumentException {
        super(IpRange.getMinIpAddr(l, l2), IpRange.getMaxIpAddr(l, l2));
        IpRange.checkMask(l2);
        this.ipAddress = l & l2;
        this.ipMask = l2;
    }

    private static void checkMask(long l) throws IllegalArgumentException {
        long l2 = l ^ 0xFFFFFFFFL;
        if ((l2 & l2 + 1L) != 0L) {
            throw new IllegalArgumentException(l + " (0x" + Long.toHexString(l) + ") is not a valid value for ip mask");
        }
    }

    public static IpRange createFromMask(long l, long l2) throws IllegalArgumentException {
        return new IpRange(l, l2);
    }

    public static IpRange createFromSignificantBits(long l, byte by) {
        if (by > 32 || by < 0) {
            throw new IllegalArgumentException(by + " is not a valid value for significant ip bits");
        }
        return new IpRange(l, IpRange.rangeToMask(by));
    }

    public static IpRange createFromLowHigh(long l, long l2) throws IllegalArgumentException {
        return IpRange.createFromMask(l, (l ^ l2 ^ 0xFFFFFFFFFFFFFFFFL) & 0xFFFFFFFFL);
    }

    public Object clone() {
        return new IpRange(this.ipAddress, this.getIpRange());
    }

    public long getIpAddr() {
        return this.ipAddress;
    }

    public static long getMinIpAddr(long l, long l2) {
        return l & l2;
    }

    public static long getMaxIpAddr(long l, long l2) {
        return (l | l2 ^ 0xFFFFFFFFFFFFFFFFL) & 0xFFFFFFFFL;
    }

    public byte getIpRange() {
        return this.getNumOfSignificantBits();
    }

    public byte getNumOfSignificantBits() {
        return IpRange.maskToRange(this.ipMask);
    }

    public long getRangeSize() {
        return ((this.ipMask ^ 0xFFFFFFFFFFFFFFFFL) & 0xFFFFFFFFL) + 1L;
    }

    public static byte maskToRange(long l) {
        int n;
        long l2 = 0xFFFFFFFFL;
        for (n = 0; n < 32 && (0xFFFFFFFFL & l2 << n) != (0xFFFFFFFFL & l); ++n) {
        }
        return (byte)(32 - n);
    }

    public long getIpMask() {
        return this.ipMask;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof IpRange) {
            return ((IpRange)object).getIpMask() == this.ipMask && ((IpRange)object).getIpAddr() == this.ipAddress;
        }
        return false;
    }

    public boolean contains(IpRange ipRange) {
        return (0xFFFFFFFFL & ipRange.getIpAddr() & this.ipMask) == this.getIpAddr() && this.ipMask <= ipRange.ipMask;
    }

    public String toString() {
        return IPUtilities.ipLongToString(this.ipAddress) + "/" + this.getIpRange();
    }

    public static long rangeToMask(byte by) {
        long l;
        if (by > 0 && by < 32) {
            l = (1 << by) - 1;
            l <<= 32 - by;
        } else {
            l = by == 0 ? 0L : 0xFFFFFFFFL;
        }
        return l;
    }

    public String getMinAsString() {
        return IPUtilities.ipLongToString(this.getIpAddr());
    }

    public String getMaskAsString() {
        return IPUtilities.ipLongToString(this.ipMask);
    }

    public long getSize() {
        return this.getRangeSize();
    }

    protected void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeLong(this.ipAddress);
        objectOutputStream.writeLong(this.ipMask);
    }

    protected void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.ipAddress = objectInputStream.readLong();
        this.ipMask = objectInputStream.readLong();
        this.lowIP = IpRange.getMinIpAddr(this.ipAddress, this.ipMask);
        this.highIP = IpRange.getMaxIpAddr(this.ipAddress, this.ipMask);
    }
}

