/*
 * Decompiled with CFR 0.152.
 */
package com.pcube.management.common;

import com.pcube.management.common.IpRange;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;

public class IpRangeAndExpirationTime
implements Cloneable,
Serializable {
    public static final long NO_EXPIRATION = -1L;
    protected IpRange ipRange;
    protected long expirationTime;

    public IpRangeAndExpirationTime(IpRange ipRange) {
        this(ipRange, -1L);
    }

    public IpRangeAndExpirationTime(IpRange ipRange, long l) {
        this.ipRange = ipRange;
        this.expirationTime = l;
        if (this.ipRange == null) {
            throw new IllegalArgumentException("IP range must not be null!");
        }
    }

    protected void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.ipRange.writeObject(objectOutputStream);
        objectOutputStream.writeLong(this.expirationTime);
    }

    protected void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.ipRange.readObject(objectInputStream);
        this.expirationTime = objectInputStream.readLong();
    }

    protected Object clone() throws CloneNotSupportedException {
        return new IpRangeAndExpirationTime((IpRange)this.ipRange.clone(), this.expirationTime);
    }

    public boolean equals(Object object) {
        if (object instanceof IpRangeAndExpirationTime) {
            return this.ipRange.equals(((IpRangeAndExpirationTime)object).ipRange);
        }
        if (object instanceof IpRange) {
            return this.ipRange.equals((IpRange)object);
        }
        return false;
    }

    public IpRange getIpRange() {
        return this.ipRange;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(long l) {
        this.expirationTime = l;
    }

    public String toString() {
        return this.ipRange.toString() + " (" + new Date(this.expirationTime) + ")";
    }
}

