/*
 * Decompiled with CFR 0.152.
 */
package com.pcube.management.common;

import com.pcube.management.common.ArrayUtilities;
import com.pcube.management.common.SparseArrayEntry;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.Vector;
import org.apache.log4j.Category;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class SparseArray
implements Serializable {
    private static final long serialVersionUID = -1283950532122619862L;
    private static Category logcat = Category.getInstance(SparseArray.class);
    protected Vector vector = null;
    protected int lastIndex = 0;
    protected SparseArrayEntry[] objects = null;
    protected int[] dimension = null;
    protected int[] dimMultiplication = null;
    static final String XML_ROOT = "sarray";
    static final String XML_ARRAY_DIMENSIONS = "dims";
    static final String XML_ARRAY_DIMENSION = "dim";
    static final String XML_ARRAY_ENTRIES = "entries";
    static final String XML_ARRAY_ENTRY = "entry";
    static final String XML_CLASS_ATTRIBUTE_NAME = "val_class";
    static final String XML_ARRAY_ENTRY_REPETITIONS_ATTRIBUTE_NAME = "reps";
    static final String XML_SIZE_ATTRIBUTE_NAME = "size";

    public SparseArray(int[] nArray) {
        this.dimension = nArray;
        this.vector = new Vector();
        this.createDimMultiplication();
    }

    public SparseArray() {
        this(new int[0]);
    }

    public SparseArray(Element element) {
        this();
        this.loadFromXMLDocument(element);
    }

    public SparseArray(long[] lArray) {
        this.dimension = new int[lArray.length];
        for (int i = 0; i < this.dimension.length; ++i) {
            this.dimension[i] = (int)lArray[i];
        }
        this.vector = new Vector();
        this.createDimMultiplication();
    }

    private void createDimMultiplication() {
        this.dimMultiplication = new int[this.dimension.length];
        int n = 1;
        for (int i = this.dimension.length - 1; i >= 0; --i) {
            this.dimMultiplication[i] = n;
            n *= this.dimension[i];
            if (this.dimension[i] > 0) continue;
            throw new RuntimeException("Illegal dimension in SparseArray construction: dimension[" + i + "] = " + this.dimension[i]);
        }
    }

    public int getLastFlatIndex() {
        return this.lastIndex;
    }

    public void add(Object object, int n) {
        this.vector.addElement(new SparseArrayEntry(this.lastIndex, n, object));
        this.lastIndex += n;
    }

    public void add(int n, int n2) {
        this.add(new Integer(n), n2);
    }

    protected int arrayFlattenUncompressedSize() {
        return this.dimMultiplication[0] * this.dimension[0];
    }

    public void finish() {
        if (this.lastIndex < this.arrayFlattenUncompressedSize()) {
            this.add(null, this.arrayFlattenUncompressedSize() - this.lastIndex);
        }
        this.mergeEntries(this.vector);
    }

    protected Object getFlatten(int n) {
        return this.getSparseArrayEntry(n).get(n);
    }

    private SparseArrayEntry getSparseArrayEntry(int n) {
        if (n < 0 || n >= this.lastIndex) {
            throw new ArrayIndexOutOfBoundsException("SparseArray Flatten flatIndex " + n);
        }
        int n2 = 0;
        int n3 = this.objects.length - 1;
        while (n2 <= n3) {
            int n4 = n2 + (n3 - n2) / 2;
            switch (this.objects[n4].isIndex(n)) {
                case 0: {
                    return this.objects[n4];
                }
                case 1: {
                    n2 = n4 + 1;
                    break;
                }
                case -1: {
                    n3 = n4 - 1;
                }
            }
        }
        throw new RuntimeException("SparseArray get - binary search did not find flatIndex : " + n);
    }

    public int[] getDimensions() {
        int[] nArray = new int[this.dimension.length];
        System.arraycopy(this.dimension, 0, nArray, 0, this.dimension.length);
        return nArray;
    }

    public SparseArrayEntry.ChangedIndex[] getChanges() {
        int n;
        LinkedList[] linkedListArray = new LinkedList[this.objects.length];
        int n2 = 0;
        for (n = 0; n < linkedListArray.length; ++n) {
            linkedListArray[n] = this.objects[n].changes;
            if (linkedListArray[n] == null) continue;
            n2 += linkedListArray[n].size();
        }
        n = 0;
        int n3 = 0;
        SparseArrayEntry.ChangedIndex[] changedIndexArray = new SparseArrayEntry.ChangedIndex[n2];
        for (int i = 0; i < linkedListArray.length; ++i) {
            if (linkedListArray[i] == null) continue;
            n3 = linkedListArray[i].size();
            for (int j = 0; j < n3; ++j) {
                changedIndexArray[n++] = (SparseArrayEntry.ChangedIndex)linkedListArray[i].get(j);
            }
        }
        if (n != n2) {
            throw new RuntimeException("Internal error index!=len (index=" + n + ",len=" + n2 + ")");
        }
        return changedIndexArray;
    }

    public void set(int n, Object object) {
        SparseArrayEntry sparseArrayEntry = this.getSparseArrayEntry(n);
        sparseArrayEntry.set(n, object);
    }

    public void set(int[] nArray, Object object) {
        this.set(this.calculatePosition(nArray), object);
    }

    public Object get(int n) {
        return this.getFlatten(n);
    }

    public Object get(int[] nArray) {
        return this.get(this.calculatePosition(nArray));
    }

    private int calculatePosition(int[] nArray) {
        int n = 0;
        for (int i = this.dimension.length - 1; i >= 0; --i) {
            if (nArray[i] >= this.dimension[i]) {
                throw new ArrayIndexOutOfBoundsException("SparseArray dimension " + i + " index " + nArray[i]);
            }
            n += nArray[i] * this.dimMultiplication[i];
        }
        return n;
    }

    public int getNumberOfEntries() {
        return this.objects.length;
    }

    public SparseArrayEntry[] getEntries() {
        this.rebuild();
        return this.objects;
    }

    public void rebuild() {
        Vector vector = new Vector();
        for (int i = 0; i < this.objects.length; ++i) {
            this.addSplitToVector(vector, this.objects[i].split());
        }
        if (vector.size() == this.objects.length) {
            this.objects = new SparseArrayEntry[vector.size()];
            vector.copyInto(this.objects);
            return;
        }
        this.mergeEntries(vector);
    }

    private void mergeEntries(Vector vector) {
        Vector<SparseArrayEntry> vector2 = new Vector<SparseArrayEntry>();
        SparseArrayEntry sparseArrayEntry = (SparseArrayEntry)vector.elementAt(0);
        int n = vector.size();
        for (int i = 1; i < n; ++i) {
            SparseArrayEntry sparseArrayEntry2 = (SparseArrayEntry)vector.elementAt(i);
            if (ArrayUtilities.compare(sparseArrayEntry2.object, sparseArrayEntry.object)) {
                sparseArrayEntry = sparseArrayEntry.merge(sparseArrayEntry2);
                continue;
            }
            sparseArrayEntry.changes = null;
            vector2.addElement(sparseArrayEntry);
            sparseArrayEntry = sparseArrayEntry2;
        }
        vector2.addElement(sparseArrayEntry);
        this.objects = new SparseArrayEntry[vector2.size()];
        vector2.copyInto(this.objects);
    }

    private void addSplitToVector(Vector vector, SparseArrayEntry[] sparseArrayEntryArray) {
        for (int i = 0; i < sparseArrayEntryArray.length; ++i) {
            vector.addElement(sparseArrayEntryArray[i]);
        }
    }

    public Object get(Vector vector) {
        int[] nArray = new int[vector.size()];
        for (int i = vector.size() - 1; i >= 0; --i) {
            nArray[i] = (Integer)vector.elementAt(i);
        }
        return this.get(nArray);
    }

    protected String toStringSub(int n, int[] nArray) {
        String string = "{ ";
        for (int i = 0; i < this.dimension[n]; ++i) {
            Object object;
            nArray[n] = i;
            string = n == this.dimension.length - 1 ? (null != (object = this.get(nArray)) ? string + this.get(nArray).toString() : string + "<null>") : string + this.toStringSub(n + 1, nArray);
            if (i >= this.dimension[n] - 1) continue;
            string = string + ", ";
        }
        string = string + "} ";
        return string;
    }

    public String toString() {
        int[] nArray = new int[this.dimension.length];
        return this.toStringSub(0, nArray);
    }

    public boolean equals(Object object) {
        if (object instanceof SparseArray) {
            SparseArray sparseArray = (SparseArray)object;
            boolean bl = this.lastIndex == sparseArray.lastIndex && ArrayUtilities.compare(this.dimension, sparseArray.dimension) && ArrayUtilities.compare(this.dimMultiplication, sparseArray.dimMultiplication) && ArrayUtilities.compare(this.objects, sparseArray.objects);
            return bl;
        }
        return false;
    }

    public boolean canBeSavedAsXML() {
        try {
            if (this.arrayFlattenUncompressedSize() == 0) {
                return true;
            }
            Object object = this.get(0);
            Object object2 = this.createValue(object.getClass().getName(), object.toString());
            return ArrayUtilities.compare(object, object2);
        }
        catch (Exception exception) {
            logcat.error((Object)"canBeSavedAsXML:: exception while converting values", (Throwable)exception);
            return false;
        }
    }

    private Object createValue(String string, String string2) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = Class.forName(string);
        Constructor<?> constructor = clazz.getConstructor(String.class);
        if (clazz == null) {
            return null;
        }
        Object obj = constructor.newInstance(string2);
        return obj;
    }

    public Element writeToXMLDocument(Document document) {
        Text text;
        Element element;
        Element element2 = document.createElement(XML_ROOT);
        Element element3 = document.createElement(XML_ARRAY_DIMENSIONS);
        for (int i = 0; i < this.dimension.length; ++i) {
            element = document.createElement(XML_ARRAY_DIMENSION);
            text = document.createTextNode(this.dimension[i] + "");
            element.appendChild(text);
            element3.appendChild(element);
        }
        element3.setAttribute(XML_SIZE_ATTRIBUTE_NAME, this.dimension.length + "");
        Element element4 = document.createElement(XML_ARRAY_ENTRIES);
        SparseArrayEntry[] sparseArrayEntryArray = this.getEntries();
        if (sparseArrayEntryArray.length > 0) {
            for (int i = 0; i < sparseArrayEntryArray.length; ++i) {
                element = document.createElement(XML_ARRAY_ENTRY);
                text = document.createTextNode(sparseArrayEntryArray[i].get().toString());
                element.appendChild(text);
                element.setAttribute(XML_ARRAY_ENTRY_REPETITIONS_ATTRIBUTE_NAME, sparseArrayEntryArray[i].getRepetition() + "");
                element4.appendChild(element);
            }
            element4.setAttribute(XML_CLASS_ATTRIBUTE_NAME, sparseArrayEntryArray[0].get().getClass().getName());
        }
        element4.setAttribute(XML_SIZE_ATTRIBUTE_NAME, sparseArrayEntryArray.length + "");
        element2.appendChild(element3);
        element2.appendChild(element4);
        return element2;
    }

    public void loadFromXMLDocument(Element element) throws IllegalArgumentException {
        if (element == null) {
            throw new IllegalArgumentException("Document must not be null");
        }
        if (!element.getNodeName().equals(XML_ROOT)) {
            throw new IllegalArgumentException("Invalid sparse array element name");
        }
        Element element2 = (Element)element.getFirstChild();
        Element element3 = (Element)element2.getNextSibling();
        int n = Integer.parseInt(element2.getAttribute(XML_SIZE_ATTRIBUTE_NAME));
        int n2 = Integer.parseInt(element3.getAttribute(XML_SIZE_ATTRIBUTE_NAME));
        this.dimension = new int[n];
        this.objects = new SparseArrayEntry[n2];
        Element element4 = (Element)element2.getFirstChild();
        for (int i = 0; i < this.dimension.length; ++i) {
            this.dimension[i] = Integer.parseInt(element4.getFirstChild().getNodeValue());
            element4 = (Element)element4.getNextSibling();
        }
        this.createDimMultiplication();
        String string = element3.getAttribute(XML_CLASS_ATTRIBUTE_NAME);
        element4 = (Element)element3.getFirstChild();
        int n3 = 0;
        for (int i = 0; i < this.objects.length; ++i) {
            Object object;
            int n4 = Integer.parseInt(element4.getAttribute(XML_ARRAY_ENTRY_REPETITIONS_ATTRIBUTE_NAME));
            String string2 = element4.getFirstChild().getNodeValue();
            try {
                object = this.createValue(string, string2);
            }
            catch (Exception exception) {
                logcat.error((Object)("loadFromXMLDocument:: could not create value class=" + string + " value=" + string2), (Throwable)exception);
                throw new IllegalArgumentException("Could not create value for the XML document");
            }
            this.objects[i] = new SparseArrayEntry(n3, n4, object);
            n3 += n4;
            element4 = (Element)element4.getNextSibling();
        }
        this.lastIndex = n3;
    }

    public Object clone() {
        SparseArray sparseArray = new SparseArray();
        sparseArray.dimension = new int[this.dimension.length];
        System.arraycopy(this.dimension, 0, sparseArray.dimension, 0, this.dimension.length);
        sparseArray.dimMultiplication = new int[this.dimMultiplication.length];
        System.arraycopy(this.dimMultiplication, 0, sparseArray.dimMultiplication, 0, this.dimMultiplication.length);
        sparseArray.lastIndex = this.lastIndex;
        sparseArray.objects = new SparseArrayEntry[this.objects.length];
        for (int i = 0; i < sparseArray.objects.length; ++i) {
            sparseArray.objects[i] = (SparseArrayEntry)this.objects[i].clone();
        }
        return sparseArray;
    }
}

