/*
 * Decompiled with CFR 0.152.
 */
package com.pcube.management.common;

import com.pcube.management.common.ArrayUtilities;
import com.pcube.management.common.ChangedListEntry;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Vector;

public class SparseArrayEntry
implements Serializable {
    protected int index;
    protected int repetition;
    protected Object object;
    LinkedList changes = null;

    public boolean isChanged() {
        return this.changes != null;
    }

    public SparseArrayEntry(int n, int n2, Object object) {
        if (n2 <= 0) {
            throw new RuntimeException("SparseArrayEntry constructor: repetition = " + this.repetition);
        }
        this.index = n;
        this.object = object;
        this.repetition = n2;
    }

    public int getRepetition() {
        return this.repetition;
    }

    public boolean isHomogenous() {
        return this.changes == null || this.changes.isEmpty();
    }

    public void set(int n, Object object) {
        if (this.isIndex(n) != 0) {
            throw new IllegalArgumentException("Invalid index " + n);
        }
        if (ArrayUtilities.compare(object, this.object)) {
            this.removeFromList(n);
            return;
        }
        if (this.changes == null) {
            this.changes = new LinkedList();
        }
        this.addToList(n, object);
    }

    public Object get(int n) {
        if (this.isIndex(n) != 0) {
            throw new ArrayIndexOutOfBoundsException("Illegal index " + n);
        }
        Object object = this.findInList(n);
        if (object != null) {
            return object;
        }
        return this.object;
    }

    public Object get() {
        return this.object;
    }

    public int getBeginIndex() {
        return this.index;
    }

    public int isIndex(int n) {
        return n < this.index ? -1 : (n > this.index + this.repetition - 1 ? 1 : 0);
    }

    public final ChangedIndex[] getChanges() {
        if (this.changes == null) {
            return new ChangedIndex[0];
        }
        ChangedListEntry[] changedListEntryArray = new ChangedListEntry[this.changes.size()];
        return this.changes.toArray(changedListEntryArray);
    }

    public SparseArrayEntry[] split() {
        if (this.changes == null) {
            return new SparseArrayEntry[]{this};
        }
        ListIterator listIterator = this.changes.listIterator();
        int n = this.index + this.repetition;
        Object object = this.get(this.index);
        Object object2 = null;
        int n2 = 0;
        int n3 = this.index;
        Vector<SparseArrayEntry> vector = new Vector<SparseArrayEntry>();
        ChangedListEntry changedListEntry = (ChangedListEntry)listIterator.next();
        for (int i = this.index; i < n; ++i) {
            if (changedListEntry != null && changedListEntry.flatIndex == i) {
                object2 = changedListEntry.value;
                changedListEntry = listIterator.hasNext() ? (ChangedListEntry)listIterator.next() : null;
            } else {
                object2 = this.object;
            }
            boolean bl = ArrayUtilities.compare(object2, object);
            if (bl) {
                ++n2;
                continue;
            }
            vector.addElement(new SparseArrayEntry(n3, n2, object));
            object = object2;
            n2 = 1;
            n3 = i;
        }
        vector.addElement(new SparseArrayEntry(n3, n2, object));
        Object[] objectArray = new SparseArrayEntry[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public String toString() {
        int n = 0;
        if (this.changes != null) {
            n = this.changes.size();
        }
        return this.index + "=>" + this.repetition + "X[" + this.object + "]; changes=" + n;
    }

    public SparseArrayEntry merge(SparseArrayEntry sparseArrayEntry) {
        int n;
        int n2 = n = this.index < sparseArrayEntry.index ? this.index : sparseArrayEntry.index;
        if (n == this.index) {
            this.checkSequencial(n, this.repetition, sparseArrayEntry.index);
        } else {
            this.checkSequencial(n, sparseArrayEntry.repetition, this.index);
        }
        if (sparseArrayEntry.changes == null && this.changes == null && ArrayUtilities.compare(sparseArrayEntry.object, this.object)) {
            return new SparseArrayEntry(n, this.repetition + sparseArrayEntry.repetition, this.object);
        }
        throw new IllegalArgumentException("Non matching entry");
    }

    public boolean equals(Object object) {
        if (object instanceof SparseArrayEntry) {
            SparseArrayEntry sparseArrayEntry = (SparseArrayEntry)object;
            if (this.repetition == sparseArrayEntry.repetition && this.index == sparseArrayEntry.index && ArrayUtilities.compare(this.object, sparseArrayEntry.object)) {
                if (this.changes != null && sparseArrayEntry.changes != null && this.changes.size() == sparseArrayEntry.changes.size()) {
                    Iterator iterator = this.changes.iterator();
                    Iterator iterator2 = sparseArrayEntry.changes.iterator();
                    while (iterator.hasNext()) {
                        if (ArrayUtilities.compare(iterator.next(), iterator2.next())) continue;
                        return false;
                    }
                    return true;
                }
                return this.changes == null && sparseArrayEntry.changes == null;
            }
        }
        return false;
    }

    private void removeFromList(int n) {
        if (this.changes == null) {
            return;
        }
        Iterator iterator = this.changes.iterator();
        while (iterator.hasNext()) {
            ChangedListEntry changedListEntry = (ChangedListEntry)iterator.next();
            if (changedListEntry.flatIndex < n) continue;
            if (changedListEntry.flatIndex == n) {
                iterator.remove();
                break;
            }
            if (changedListEntry.flatIndex <= n) continue;
        }
        if (this.changes.size() == 0) {
            this.changes = null;
        }
    }

    private Object findInList(int n) {
        if (this.changes == null) {
            return null;
        }
        for (ChangedListEntry changedListEntry : this.changes) {
            if (changedListEntry.flatIndex < n) continue;
            if (changedListEntry.flatIndex == n) {
                return changedListEntry.value;
            }
            if (changedListEntry.flatIndex <= n) continue;
            break;
        }
        return null;
    }

    private void addToList(int n, Object object) {
        if (this.changes.size() > 0) {
            ChangedListEntry changedListEntry = (ChangedListEntry)this.changes.getLast();
            if (changedListEntry.flatIndex < n) {
                this.changes.addLast(new ChangedListEntry(n, object));
                return;
            }
        } else {
            this.changes.add(new ChangedListEntry(n, object));
            return;
        }
        int n2 = 0;
        for (ChangedListEntry changedListEntry : this.changes) {
            if (changedListEntry.flatIndex < n) {
                ++n2;
                continue;
            }
            if (changedListEntry.flatIndex > n) {
                this.changes.add(n2, new ChangedListEntry(n, object));
                return;
            }
            if (!ArrayUtilities.compare(changedListEntry.value, object)) {
                changedListEntry.value = object;
            }
            return;
        }
        if (n2 == this.changes.size()) {
            this.changes.add(new ChangedListEntry(n, object));
        }
    }

    protected Object clone() {
        SparseArrayEntry sparseArrayEntry = new SparseArrayEntry(this.index, this.repetition, this.object);
        if (this.changes != null) {
            sparseArrayEntry.changes = (LinkedList)this.changes.clone();
        }
        return sparseArrayEntry;
    }

    private void checkSequencial(int n, int n2, int n3) {
        if (n + n2 != n3) {
            throw new IllegalArgumentException("Not sequencial !!!");
        }
    }

    public static interface ChangedIndex {
        public int getIndex();

        public Object getValue();
    }
}

