/*
 * Decompiled with CFR 0.152.
 */
package com.pcube.management.common;

public class StreamKMP {
    byte[] pattern;
    int[] failureTable;
    int patternPointer;

    public StreamKMP(String string) {
        this(string.getBytes());
    }

    public StreamKMP(byte[] byArray) {
        if (byArray.length < 3) {
            throw new IllegalArgumentException("Pattern length must be at least 3 characters");
        }
        this.pattern = byArray;
        this.computeFailureTable();
    }

    public boolean matchNext(byte by) {
        while (true) {
            if (by == this.pattern[this.patternPointer]) {
                ++this.patternPointer;
                break;
            }
            if (this.patternPointer == 0) break;
            this.patternPointer = this.failureTable[this.patternPointer - 1];
        }
        if (this.patternPointer == this.pattern.length) {
            this.patternPointer = this.failureTable[this.patternPointer - 1];
            return true;
        }
        return false;
    }

    void computeFailureTable() {
        this.failureTable = new int[this.pattern.length];
        this.failureTable[0] = 0;
        int n = 1;
        int n2 = 0;
        while (n < this.pattern.length) {
            if (this.pattern[n2] == this.pattern[n]) {
                this.failureTable[n] = n2 + 1;
                ++n;
                ++n2;
                continue;
            }
            if (n2 > 0) {
                n2 = this.failureTable[n2 - 1];
                continue;
            }
            this.failureTable[n] = 0;
            ++n;
        }
    }

    void debugPrintFailureTable() {
        for (int i = 0; i < this.failureTable.length; ++i) {
            System.out.print(this.failureTable[i] + ",");
        }
        System.out.println();
    }

    public static void main(String[] stringArray) {
        StreamKMP streamKMP = new StreamKMP(stringArray[0]);
        streamKMP.debugPrintFailureTable();
    }

    public void reset() {
        this.patternPointer = 0;
    }

    public int getState() {
        return this.patternPointer;
    }

    public void setState(int n) {
        this.patternPointer = n;
    }
}

