/*
 * Decompiled with CFR 0.152.
 */
package com.pcube.management.common;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.log4j.Category;

public class SystemProperties {
    private static final String DELIM_START = "${";
    private static final char DELIM_STOP = '}';
    private static final int DELIM_START_LEN = 2;
    private static final int DELIM_STOP_LEN = 1;
    private static boolean debugMode = System.getProperties().containsKey("com.pcube.inifile.debug");
    private static boolean iniFileRead = false;
    private static File defaultIniFile;

    public static int get(String string, int n) {
        return SystemProperties.get(string, n, true);
    }

    public static int get(String string, int n, boolean bl) {
        SystemProperties.checkReadDefaultIniFile();
        try {
            return Integer.parseInt(System.getProperty(string, "" + n));
        }
        catch (NumberFormatException numberFormatException) {
            if (bl) {
                SystemProperties.logger().warn((Object)("Illegal value specified in system property : " + string + " = " + System.getProperty(string)));
            }
            return n;
        }
    }

    public static boolean get(String string, boolean bl) {
        return SystemProperties.get(string, bl, true);
    }

    public static boolean get(String string, boolean bl, boolean bl2) {
        SystemProperties.checkReadDefaultIniFile();
        String string2 = System.getProperty(string);
        if (string2 == null) {
            return bl;
        }
        if (string2.equalsIgnoreCase("true")) {
            return true;
        }
        if (string2.equalsIgnoreCase("false")) {
            return false;
        }
        if (bl2) {
            SystemProperties.logger().warn((Object)("Illegal boolean value specified in system property : " + string + " = " + System.getProperty(string)));
        }
        return bl;
    }

    public static String get(String string, String string2) {
        SystemProperties.checkReadDefaultIniFile();
        String string3 = System.getProperty(string, string2);
        if (string3 != null) {
            string3 = SystemProperties.substVars(string3);
        }
        return string3;
    }

    public static void load(InputStream inputStream, boolean bl) throws IOException {
        Properties properties = new Properties();
        properties.load(inputStream);
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (bl || System.getProperty(string) == null) {
                if (debugMode) {
                    SystemProperties.debug("setting " + string + " to " + (String)properties.get(string));
                }
                System.getProperties().put(string, (String)properties.get(string));
                continue;
            }
            if (!debugMode) continue;
            SystemProperties.debug("skip setting " + string);
        }
    }

    public static synchronized boolean isDefaultIniFileRead() {
        return iniFileRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void checkReadDefaultIniFile() {
        if (SystemProperties.isDefaultIniFileRead()) {
            return;
        }
        iniFileRead = true;
        File file = SystemProperties.getDefaultIniFile();
        SystemProperties.debug("check existence of " + file);
        if (file.canRead()) {
            InputStream inputStream = null;
            try {
                inputStream = new BufferedInputStream(new FileInputStream(file));
                SystemProperties.debug("reading system properties from " + file);
                SystemProperties.load(inputStream, false);
            }
            catch (IOException iOException) {
                String string = "Error while reading ini file " + file + " : " + iOException;
                SystemProperties.debug(string);
                System.err.println(string);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        } else {
            SystemProperties.debug(file + " doesn't exist");
        }
    }

    public static void setSystemPropertyIfNotSet(String string, String string2) {
        try {
            SystemProperties.checkReadDefaultIniFile();
            String string3 = System.getProperty(string);
            if (!System.getProperties().containsKey(string)) {
                System.getProperties().put(string, string2);
            }
        }
        catch (Throwable throwable) {
            System.err.println("Could not set system property " + string);
            throwable.printStackTrace();
        }
    }

    public static synchronized File getDefaultIniFile() {
        String string = System.getProperty("com.pcube.inifile");
        if (string != null) {
            return new File(string);
        }
        if (defaultIniFile != null) {
            return defaultIniFile;
        }
        return new File(new File(System.getProperty("user.home"), ".p-cube"), "um.ini");
    }

    public static synchronized void setDefaultIniFile(File file) throws IllegalStateException {
        if (SystemProperties.isDefaultIniFileRead()) {
            throw new IllegalStateException("Default ini file has already been read");
        }
        SystemProperties.debug("setting default ini file to " + file);
        defaultIniFile = file;
        SystemProperties.checkReadDefaultIniFile();
    }

    public static String substVars(String string) throws IllegalArgumentException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (true) {
            int n2;
            if ((n2 = string.indexOf(DELIM_START, n)) == -1) {
                if (n == 0) {
                    return string;
                }
                stringBuffer.append(string.substring(n, string.length()));
                return stringBuffer.toString();
            }
            stringBuffer.append(string.substring(n, n2));
            int n3 = string.indexOf(125, n2);
            if (n3 == -1) {
                throw new IllegalArgumentException('\"' + string + "\" has no closing brace. Opening brace at position " + n2 + '.');
            }
            String string2 = string.substring(n2 += 2, n3);
            String string3 = System.getProperty(string2, null);
            if (string3 != null) {
                stringBuffer.append(string3);
            }
            n = n3 + 1;
        }
    }

    private static Category logger() {
        return Category.getInstance(SystemProperties.class);
    }

    private static void debug(String string) {
        if (debugMode) {
            System.out.println(SystemProperties.class.getName() + " : " + string);
        }
    }
}

