/*
 * Decompiled with CFR 0.152.
 */
package com.pcube.management.common;

import com.pcube.management.common.Exceptions;
import com.pcube.management.common.ExceptionsSetWrapper;
import java.util.Vector;

abstract class ThrowableDumpHelper {
    private Vector loopDetectionVector = new Vector();

    protected ThrowableDumpHelper() {
    }

    protected void preDumpInit() {
        this.loopDetectionVector.clear();
    }

    protected void dump(Throwable throwable, int n) {
        if (throwable == null) {
            return;
        }
        this.appendExceptionTitle(throwable + "");
        if (this.loopDetectionVector.contains(throwable)) {
            this.appendSubTitle("Detected cycle!!!");
            return;
        }
        if (n > 0) {
            this.appendSubTitle("*** Wrapped Exception (wrapping level " + n + ")");
        }
        this.appendThrowableStackTrace(throwable);
        this.loopDetectionVector.add(throwable);
        if (throwable instanceof ExceptionsSetWrapper) {
            Throwable[] throwableArray = ((ExceptionsSetWrapper)((Object)throwable)).getWrappedThrowables();
            for (int i = 0; i < throwableArray.length; ++i) {
                this.appendSubTitle("*** Wrapped Exceptions Set Dumping - element " + (i + 1) + " of " + throwableArray.length + " elements:");
                if (throwableArray[i] != null) {
                    this.dump(throwableArray[i], n + 1);
                    continue;
                }
                this.appendTitle("null");
            }
        } else {
            this.dump(Exceptions.getWrappedThrowable(throwable), n + 1);
        }
    }

    protected void appendExceptionTitle(String string) {
        this.appendTitle(string);
    }

    protected abstract void appendTitle(String var1);

    protected abstract void appendSubTitle(String var1);

    protected abstract void appendThrowableStackTrace(Throwable var1);
}

