/*
 * Decompiled with CFR 0.152.
 */
package com.pcube.management.common;

import com.pcube.management.common.Community;
import com.pcube.management.common.IPUtilities;
import com.pcube.management.common.IpRange;
import java.io.Serializable;

public class TunneledIpRange
implements Cloneable,
Serializable {
    IpRange ipRange;
    String vpnName;
    Community community = null;
    public static final char VPN_SEPARATOR = '@';

    public TunneledIpRange() {
    }

    public TunneledIpRange(IpRange ipRange, String string) {
        this.ipRange = ipRange;
        this.vpnName = string;
    }

    public TunneledIpRange(IpRange ipRange, Community community) {
        this.ipRange = ipRange;
        this.community = community;
        this.vpnName = community.getVpn();
    }

    public TunneledIpRange(String string) {
        this(IPUtilities.parseToRange("0.0.0.0/0"), string);
    }

    public TunneledIpRange(int n) {
        this(IPUtilities.parseToRange("0.0.0.0/0"), n + "");
    }

    public String getVpn() {
        return this.vpnName;
    }

    public IpRange getIpRange() {
        return this.ipRange;
    }

    public Community getCommunity() {
        return this.community;
    }

    public String toString() {
        return this.ipRange.toString() + '@' + this.vpnName;
    }

    public String toStringWithCommunity() {
        if (this.community == null) {
            return this.toString();
        }
        return this.toString() + ':' + Long.toHexString(this.community.getCommunity());
    }

    public boolean equals(Object object) {
        TunneledIpRange tunneledIpRange = (TunneledIpRange)object;
        if (this.community != null) {
            return this.ipRange.equals(tunneledIpRange.getIpRange()) && this.vpnName.equals(tunneledIpRange.getVpn()) && this.community.equals(tunneledIpRange.getCommunity());
        }
        return this.ipRange.equals(tunneledIpRange.getIpRange()) && this.vpnName.equals(tunneledIpRange.getVpn());
    }
}

