/*
 * Decompiled with CFR 0.152.
 */
package com.pcube.management.common;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class Vlan
implements Cloneable,
Serializable {
    private short vlan;
    public static final short MAX_VLAN = 4095;

    public Vlan(int n) throws IllegalArgumentException {
        if (!Vlan.isValid(n)) {
            throw new IllegalArgumentException("Illegal vlan value " + n);
        }
        this.vlan = (short)n;
    }

    public Object clone() {
        return new Vlan(this.vlan);
    }

    public short getVlan() {
        return this.vlan;
    }

    public static boolean isValid(int n) {
        return n <= 4095 && n >= 0;
    }

    public int hashCode() {
        return this.vlan;
    }

    public boolean equals(Object object) {
        if (object instanceof Vlan) {
            return this.vlan == ((Vlan)object).vlan;
        }
        return false;
    }

    public String toString() {
        return Integer.toString(this.vlan);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeShort(this.vlan);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.vlan = objectInputStream.readShort();
    }
}

