/*
 * Decompiled with CFR 0.152.
 */
package com.pcube.management.common.auth;

import java.security.MessageDigest;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import org.apache.log4j.Category;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.engines.AESLightEngine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SecurityUtils {
    private static Category logcat;

    public static byte[] generateSecureRandomKey(int n) {
        try {
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            byte[] byArray = secureRandom.generateSeed(n);
            logcat.debug((Object)("Created random seed " + byArray.length));
            return byArray;
        }
        catch (Exception exception) {
            logcat.error((Object)"Failed to create random seed", (Throwable)exception);
            return null;
        }
    }

    public static byte[] getKeyedMD5Digest(byte[] byArray, byte[] byArray2) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(byArray);
            return messageDigest.digest(byArray2);
        }
        catch (Exception exception) {
            logcat.error((Object)("Exception occured when trying to calculate message digest: " + exception.getMessage()));
            return null;
        }
    }

    private static byte[] callCipher(byte[] byArray, BufferedBlockCipher bufferedBlockCipher) throws CryptoException {
        int n = bufferedBlockCipher.getOutputSize(byArray.length);
        byte[] byArray2 = new byte[n];
        int n2 = bufferedBlockCipher.processBytes(byArray, 0, byArray.length, byArray2, 0);
        if ((n2 += bufferedBlockCipher.doFinal(byArray2, n2)) < n) {
            byte[] byArray3 = new byte[n2];
            System.arraycopy(byArray2, 0, byArray3, 0, n2);
            byArray2 = byArray3;
        }
        return byArray2;
    }

    public static byte[] encrypt(byte[] byArray, byte[] byArray2) {
        try {
            if (byArray == null || byArray.length == 0) {
                return new byte[0];
            }
            long l = System.currentTimeMillis();
            AESLightEngine aESLightEngine = new AESLightEngine();
            PaddedBufferedBlockCipher paddedBufferedBlockCipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)aESLightEngine));
            KeyParameter keyParameter = new KeyParameter(byArray2);
            paddedBufferedBlockCipher.init(true, (CipherParameters)keyParameter);
            byte[] byArray3 = SecurityUtils.callCipher(byArray, (BufferedBlockCipher)paddedBufferedBlockCipher);
            return byArray3;
        }
        catch (CryptoException cryptoException) {
            logcat.error((Object)("Exception occured when trying to decrypt a buffer: " + cryptoException.getMessage()));
            return null;
        }
    }

    public static byte[] decrypt(byte[] byArray, byte[] byArray2) {
        try {
            if (byArray == null || byArray.length == 0) {
                return new byte[0];
            }
            AESLightEngine aESLightEngine = new AESLightEngine();
            PaddedBufferedBlockCipher paddedBufferedBlockCipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)aESLightEngine));
            KeyParameter keyParameter = new KeyParameter(byArray2);
            paddedBufferedBlockCipher.init(false, (CipherParameters)keyParameter);
            byte[] byArray3 = SecurityUtils.callCipher(byArray, (BufferedBlockCipher)paddedBufferedBlockCipher);
            return byArray3;
        }
        catch (CryptoException cryptoException) {
            logcat.error((Object)("Exception occured when trying to decrypt a buffer: " + cryptoException.getMessage()));
            return null;
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        logcat = Category.getInstance(SecurityUtils.class);
    }
}

