/*
 * Decompiled with CFR 0.152.
 */
package com.pcube.management.common.threads;

import java.util.ArrayList;
import org.apache.log4j.Category;

public class ObjectFIFO {
    private static final int HUNDRED_PERCENT = 100;
    private static Category logcat = Category.getInstance(ObjectFIFO.class);
    private int capacityEnlargment = 100;
    private boolean allowGrow;
    private Object[] queue;
    private int capacity;
    private int size;
    private int head;
    private int tail;
    private long inCnt = 0L;
    private long outCnt = 0L;
    private long highWater = 0L;
    private String desc = "";

    public ObjectFIFO(int n, boolean bl) {
        this.capacity = n > 0 ? n : 1;
        this.queue = new Object[this.capacity];
        this.head = 0;
        this.tail = 0;
        this.size = 0;
        this.allowGrow = bl;
    }

    public ObjectFIFO(int n, boolean bl, String string) {
        this(n, bl);
        this.desc = string;
    }

    public synchronized void ensureCapacity(int n) {
        if (this.capacity >= n) {
            return;
        }
        this.copyQueue(n);
    }

    private synchronized void copyQueue(int n) {
        if (logcat.isDebugEnabled()) {
            logcat.debug((Object)("Enlarging fifo queue to " + n + " - " + this.toString()), (Throwable)new Exception());
        }
        if (this.size > n) {
            throw new RuntimeException("size > newCapacity : " + this.size + " > " + n);
        }
        Object[] objectArray = new Object[n];
        if (this.size == 0) {
            this.head = 0;
            this.tail = 0;
        } else {
            if (this.capacity - this.tail > 0) {
                System.arraycopy(this.queue, this.tail, objectArray, 0, Math.min(this.size, this.capacity - this.tail));
            }
            if (this.head <= this.tail && this.head > 0) {
                System.arraycopy(this.queue, 0, objectArray, this.capacity - this.tail, this.head);
            }
            this.tail = 0;
            this.head = this.size;
        }
        this.queue = objectArray;
        this.capacity = n;
    }

    public synchronized Object[] reduceCapacity(int n) throws InterruptedException {
        if (this.capacity <= n) {
            return new Object[0];
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (this.size > n) {
            arrayList.add(this.remove());
        }
        this.copyQueue(n);
        return arrayList.toArray();
    }

    public synchronized int getFreeSlots() {
        return this.getCapacity() - this.getSize();
    }

    public synchronized int getCapacity() {
        return this.capacity;
    }

    public synchronized int getSize() {
        return this.size;
    }

    public synchronized boolean isEmpty() {
        return this.size == 0;
    }

    public synchronized boolean isFull() {
        return this.size == this.capacity && !this.allowGrow;
    }

    public synchronized void add(Object object) throws InterruptedException {
        if (this.allowGrow) {
            if (this.size == this.capacity) {
                this.ensureCapacity(this.size * (100 + this.capacityEnlargment) / 100);
            }
        } else {
            this.waitWhileFull();
        }
        this.queue[this.head] = object;
        this.head = (this.head + 1) % this.capacity;
        ++this.size;
        ++this.inCnt;
        if ((long)this.size > this.highWater) {
            this.highWater = this.size;
        }
        this.notifyAll();
    }

    public synchronized boolean add(Object object, long l) throws InterruptedException {
        if (this.allowGrow) {
            if (this.size == this.capacity) {
                this.ensureCapacity(this.size * (100 + this.capacityEnlargment) / 100);
            }
        } else if (!this.waitWhileFull(l)) {
            return false;
        }
        this.queue[this.head] = object;
        this.head = (this.head + 1) % this.capacity;
        ++this.size;
        ++this.inCnt;
        if ((long)this.size > this.highWater) {
            this.highWater = this.size;
        }
        this.notifyAll();
        return true;
    }

    public synchronized void addEach(Object[] objectArray) throws InterruptedException {
        for (int i = 0; i < objectArray.length; ++i) {
            this.add(objectArray[i]);
        }
    }

    public synchronized Object remove() throws InterruptedException {
        this.waitWhileEmpty();
        Object object = this.queue[this.tail];
        this.queue[this.tail] = null;
        this.tail = (this.tail + 1) % this.capacity;
        --this.size;
        ++this.outCnt;
        this.notifyAll();
        return object;
    }

    public synchronized Object[] removeAll() throws InterruptedException {
        Object[] objectArray = new Object[this.size];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = this.remove();
        }
        return objectArray;
    }

    public synchronized Object[] removeMultiple(int n) throws InterruptedException {
        Object[] objectArray = new Object[Math.min(this.size, n)];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = this.remove();
        }
        return objectArray;
    }

    public synchronized Object[] removeAtLeastOne() throws InterruptedException {
        this.waitWhileEmpty();
        return this.removeAll();
    }

    public synchronized Object[] removeAtLeastOne(int n) throws InterruptedException {
        if (n <= 0) {
            throw new IllegalArgumentException("maxNum = " + n);
        }
        this.waitWhileEmpty();
        return this.removeMultiple(n);
    }

    public synchronized boolean waitUntilEmpty(long l) throws InterruptedException {
        if (l == 0L) {
            this.waitUntilEmpty();
            return true;
        }
        long l2 = System.currentTimeMillis() + l;
        long l3 = l;
        while (!this.isEmpty() && l3 > 0L) {
            this.wait(l3);
            l3 = l2 - System.currentTimeMillis();
        }
        return this.isEmpty();
    }

    public synchronized void waitUntilEmpty() throws InterruptedException {
        while (!this.isEmpty()) {
            this.wait();
        }
    }

    public synchronized void waitWhileEmpty() throws InterruptedException {
        while (this.isEmpty()) {
            this.wait();
        }
    }

    public synchronized void waitUntilFull() throws InterruptedException {
        while (!this.isFull()) {
            this.wait();
        }
    }

    public synchronized void waitWhileFull() throws InterruptedException {
        while (this.isFull()) {
            this.wait();
        }
    }

    public synchronized boolean waitWhileFull(long l) throws InterruptedException {
        long l2;
        for (long i = l; i > 0L && this.isFull(); i -= Math.max(0L, System.currentTimeMillis() - l2)) {
            l2 = System.currentTimeMillis();
            this.wait(i);
        }
        return !this.isFull();
    }

    public synchronized boolean waitWhileEmpty(long l) throws InterruptedException {
        long l2;
        for (long i = l; i > 0L && this.isEmpty(); i -= Math.max(0L, System.currentTimeMillis() - l2)) {
            l2 = System.currentTimeMillis();
            this.wait(i);
        }
        return !this.isEmpty();
    }

    public String toString() {
        return this.getClass().getName() + '[' + this.desc + ",capacity=" + this.capacity + ",size=" + this.size + ",tail= " + this.tail + ",head=" + this.head + ",allowGrow=" + this.allowGrow + ",inCnt=" + this.inCnt + ",outCnt=" + this.outCnt + ",highWater= " + this.highWater + ']';
    }

    public long getInCounter() {
        return this.inCnt;
    }

    public long getOutCounter() {
        return this.outCnt;
    }

    public long getHighWaterLine() {
        return this.highWater;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetStatistics() {
        ObjectFIFO objectFIFO = this;
        synchronized (objectFIFO) {
            this.inCnt = 0L;
            this.outCnt = 0L;
            this.highWater = 0L;
        }
    }

    public double getUtilization() {
        return (double)this.size / (double)this.capacity;
    }
}

