/*
 * Decompiled with CFR 0.152.
 */
package com.pcube.management.common.time;

import com.pcube.management.common.time.TimestampController;

public class BasicTimestampController
implements TimestampController,
Runnable {
    public static final long DEFAULT_ACCURACY_IN_MILLI = 5000L;
    public static final long MIN_ACCURACY_IN_MILLI = 1000L;
    protected long offsetFromSystemTimeInMilli = 0L;
    protected volatile long accuracyInMilli = 5000L;
    protected long lastSystemTimeInMilli = System.currentTimeMillis();
    protected Thread timestampThread = null;

    public String toString() {
        return super.toString();
    }

    public BasicTimestampController() {
        this(5000L, true);
    }

    public BasicTimestampController(long l) {
        this(l, true);
    }

    public BasicTimestampController(long l, boolean bl) {
        this.accuracyInMilli = l;
        this.timestampThread = new Thread((Runnable)this, "TimestampController");
        if (bl) {
            this.timestampThread.start();
        }
    }

    public long getCurrentTimeStampInMilli() {
        return this.internalGetCurrentTime();
    }

    public void setAccuracy(long l) throws IllegalArgumentException {
        if (l < 1000L) {
            throw new IllegalArgumentException("Accuracy must be greater than 1000 (" + l + ')');
        }
        this.accuracyInMilli = l;
    }

    protected synchronized long internalGetCurrentTime() {
        long l = System.currentTimeMillis();
        if (l - this.lastSystemTimeInMilli > this.accuracyInMilli || l < this.lastSystemTimeInMilli) {
            this.offsetFromSystemTimeInMilli -= l - this.lastSystemTimeInMilli;
        }
        this.lastSystemTimeInMilli = l;
        return l + this.offsetFromSystemTimeInMilli;
    }

    public void run() {
        try {
            this.timestampThread.setPriority(6);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        while (this.accuracyInMilli > 0L) {
            try {
                Thread.sleep(this.accuracyInMilli >> 1);
                this.internalGetCurrentTime();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public void terminate() {
        this.accuracyInMilli = -1L;
        this.timestampThread.interrupt();
    }
}

