/*
 * Decompiled with CFR 0.152.
 */
package com.pcube.management.framework.agent;

import com.pcube.management.common.HashUtilities;
import com.pcube.management.framework.agent.ConfigurationEntry;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;

public final class Configuration {
    protected static HashMap entries = new HashMap();

    private Configuration() {
    }

    public String toString() {
        return super.toString();
    }

    public static void addEntry(ConfigurationEntry configurationEntry) throws IllegalArgumentException {
        if (entries.containsKey(configurationEntry.getKey())) {
            throw new IllegalArgumentException("Configuration entry: " + configurationEntry.getKey() + " already exists");
        }
        entries.put(configurationEntry.getKey(), configurationEntry);
    }

    public static String getValue(String string) {
        ConfigurationEntry configurationEntry = Configuration.getEntry(string);
        if (configurationEntry != null) {
            return configurationEntry.get();
        }
        return null;
    }

    public static ConfigurationEntry getEntry(String string) {
        return (ConfigurationEntry)entries.get(string);
    }

    public static void setEntryDefaultValue(String string, String string2) throws IllegalArgumentException {
        ConfigurationEntry configurationEntry = (ConfigurationEntry)entries.get(string);
        if (configurationEntry == null) {
            throw new IllegalArgumentException("Configuration entry " + string + " doesn't exists");
        }
        configurationEntry.setDefaultValue(string2);
    }

    public static void printHelp() {
        Collection collection = entries.values();
        ConfigurationEntry[] configurationEntryArray = collection.toArray(new ConfigurationEntry[collection.size()]);
        Arrays.sort(configurationEntryArray, new Comparator(){

            public int compare(Object object, Object object2) {
                ConfigurationEntry configurationEntry = (ConfigurationEntry)object;
                ConfigurationEntry configurationEntry2 = (ConfigurationEntry)object2;
                return configurationEntry.toString().compareTo(configurationEntry2.toString());
            }
        });
        for (int i = 0; i < configurationEntryArray.length; ++i) {
            ConfigurationEntry configurationEntry = configurationEntryArray[i];
            configurationEntry.print();
            System.out.println("");
        }
    }

    public static void printInfo(PrintWriter printWriter) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Collection collection = entries.values();
        for (ConfigurationEntry configurationEntry : collection) {
            if (configurationEntry.isHidden()) continue;
            hashMap.put(configurationEntry.getKey(), configurationEntry.get());
        }
        HashUtilities.printSorted(hashMap, printWriter, 0);
    }

    static {
        Configuration.addEntry(new ConfigurationEntry("filemanager.defaultPath", "/", "Root path for the file manager", "any path. if path is not ending with a file seperator, one will be added automatically." + System.getProperty("line.separator") + "Special care must be put to make sure this path is OS independat (file seoperator is OS " + "dependant!)"));
        Configuration.addEntry(new ConfigurationEntry("filemanager.installPath", "/", "Root path for directory where the agent installs packages", "any path. if path is not ending with a file seperator, one will be added automatically." + System.getProperty("line.separator") + "Special care must be put to make sure this path is OS independat (file seoperator is OS " + "dependant!)"));
        Configuration.addEntry(new ConfigurationEntry("filemanager.codePath", "/", "Root path for directory where the agent's code exist in", "any path. if path is not ending with a file seperator, one will be added automatically." + System.getProperty("line.separator") + "Special care must be put to make sure this path is OS independat (file seoperator is OS " + "dependant!)"));
        Configuration.addEntry(new ConfigurationEntry("debugMode", "false", "Set debug mode, any MBean / component that checks act accordingly", "true or false", true));
        Configuration.addEntry(new ConfigurationEntry("mbeancfg", "mbeancfg.txt", "Filename string including extension", "valid filename. Please note that if direcroty is also specified, it must be built with a valid system dependant seperator"));
        Configuration.addEntry(new ConfigurationEntry("log4j.iniFile", "$log4j.ini", "Log4j init file", "file name ($ prefix marks it as relative to agent's root)"));
        Configuration.addEntry(new ConfigurationEntry("consoleShutdownEnabled", "false", "Enable shutdown of entity from console (standard input) by typing Enter", "true or false"));
    }
}

