/*
 * Decompiled with CFR 0.152.
 */
package com.pcube.management.framework.agent;

public class ConfigurationEntry {
    protected static final String KEY_PREFIX = "com.pcube.";
    protected String key;
    protected String defaultValue;
    protected String description;
    protected String validValues;
    protected boolean hidden;

    public ConfigurationEntry(String string, String string2, String string3, String string4) {
        this.key = string;
        this.defaultValue = string2;
        this.description = string3;
        this.validValues = string4;
        this.hidden = false;
    }

    public ConfigurationEntry(String string, String string2, String string3, String string4, boolean bl) {
        this(string, string2, string3, string4);
        this.hidden = bl;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setDefaultValue(String string) {
        this.defaultValue = string;
    }

    public String get() {
        String string = System.getProperty(KEY_PREFIX + this.key, null);
        if (string == null) {
            string = this.defaultValue;
        }
        return string;
    }

    public int getInt() {
        return Integer.parseInt(this.get());
    }

    public boolean getBoolean() {
        return new Boolean(this.get());
    }

    public String getKey() {
        return this.key;
    }

    public String toString() {
        return KEY_PREFIX + this.key + "=" + this.get();
    }

    public void print() {
        if (!this.isHidden()) {
            System.out.println("key          : com.pcube." + this.key);
            System.out.println("description  : " + this.description);
            System.out.println("valid values : " + this.validValues);
            System.out.println("default value: " + this.defaultValue);
            System.out.println("current value: " + this.get());
        }
    }
}

