/*
 * Decompiled with CFR 0.152.
 */
package com.pcube.management.framework.agent;

import com.pcube.management.common.CompleteConfFile;
import com.pcube.management.common.threads.ObjectFIFO;
import com.pcube.management.framework.agent.Configuration;
import com.pcube.management.framework.agent.StatisticsFile;
import com.pcube.management.framework.agent.StatsVar;
import com.pcube.management.framework.functionality.Arguments;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Category;

public class Statistics {
    private static final int MSG_QUEUE_SIZE = 500;
    private final int msgQueueSize = 500;
    private boolean reportVarsChanged = true;
    private HashMap statsMap = new HashMap();
    private HashMap statsConfMap = new HashMap();
    private HashMap statsConfSuffixMap = new HashMap();
    private HashMap reportVars = new HashMap();
    private StatisticsFile statisticFile = null;
    private StatisticsFile statisticHeaderFile = null;
    private static Statistics statisticsInstance = null;
    private static final String DEFAULT_STATS_CONFIG_FILE = "com/pcube/management/framework/agent/stats-config.txt";
    private static final String ADDITIONAL_CONFIG_FILE_FOLDER = "stats" + File.separator + "config";
    private static final String CONFIGURATION_SECTION = "STATS";
    private static final String COUNTER_PLACEHOLDER = "CNT";
    private static final String GLOBAL_PEAK_RATE_PLACEHOLDER = "GPR";
    private static final String LOCAL_PEAK_RATE_PLACEHOLDER = "LPR";
    private static final String STATS_FILE_NAME = "stats" + File.separator + "log" + File.separator + "statslog";
    private static final String STATS_HEADER_FILE_NAME = "stats" + File.separator + "log" + File.separator + "headlog";
    private static Category logcat = Category.getInstance(Statistics.class);
    private long lastTimeMillis = System.currentTimeMillis();
    ObjectFIFO msgQueue = new ObjectFIFO(500, true);

    public String toString() {
        return super.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Statistics getInstance() {
        Class<Statistics> clazz = Statistics.class;
        synchronized (Statistics.class) {
            if (statisticsInstance == null && statisticsInstance == null) {
                statisticsInstance = new Statistics();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return statisticsInstance;
        }
    }

    public Statistics() {
        this.configureStatsFile();
        this.statisticFile = new StatisticsFile(STATS_FILE_NAME);
        this.statisticHeaderFile = new StatisticsFile(STATS_HEADER_FILE_NAME);
    }

    public void updateRates() {
        long l = System.currentTimeMillis();
        ArrayList arrayList = this.getSafeStatsVar();
        StatsVar statsVar = null;
        long l2 = this.lastTimeMillis;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            statsVar = (StatsVar)arrayList.get(i);
            statsVar.calculateRate(l - l2);
        }
        this.lastTimeMillis = l;
    }

    public void dumpToFile() {
        logcat.debug((Object)"In Statistics.dumpToFile");
        this.handleQueueMessages();
        if (this.reportVarsChanged) {
            this.dumpFileHeader();
            this.reportVarsChanged = false;
        }
        this.dumpVariables();
    }

    public void resetCounter(String string) {
        ((StatsVar)this.statsMap.get(string)).reset();
    }

    public void resetCounters(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.resetCounter(stringArray[i]);
        }
    }

    public void resetCounters(String string) {
        ArrayList arrayList = this.getSafeStatsVar();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            StatsVar statsVar = (StatsVar)arrayList.get(i);
            if (!statsVar.getName().startsWith(string)) continue;
            statsVar.reset();
        }
    }

    public void resetAllCounters() {
        ArrayList arrayList = this.getSafeStatsVar();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            ((StatsVar)arrayList.get(i)).reset();
        }
    }

    public Arguments[] getCounter(String string) {
        Arguments[] argumentsArray = new Arguments[3];
        Arguments arguments = new Arguments();
        Arguments arguments2 = new Arguments();
        Arguments arguments3 = new Arguments();
        StatsVar statsVar = (StatsVar)this.statsMap.get(string);
        if (statsVar != null) {
            arguments.putArgument(statsVar.getName(), new Long(statsVar.getCounter()));
            arguments2.putArgument(statsVar.getName(), new Double(statsVar.getRate()));
            arguments3.putArgument(statsVar.getName(), new Double(statsVar.getGlobalPeakRate()));
        }
        argumentsArray[0] = arguments;
        argumentsArray[1] = arguments2;
        argumentsArray[2] = arguments3;
        return argumentsArray;
    }

    public Arguments[] getCounters(String[] stringArray) {
        Arguments[] argumentsArray = new Arguments[3];
        Arguments arguments = new Arguments();
        Arguments arguments2 = new Arguments();
        Arguments arguments3 = new Arguments();
        for (int i = 0; i < stringArray.length; ++i) {
            StatsVar statsVar = (StatsVar)this.statsMap.get(stringArray[i]);
            if (statsVar == null) continue;
            arguments.putArgument(statsVar.getName(), new Long(statsVar.getCounter()));
            arguments2.putArgument(statsVar.getName(), new Double(statsVar.getRate()));
            arguments3.putArgument(statsVar.getName(), new Double(statsVar.getGlobalPeakRate()));
        }
        argumentsArray[0] = arguments;
        argumentsArray[1] = arguments2;
        argumentsArray[2] = arguments3;
        return argumentsArray;
    }

    public Arguments[] getCounters(String string) {
        Arguments[] argumentsArray = new Arguments[3];
        Arguments arguments = new Arguments();
        Arguments arguments2 = new Arguments();
        Arguments arguments3 = new Arguments();
        ArrayList arrayList = this.getSafeStatsVar();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            StatsVar statsVar = (StatsVar)arrayList.get(i);
            if (string != null && !statsVar.getName().startsWith(string)) continue;
            arguments.putArgument(statsVar.getName(), new Long(statsVar.getCounter()));
            arguments2.putArgument(statsVar.getName(), new Double(statsVar.getRate()));
            arguments3.putArgument(statsVar.getName(), new Double(statsVar.getGlobalPeakRate()));
        }
        argumentsArray[0] = arguments;
        argumentsArray[1] = arguments2;
        argumentsArray[2] = arguments3;
        return argumentsArray;
    }

    public Arguments[] getCountersBySuffix(String string) {
        Arguments[] argumentsArray = new Arguments[3];
        Arguments arguments = new Arguments();
        Arguments arguments2 = new Arguments();
        Arguments arguments3 = new Arguments();
        ArrayList arrayList = this.getSafeStatsVar();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            StatsVar statsVar = (StatsVar)arrayList.get(i);
            if (string != null && !statsVar.getName().endsWith(string)) continue;
            arguments.putArgument(statsVar.getName(), new Long(statsVar.getCounter()));
            arguments2.putArgument(statsVar.getName(), new Double(statsVar.getRate()));
            arguments3.putArgument(statsVar.getName(), new Double(statsVar.getGlobalPeakRate()));
        }
        argumentsArray[0] = arguments;
        argumentsArray[1] = arguments2;
        argumentsArray[2] = arguments3;
        return argumentsArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList getSafeStatsVar() {
        ArrayList<StatsVar> arrayList = new ArrayList<StatsVar>();
        HashMap hashMap = this.statsMap;
        synchronized (hashMap) {
            for (StatsVar statsVar : this.statsMap.values()) {
                arrayList.add(statsVar);
            }
        }
        return arrayList;
    }

    public Object[] getAllCounters() {
        StatsVar[] statsVarArray = new StatsVar[this.statsMap.size()];
        return this.statsMap.values().toArray(statsVarArray);
    }

    public final StatisticsFile getStatisticsFile() {
        return this.statisticFile;
    }

    public final StatisticsFile getStatisticsHeaderFile() {
        return this.statisticHeaderFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerCounter(StatsVar statsVar) {
        HashMap hashMap = this.statsMap;
        synchronized (hashMap) {
            String string = statsVar.counterName;
            if (this.statsMap.containsKey(string)) {
                logcat.debug((Object)(string + " is already registered"));
            } else {
                this.statsMap.put(string, statsVar);
            }
        }
        try {
            this.msgQueue.add(new RegisterMsg(statsVar));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterCounter(String string) {
        HashMap hashMap = this.statsMap;
        synchronized (hashMap) {
            if (!this.statsMap.containsKey(string)) {
                logcat.debug((Object)(string + " is not registered"));
            } else {
                this.statsMap.remove(string);
            }
        }
        try {
            this.msgQueue.add(new UnRegisterMsg(string));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    boolean isCounterRegistered(String string) {
        return this.statsMap.containsKey(string);
    }

    StatsVar getRegisteredCounter(String string) {
        if (!this.isCounterRegistered(string)) {
            logcat.debug((Object)"counter is not registered - returning null");
            return null;
        }
        return (StatsVar)this.statsMap.get(string);
    }

    private void configureStatsFile() {
        Object object;
        String string;
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(DEFAULT_STATS_CONFIG_FILE);
        if (inputStream == null) {
            logcat.warn((Object)"cannot find configuration file for stats reports - no report will be generated");
            return;
        }
        this.configureFromSingleFile(inputStream);
        String string2 = System.getProperty("com.pcube.filemanager.defaultPath");
        if (string2 == null) {
            logcat.info((Object)"could not find root path, using default");
            string2 = "";
        } else {
            string = System.getProperty("file.separator");
            if (!string2.endsWith(string) && !string2.endsWith(File.separator)) {
                string2 = string2 + string;
            }
        }
        string = string2 + ADDITIONAL_CONFIG_FILE_FOLDER;
        File file = new File(string);
        logcat.debug((Object)("looking for addtional stats.cfg files under " + string));
        if (file.isDirectory()) {
            object = file.listFiles(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return string.toUpperCase().endsWith("CFG");
                }
            });
            for (int i = 0; i < ((File[])object).length; ++i) {
                try {
                    logcat.info((Object)("Reading statistics information from file " + object[i]));
                    this.configureFromSingleFile(new FileInputStream((File)object[i]));
                    continue;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    logcat.error((Object)fileNotFoundException, (Throwable)fileNotFoundException);
                }
            }
        }
        if ((object = Configuration.getEntry("filemanager.codePath").get()) == null) {
            logcat.info((Object)"could not find code path, using default");
            object = "";
        } else {
            String string3 = System.getProperty("file.separator");
            if (!((String)object).endsWith(string3) && !((String)object).endsWith(File.separator)) {
                object = (String)object + string3;
            }
        }
        String string4 = (String)object + ADDITIONAL_CONFIG_FILE_FOLDER;
        if (string4.equals(string)) {
            return;
        }
        file = new File(string4);
        logcat.debug((Object)("looking for addtional stats.cfg files under " + string4));
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return string.toUpperCase().endsWith("CFG");
                }
            });
            for (int i = 0; i < fileArray.length; ++i) {
                try {
                    logcat.info((Object)("Reading statistics information from file " + fileArray[i]));
                    this.configureFromSingleFile(new FileInputStream(fileArray[i]));
                    continue;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    logcat.error((Object)fileNotFoundException, (Throwable)fileNotFoundException);
                }
            }
        }
    }

    private void configureFromSingleFile(InputStream inputStream) {
        try {
            CompleteConfFile completeConfFile = new CompleteConfFile();
            completeConfFile.readConfFile(inputStream);
            boolean bl = false;
            CompleteConfFile.Section[] sectionArray = completeConfFile.getSections(null);
            if (sectionArray != null) {
                for (int i = 0; i < sectionArray.length; ++i) {
                    if (!sectionArray[i].getName().equalsIgnoreCase(CONFIGURATION_SECTION)) continue;
                    bl = true;
                }
            }
            if (!bl) {
                logcat.warn((Object)"invalid file exists in config folder");
                return;
            }
            CompleteConfFile.Property[] propertyArray = completeConfFile.getProperties(CONFIGURATION_SECTION);
            String string = null;
            String string2 = null;
            Vector vector = null;
            for (int i = 0; i < propertyArray.length; ++i) {
                string = propertyArray[i].getName();
                if (string.charAt(0) != '*') {
                    if (this.statsConfMap.containsKey(string)) continue;
                    vector = propertyArray[i].translateValueToCommandDelemitedFields();
                    this.statsConfMap.put(string, vector);
                    if (!logcat.isDebugEnabled()) continue;
                    logcat.debug((Object)("Adding new statsvar name = " + string + ", val = " + vector));
                    continue;
                }
                string2 = string.substring(1);
                if (this.statsConfSuffixMap.containsKey(string2)) continue;
                vector = propertyArray[i].translateValueToCommandDelemitedFields();
                this.statsConfSuffixMap.put(string2, vector);
                if (!logcat.isDebugEnabled()) continue;
                logcat.debug((Object)("Adding new statsvar name = " + string + ", val = " + vector));
            }
        }
        catch (IOException iOException) {
            logcat.error((Object)"cannot configure stats file", (Throwable)iOException);
        }
    }

    private void handleQueueMessages() {
        StatsMessage statsMessage = null;
        int n = this.msgQueue.getSize();
        for (int i = 0; i < n; ++i) {
            try {
                statsMessage = (StatsMessage)this.msgQueue.remove();
                statsMessage.processMsg();
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void dumpFileHeader() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.reportVars.entrySet().iterator();
        while (iterator.hasNext()) {
            String string;
            StatsVar statsVar = (StatsVar)iterator.next().getValue();
            String string2 = statsVar.getName();
            String string3 = string = statsVar.getCounterGroupName() == null ? "" : statsVar.getCounterGroupName();
            if (statsVar.isReportCounter()) {
                stringBuffer.append(string2);
                stringBuffer.append("(ES;");
                stringBuffer.append(string);
                stringBuffer.append(";),");
            }
            if (statsVar.isReportGlobalPeakRate()) {
                stringBuffer.append(string2);
                stringBuffer.append(".GPR(OT;");
                stringBuffer.append(string);
                stringBuffer.append(";),");
            }
            if (!statsVar.isReportLocalPeakRate()) continue;
            stringBuffer.append(string2);
            stringBuffer.append(".LPR(OT;");
            stringBuffer.append(string);
            stringBuffer.append(";),");
        }
        this.statisticHeaderFile.writeln(stringBuffer.toString());
    }

    private void dumpVariables() {
        StringBuffer stringBuffer = new StringBuffer();
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(2);
        Iterator iterator = this.reportVars.entrySet().iterator();
        StatsVar statsVar = null;
        while (iterator.hasNext()) {
            statsVar = (StatsVar)iterator.next().getValue();
            if (statsVar.isReportCounter()) {
                stringBuffer.append(statsVar.getNonVolatileCounter());
                stringBuffer.append(",");
            }
            if (statsVar.isReportGlobalPeakRate()) {
                stringBuffer.append(numberFormat.format(statsVar.getNonVolatileGlobalPeakRate()));
                stringBuffer.append(",");
            }
            if (statsVar.isReportLocalPeakRate()) {
                stringBuffer.append(numberFormat.format(statsVar.getNonVolatileLocalPeakRate()));
                stringBuffer.append(",");
            }
            statsVar.resetLocalPeakRate();
        }
        this.statisticFile.writeln(stringBuffer.toString());
    }

    private void addToReportVar(StatsVar statsVar, Vector vector) {
        String string = null;
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            string = ((String)vector.get(i)).trim();
            if (string.equals(COUNTER_PLACEHOLDER)) {
                statsVar.enableReportCounter();
                continue;
            }
            if (string.equals(GLOBAL_PEAK_RATE_PLACEHOLDER)) {
                statsVar.enableReportGlobalPeakRate();
                continue;
            }
            if (string.equals(LOCAL_PEAK_RATE_PLACEHOLDER)) {
                statsVar.enableReportLocalPeakRate();
                continue;
            }
            if (i == n - 1) {
                statsVar.setCounterGroupName(string.trim());
                continue;
            }
            logcat.warn((Object)(statsVar.getName() + " is configured to report unknown stats type"));
        }
        if (!this.reportVars.containsKey(statsVar)) {
            this.reportVars.put(statsVar.counterName, statsVar);
            this.reportVarsChanged = true;
        }
    }

    private void removeFromReportVar(String string) {
        logcat.debug((Object)("UnRegisterMsg: remove " + string + " from reportVars"));
        this.reportVars.remove(string);
        this.reportVarsChanged = true;
    }

    public class UnRegisterMsg
    extends StatsMessage {
        private String counterName = null;

        public UnRegisterMsg(String string) {
            this.counterName = string;
        }

        public void processMsg() {
            if (Statistics.this.reportVars.containsKey(this.counterName)) {
                Statistics.this.removeFromReportVar(this.counterName);
                return;
            }
            logcat.debug((Object)("UnRegisterMsg could not find " + this.counterName + " in reportVars"));
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("UnRegisterMsg: counterName=");
            stringBuffer.append(this.counterName);
            return stringBuffer.toString();
        }
    }

    public class RegisterMsg
    extends StatsMessage {
        private StatsVar statsVar = null;

        public RegisterMsg(StatsVar statsVar) {
            this.statsVar = statsVar;
        }

        public void processMsg() {
            String string = this.statsVar.counterName;
            if (Statistics.this.reportVars.containsKey(string)) {
                logcat.debug((Object)(string + " is already registered"));
                return;
            }
            if (Statistics.this.statsConfMap.containsKey(string)) {
                logcat.debug((Object)(string + " exists in statsConfMap, add statsVar to the reportVars"));
                Statistics.this.addToReportVar(this.statsVar, (Vector)Statistics.this.statsConfMap.get(string));
                return;
            }
            Iterator iterator = Statistics.this.statsConfSuffixMap.entrySet().iterator();
            Map.Entry entry = null;
            while (iterator.hasNext()) {
                entry = iterator.next();
                String string2 = (String)entry.getKey();
                if (!string.endsWith(string2)) continue;
                logcat.debug((Object)(string + " exists matched to " + string2 + ", add statsVar to the reportVars"));
                Statistics.this.addToReportVar(this.statsVar, (Vector)entry.getValue());
                break;
            }
            logcat.debug((Object)(string + ", is not taken part in statsVar.log"));
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("RegisterMsg: statsVar= ");
            stringBuffer.append(this.statsVar);
            return stringBuffer.toString();
        }
    }

    public static abstract class StatsMessage {
        public String toString() {
            return super.toString();
        }

        protected StatsMessage() {
        }

        public abstract void processMsg();
    }
}

