/*
 * Decompiled with CFR 0.152.
 */
package com.pcube.management.framework.agent;

import java.io.File;
import java.io.IOException;
import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.Hierarchy;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.spi.RootCategory;

public class StatisticsFile {
    public static final int DEFAULT_MAX_BACKUP_INDEX = 10;
    public static final long DEFAULT_MAX_FILE_SIZE = 1024000L;
    public static final int DEFAULT_HEADER_MAX_BACKUP_INDEX = 10;
    public static final long DEFAULT_HEADER_MAX_FILE_SIZE = 2048000L;
    private static Category logcat = Category.getInstance(StatisticsFile.class);
    private Hierarchy statsHierarchy = null;
    private RollingFileAppender appender = null;

    public String toString() {
        return super.toString();
    }

    public StatisticsFile(String string) {
        CharSequence charSequence;
        String string2 = System.getProperty("com.pcube.filemanager.defaultPath");
        String string3 = File.separator;
        if (string2 == null) {
            string2 = "";
        } else if (!string2.endsWith(string3)) {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append(string2);
            ((StringBuffer)charSequence).append(string3);
            string2 = ((StringBuffer)charSequence).toString();
        }
        charSequence = string2 + string;
        try {
            this.verifyStatsFile((String)charSequence);
            this.appender = new RollingFileAppender((Layout)new PatternLayout("%d{MM.dd.yyyy},%d{HH:mm:ss},%r,%m%n"), (String)charSequence, true);
            this.appender.setMaxBackupIndex(10);
            this.appender.setMaxFileSize(1024000L);
            this.statsHierarchy = new Hierarchy((Category)new RootCategory(Priority.INFO));
            this.statsHierarchy.getRoot().addAppender((Appender)this.appender);
        }
        catch (IOException iOException) {
            logcat.error((Object)("can't create stats file " + (String)charSequence), (Throwable)iOException);
        }
    }

    public void writeln(String string) {
        if (this.statsHierarchy != null) {
            this.statsHierarchy.getRoot().info((Object)string);
        }
    }

    public void setMaxBackupIndex(int n) {
        if (this.appender != null) {
            this.appender.setMaxBackupIndex(n);
        }
    }

    public void setMaxFileSize(long l) {
        if (this.appender != null) {
            this.appender.setMaxFileSize(l);
        }
    }

    public int getMaxBackupIndex() {
        if (this.appender != null) {
            return this.appender.getMaxBackupIndex();
        }
        return 10;
    }

    public long getMaxFileSize() {
        if (this.appender != null) {
            return this.appender.getMaximumFileSize();
        }
        return 1024000L;
    }

    private void verifyStatsFile(String string) {
        logcat.debug((Object)("Verifying directory of " + string));
        if (string != null) {
            File file = new File(string).getParentFile();
            file.mkdirs();
        }
    }
}

