/*
 * Decompiled with CFR 0.152.
 */
package com.pcube.management.framework.agent;

import com.pcube.management.framework.agent.Statistics;

public class StatsVar {
    private static final int INT_1000_VALUE = 1000;
    protected String counterName = null;
    protected String counterGroupName = null;
    protected long counter = 0L;
    protected long lastCounter = 0L;
    protected double rate = 0.0;
    protected double globalPeakRate = 0.0;
    protected double localPeakRate = 0.0;
    protected long nonVolatileCounter = 0L;
    protected long lastNonVolatileCounter = 0L;
    protected double nonVolatileRate = 0.0;
    protected double nonVolatileGlobalPeakRate = 0.0;
    protected double nonVolatileLocalPeakRate = 0.0;
    protected boolean isReportCounter = false;
    protected boolean isReportGlobal = false;
    protected boolean isReportLocal = false;

    public static StatsVar getStatsVar(String string) {
        if (Statistics.getInstance().isCounterRegistered(string)) {
            return Statistics.getInstance().getRegisteredCounter(string);
        }
        return new StatsVar(string);
    }

    public StatsVar(String string) {
        this.counterName = string;
        Statistics.getInstance().registerCounter(this);
    }

    public void close() {
        Statistics.getInstance().unregisterCounter(this.counterName);
    }

    public final String getName() {
        return this.counterName;
    }

    public long getCounter() {
        return this.counter;
    }

    public long getNonVolatileCounter() {
        return this.nonVolatileCounter;
    }

    public void increaseCount() {
        ++this.counter;
        ++this.nonVolatileCounter;
    }

    public void decreaseCount() {
        --this.counter;
        --this.nonVolatileCounter;
    }

    public void reset() {
        this.counter = 0L;
        this.lastCounter = 0L;
        this.rate = 0.0;
        this.globalPeakRate = 0.0;
        this.localPeakRate = 0.0;
    }

    public double getRate() {
        return this.rate;
    }

    public double getNonVolatileRate() {
        return this.nonVolatileRate;
    }

    public double getGlobalPeakRate() {
        return this.globalPeakRate;
    }

    public double getNonVolatileGlobalPeakRate() {
        return this.nonVolatileGlobalPeakRate;
    }

    public double getLocalPeakRate() {
        return this.localPeakRate;
    }

    public double getNonVolatileLocalPeakRate() {
        return this.nonVolatileLocalPeakRate;
    }

    public void resetLocalPeakRate() {
        this.localPeakRate = 0.0;
        this.nonVolatileLocalPeakRate = 0.0;
    }

    public void calculateRate(long l) {
        this.calculateVolatileRate(l);
        this.calculateNonVolatileRate(l);
    }

    public void enableReportCounter() {
        this.isReportCounter = true;
    }

    public void enableReportGlobalPeakRate() {
        this.isReportGlobal = true;
    }

    public void enableReportLocalPeakRate() {
        this.isReportLocal = true;
    }

    public final boolean isReportCounter() {
        return this.isReportCounter;
    }

    public final boolean isReportGlobalPeakRate() {
        return this.isReportGlobal;
    }

    public final boolean isReportLocalPeakRate() {
        return this.isReportLocal;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("counterName: " + this.counterName);
        return stringBuffer.toString();
    }

    private void calculateVolatileRate(long l) {
        this.rate = (double)(this.counter - this.lastCounter) * 1000.0 / (double)l;
        if (this.rate > this.globalPeakRate) {
            this.globalPeakRate = this.rate;
        }
        if (this.rate > this.localPeakRate) {
            this.localPeakRate = this.rate;
        }
        this.lastCounter = this.counter;
    }

    private void calculateNonVolatileRate(long l) {
        this.nonVolatileRate = (double)(this.nonVolatileCounter - this.lastNonVolatileCounter) * 1000.0 / (double)l;
        if (this.nonVolatileRate > this.nonVolatileGlobalPeakRate) {
            this.nonVolatileGlobalPeakRate = this.nonVolatileRate;
        }
        if (this.nonVolatileRate > this.nonVolatileLocalPeakRate) {
            this.nonVolatileLocalPeakRate = this.nonVolatileRate;
        }
        this.lastNonVolatileCounter = this.nonVolatileCounter;
    }

    public final String getCounterGroupName() {
        return this.counterGroupName;
    }

    public final void setCounterGroupName(String string) {
        this.counterGroupName = string;
    }
}

