/*
 * Decompiled with CFR 0.152.
 */
package com.pcube.management.framework.client;

import com.pcube.management.common.ArrayUtilities;
import com.pcube.management.common.InvocationDescriptor;
import com.pcube.management.common.InvocationDescriptorImpl;
import com.pcube.management.common.InvocationHelper;
import com.pcube.management.framework.client.BatchExecutionResult;
import com.pcube.management.framework.client.RecurringResult;
import com.pcube.management.framework.client.SingleResult;
import com.pcube.management.framework.functionality.Arguments;
import com.sun.jdmk.ProxyHandler;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;
import org.apache.log4j.Category;

public class Batch
implements Serializable {
    private static final long serialVersionUID = 3413336691519458872L;
    private static Category logcat = Category.getInstance(Batch.class);
    public static final BatchMode EXECUTE_ALL_MODE = new BatchMode(0);
    public static final BatchMode STOP_ON_EXCEPTION_MODE = new BatchMode(1);
    protected BatchMode executionMode = EXECUTE_ALL_MODE;
    Vector invocationDescriptors;
    private transient boolean local = true;

    public Batch() {
        this.clear();
    }

    public synchronized void clear() {
        this.invocationDescriptors = new Vector();
    }

    public synchronized int getNumberOfCommands() {
        return this.invocationDescriptors.size();
    }

    public Enumeration enumerate() {
        return this.invocationDescriptors.elements();
    }

    public synchronized void setExecutionMode(BatchMode batchMode) {
        this.executionMode = batchMode;
    }

    public BatchMode getExecutionMode() {
        return this.executionMode;
    }

    public synchronized void invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) {
        this.invocationDescriptors.addElement(new InvocationDescriptorImpl(objectName, string, objectArray, stringArray));
    }

    public synchronized void getAttribute(ObjectName objectName, String string) {
        this.invocationDescriptors.addElement(new InvocationDescriptorImpl(objectName, string));
    }

    public synchronized void getAttributes(ObjectName objectName, String[] stringArray) {
        this.invocationDescriptors.addElement(new InvocationDescriptorImpl(objectName, stringArray));
    }

    public Batch[] divide(int n) {
        int n2 = this.getNumberOfCommands();
        if (n == 0) {
            Batch[] batchArray = new Batch[]{};
            batchArray[0] = new Batch();
            batchArray[0].setExecutionMode(this.getExecutionMode());
            return batchArray;
        }
        int n3 = n2 / n + 1;
        int n4 = n2 % n;
        Batch[] batchArray = new Batch[n3];
        for (int i = 0; i < n3; ++i) {
            batchArray[i] = new Batch();
            batchArray[i].setExecutionMode(this.getExecutionMode());
            int n5 = i == n3 - 1 ? n4 : n;
            for (int j = 0; j < n5; ++j) {
                batchArray[i].invocationDescriptors.addElement(this.invocationDescriptors.elementAt(i * n + j));
            }
        }
        return batchArray;
    }

    public synchronized void setAttribute(ObjectName objectName, Attribute attribute) {
        this.invocationDescriptors.addElement(new InvocationDescriptorImpl(objectName, attribute));
    }

    public synchronized void setAttributes(ObjectName objectName, AttributeList attributeList) {
        this.invocationDescriptors.addElement(new InvocationDescriptorImpl(objectName, attributeList));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BatchExecutionResult execute(ProxyHandler proxyHandler) {
        BatchExecutionResult batchExecutionResult = new BatchExecutionResult();
        InvocationDescriptor invocationDescriptor = null;
        int n = 0;
        Object object = null;
        Enumeration enumeration = this.invocationDescriptors.elements();
        while (true) {
            if (object == null || !(object instanceof RecurringResult) || !((RecurringResult)object).executeAgain() || n >= 1000000) {
                if (enumeration.hasMoreElements()) {
                    invocationDescriptor = (InvocationDescriptor)enumeration.nextElement();
                    n = 0;
                } else {
                    invocationDescriptor = null;
                    break;
                }
            }
            try {
                object = null;
                object = InvocationHelper.executeDescriptor(invocationDescriptor, proxyHandler);
                ++n;
                batchExecutionResult.addResult(new SingleResult(null, object));
                continue;
            }
            catch (Throwable throwable) {
                batchExecutionResult.addResult(new SingleResult(null, throwable));
                logcat.error((Object)throwable, throwable);
                if (logcat.isDebugEnabled()) {
                    try {
                        logcat.debug((Object)("Object name:" + invocationDescriptor.getObjectName()));
                        logcat.debug((Object)("Operation name:" + invocationDescriptor.getOperationName()));
                        if (invocationDescriptor.getParams() != null) {
                            System.out.println("");
                            for (int i = 0; i < invocationDescriptor.getParams().length; ++i) {
                                if (invocationDescriptor.getParams()[i] != null && invocationDescriptor.getParams()[i] instanceof Arguments) {
                                    Arguments arguments = (Arguments)invocationDescriptor.getParams()[i];
                                    logcat.debug((Object)"Arguments dump:");
                                    arguments.dump(System.out);
                                    continue;
                                }
                                logcat.debug((Object)"Params dump");
                                ArrayUtilities.printObject(System.out, (Object)invocationDescriptor.getParams(), "param");
                            }
                        }
                    }
                    catch (Exception exception) {
                        logcat.error((Object)"Failed dump", (Throwable)exception);
                    }
                }
                if (this.executionMode.equals(STOP_ON_EXCEPTION_MODE)) break;
                continue;
            }
            break;
        }
        if (this.local) {
            this.setInvocationDescriptors(batchExecutionResult);
        }
        return batchExecutionResult;
    }

    public void setInvocationDescriptors(BatchExecutionResult batchExecutionResult) {
        int n = this.invocationDescriptors.size();
        int n2 = batchExecutionResult.results.size();
        SingleResult singleResult = null;
        Object var5_5 = null;
        InvocationDescriptor invocationDescriptor = null;
        boolean bl = true;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            singleResult = (SingleResult)batchExecutionResult.results.elementAt(i);
            if (bl) {
                invocationDescriptor = (InvocationDescriptor)this.invocationDescriptors.elementAt(n3++);
            }
            if (bl && singleResult.getResult() instanceof RecurringResult && ((RecurringResult)singleResult.getResult()).executeAgain()) {
                bl = false;
            } else if (!bl && singleResult instanceof RecurringResult && !((RecurringResult)singleResult.getResult()).executeAgain()) {
                bl = true;
            }
            singleResult.setInvocationDescriptor(invocationDescriptor);
            if (!(singleResult.getResult() instanceof BatchExecutionResult)) continue;
            invocationDescriptor.getBatch().setInvocationDescriptors((BatchExecutionResult)singleResult.getResult());
        }
    }

    public void append(Batch batch) {
        if (batch == null) {
            throw new IllegalArgumentException("Null argument is not allowed");
        }
        int n = batch.invocationDescriptors == null ? 0 : batch.invocationDescriptors.size();
        for (int i = 0; i < n; ++i) {
            this.invocationDescriptors.addElement(batch.invocationDescriptors.elementAt(i));
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        this.invocationDescriptors = new Vector();
        for (int i = 0; i < n; ++i) {
            this.invocationDescriptors.addElement(objectInput.readObject());
        }
        this.local = false;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = this.invocationDescriptors.size();
        objectOutput.writeInt(n);
        for (int i = 0; i < n; ++i) {
            objectOutput.writeObject(this.invocationDescriptors.elementAt(i));
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.local = false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    public static class BatchMode
    implements Serializable {
        private static final long serialVersionUID = -7205980814921296465L;
        private int mode;

        protected BatchMode(int n) {
            this.mode = n;
        }

        public int hashCode() {
            return this.mode;
        }

        public boolean equals(Object object) {
            return object instanceof BatchMode && ((BatchMode)object).mode == this.mode;
        }
    }
}

