/*
 * Decompiled with CFR 0.152.
 */
package com.pcube.management.framework.client;

import com.pcube.management.common.ArrayUtilities;
import com.pcube.management.common.WrappedExceptionsSet;
import com.pcube.management.framework.client.Bindable;
import com.pcube.management.framework.client.ExecutionResult;
import com.pcube.management.framework.client.SessionObject;
import com.pcube.management.framework.client.SingleResult;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class BatchExecutionResult
implements Serializable,
ExecutionResult,
Bindable {
    Vector results;
    private boolean errorHappened;

    public BatchExecutionResult() {
        this.clear();
    }

    public synchronized void clear() {
        this.errorHappened = false;
        this.results = new Vector();
    }

    public synchronized int getNumberOfResults() {
        return this.results.size();
    }

    public Enumeration enumerate() {
        return this.results.elements();
    }

    public synchronized SingleResult getResult(int n) {
        return (SingleResult)this.results.elementAt(n);
    }

    public synchronized void addResult(SingleResult singleResult) {
        if (singleResult.errorOccured()) {
            this.errorHappened = true;
        }
        this.results.addElement(singleResult);
    }

    public synchronized void addResults(BatchExecutionResult batchExecutionResult) {
        this.errorHappened = this.errorHappened || batchExecutionResult.errorHappened;
        int n = batchExecutionResult.results.size();
        for (int i = 0; i < n; ++i) {
            this.results.addElement(batchExecutionResult.results.elementAt(i));
        }
    }

    public void bind(SessionObject sessionObject) {
        int n = this.results.size();
        for (int i = 0; i < n; ++i) {
            SingleResult singleResult = (SingleResult)this.results.elementAt(i);
            Object object = singleResult.getResult();
            if (object == null || !(object instanceof Bindable)) continue;
            ((Bindable)object).bind(sessionObject);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof BatchExecutionResult) {
            BatchExecutionResult batchExecutionResult = (BatchExecutionResult)object;
            return batchExecutionResult.errorHappened == this.errorHappened && ArrayUtilities.compare(this.results, batchExecutionResult.results);
        }
        return false;
    }

    public boolean errorOccured() {
        return this.errorHappened;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        this.results = new Vector();
        for (int i = 0; i < n; ++i) {
            this.results.addElement(objectInput.readObject());
        }
        this.errorHappened = objectInput.readBoolean();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = this.results.size();
        objectOutput.writeInt(n);
        for (int i = 0; i < n; ++i) {
            objectOutput.writeObject(this.results.elementAt(i));
        }
        objectOutput.writeBoolean(this.errorHappened);
    }

    public WrappedExceptionsSet getExceptions() {
        if (this.errorOccured()) {
            Object[] objectArray;
            int n;
            Vector<Throwable> vector = new Vector<Throwable>();
            int n2 = this.getNumberOfResults();
            for (n = 0; n < n2; ++n) {
                objectArray = this.getResult(n);
                if (!objectArray.errorOccured()) continue;
                vector.addElement((Throwable)objectArray.getResult());
            }
            n = vector.size();
            objectArray = new Throwable[n];
            vector.copyInto(objectArray);
            return new WrappedExceptionsSet("Errors occured while executing batch", (Throwable[])objectArray);
        }
        return null;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }
}

