/*
 * Decompiled with CFR 0.152.
 */
package com.pcube.management.framework.client;

import com.pcube.management.common.ArrayUtilities;
import com.pcube.management.common.InvocationDescriptor;
import com.pcube.management.framework.client.ExecutionResult;
import java.io.Serializable;
import javax.management.AttributeList;

public class SingleResult
implements Serializable,
ExecutionResult {
    private InvocationDescriptor descriptor;
    private Object result;

    public SingleResult(InvocationDescriptor invocationDescriptor, Object object) {
        this.descriptor = invocationDescriptor;
        this.result = object;
    }

    public int getType() {
        return this.descriptor.getType();
    }

    public Object getResult() {
        return this.result;
    }

    public boolean errorOccured() {
        return this.result instanceof Throwable;
    }

    public InvocationDescriptor getInvocationDescriptor() {
        return this.descriptor;
    }

    void setInvocationDescriptor(InvocationDescriptor invocationDescriptor) {
        this.descriptor = invocationDescriptor;
    }

    public String getResultAsString() throws ClassCastException {
        return (String)this.result;
    }

    public int getResultAsInt() throws ClassCastException {
        return (Integer)this.result;
    }

    public boolean getResultAsBoolean() throws ClassCastException {
        return (Boolean)this.result;
    }

    public short getResultAsShort() throws ClassCastException {
        return (Short)this.result;
    }

    public float getResultAsFloat() throws ClassCastException {
        return ((Float)this.result).floatValue();
    }

    public double getResultAsDouble() throws ClassCastException {
        return (Double)this.result;
    }

    public long getResultAsLong() throws ClassCastException {
        return (Long)this.result;
    }

    public int parseResultToInt() throws NumberFormatException {
        if (this.result instanceof Integer) {
            return (Integer)this.result;
        }
        return Integer.parseInt(this.result.toString());
    }

    public long parseResultToLong() throws NumberFormatException {
        if (this.result instanceof Long) {
            return (Long)this.result;
        }
        return Long.parseLong(this.result.toString());
    }

    public AttributeList getResultAsAttributeList() throws ClassCastException {
        return (AttributeList)this.result;
    }

    public boolean equals(Object object) {
        if (object instanceof SingleResult) {
            SingleResult singleResult = (SingleResult)object;
            return ArrayUtilities.compare(singleResult.result, this.result);
        }
        return false;
    }
}

