/*
 * Decompiled with CFR 0.152.
 */
package com.pcube.management.framework.functionality;

import com.pcube.management.common.ArrayUtilities;
import com.pcube.management.common.HashUtilities;
import com.pcube.management.common.InvocationHelper;
import com.pcube.management.framework.rpc.ConvertsToParameters;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class Arguments
implements Serializable,
ConvertsToParameters {
    private HashMap map = new HashMap();
    private Object[] parameters;
    private String[] signature;
    public static int refCounter = 0;

    public Arguments() {
        this.increaseRef();
    }

    public Arguments(String[] stringArray, Object[] objectArray) {
        this();
        for (int i = 0; i < stringArray.length; ++i) {
            this.putArgument(stringArray[i], objectArray[i]);
        }
    }

    public Arguments(Object[] objectArray) {
        this();
        for (int i = 0; i < objectArray.length; i += 2) {
            this.putArgument(objectArray[i].toString(), objectArray[i + 1]);
        }
    }

    protected void finalize() throws Throwable {
        this.decreaseRef();
        super.finalize();
    }

    private synchronized void increaseRef() {
        ++refCounter;
    }

    private synchronized void decreaseRef() {
        --refCounter;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Set set = this.map.keySet();
        Iterator iterator = set.iterator();
        objectOutputStream.writeInt(set.size());
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            objectOutputStream.writeObject(string);
            objectOutputStream.writeObject(this.map.get(string));
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n = objectInputStream.readInt();
        this.map = new HashMap(n);
        while (n-- > 0) {
            String string = (String)objectInputStream.readObject();
            this.map.put(string, objectInputStream.readObject());
        }
    }

    public void putArgument(String string, Object object) {
        this.map.put(string, object);
        this.parameters = null;
        this.signature = null;
    }

    public Object get(String string) {
        return this.map.get(string);
    }

    public Short getAsShort(String string) throws ClassCastException {
        return (Short)this.map.get(string);
    }

    public String getAsString(String string) throws ClassCastException {
        return (String)this.map.get(string);
    }

    public Boolean getAsBoolean(String string) throws ClassCastException {
        return (Boolean)this.map.get(string);
    }

    public Integer getAsInteger(String string) throws ClassCastException {
        return (Integer)this.map.get(string);
    }

    public Long getAsLong(String string) throws ClassCastException {
        return (Long)this.map.get(string);
    }

    public long[] getAsLongArray(String string) throws ClassCastException {
        return (long[])this.map.get(string);
    }

    public int[] getAsIntArray(String string) throws ClassCastException {
        return (int[])this.map.get(string);
    }

    public String[] getAsStringArray(String string) throws ClassCastException {
        return (String[])this.map.get(string);
    }

    public boolean[] getAsBooleanArray(String string) throws ClassCastException {
        return (boolean[])this.map.get(string);
    }

    public boolean containsKey(String string) {
        return this.map.containsKey(string);
    }

    public String toString() {
        return this.map.toString();
    }

    public String[] getArgumentNames() {
        Iterator iterator = this.map.keySet().iterator();
        int n = this.map.keySet().size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)iterator.next();
        }
        return stringArray;
    }

    public Object[] getArgumentValues(String[] stringArray) {
        int n = stringArray.length;
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.map.get(stringArray[i]);
        }
        return objectArray;
    }

    private final void initParametersAndSignature() {
        if (this.getNumberOfArguments() == 0) {
            this.parameters = new Object[0];
            this.signature = new String[0];
            return;
        }
        int n = this.getNumberOfArguments() * 2;
        this.parameters = new Object[n];
        Iterator iterator = this.map.keySet().iterator();
        for (int i = 0; i < n; i += 2) {
            this.parameters[i] = (String)iterator.next();
            this.parameters[i + 1] = this.map.get(this.parameters[i]);
        }
        this.signature = InvocationHelper.createSignature(this.parameters);
    }

    public Object[] getParameters() {
        if (this.parameters == null) {
            this.initParametersAndSignature();
        }
        return this.parameters;
    }

    public String[] getSignature() {
        if (this.signature == null) {
            this.initParametersAndSignature();
        }
        return this.signature;
    }

    public int getNumberOfArguments() {
        return this.map.size();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object object) {
        HashMap hashMap;
        if (object instanceof Arguments && (hashMap = ((Arguments)object).map).size() == this.map.size()) {
            for (String string : this.map.keySet()) {
                if (hashMap.containsKey(string)) {
                    Object v;
                    Object v2 = this.map.get(string);
                    if (ArrayUtilities.compare(v2, v = hashMap.get(string))) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public void merge(Arguments arguments) {
        String[] stringArray = arguments.getArgumentNames();
        for (int i = 0; i < stringArray.length; ++i) {
            this.putArgument(stringArray[i], arguments.get(stringArray[i]));
        }
    }

    public void printArguments(OutputStream outputStream) {
        this.printArguments(new PrintWriter(outputStream, true));
    }

    public void printArguments(PrintWriter printWriter) {
        HashUtilities.printSorted(this.map, printWriter, 0);
    }

    public void dump(OutputStream outputStream) {
        PrintWriter printWriter = new PrintWriter(outputStream, true);
        String[] stringArray = this.getArgumentNames();
        if (stringArray != null) {
            printWriter.println("number of keys=" + stringArray.length);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            printWriter.println("key " + i + stringArray[i].toString());
            ArrayUtilities.printObject(printWriter, this.get(stringArray[i]), "value[" + i + "]");
            printWriter.println("");
            printWriter.println("");
        }
    }
}

