/*
 * Decompiled with CFR 0.152.
 */
package com.pcube.management.framework.rpc;

import com.objsys.asn1j.runtime.Asn1Boolean;
import com.objsys.asn1j.runtime.Asn1Integer;
import com.objsys.asn1j.runtime.Asn1OctetString;
import com.objsys.asn1j.runtime.Asn1Real;
import com.objsys.asn1j.runtime.Asn1Type;
import com.objsys.asn1j.runtime.Asn1TypeIF;
import com.objsys.asn1j.runtime.Asn1UTF8String;
import com.pcube.management.api.common.BaseApi;
import com.pcube.management.common.Exceptions;
import com.pcube.management.common.InvocationHelper;
import com.pcube.management.framework.agent.StatsVar;
import com.pcube.management.framework.appconf.ValueDoesNotMeetConstraintsException;
import com.pcube.management.framework.functionality.Arguments;
import com.pcube.management.framework.functionality.FunctionArgumentException;
import com.pcube.management.framework.functionality.NativeMethodStatusFailException;
import com.pcube.management.framework.rpc.AsnToWireEncoder;
import com.pcube.management.framework.rpc.ConvertsToParameters;
import com.pcube.management.framework.rpc.EncodingException;
import com.pcube.management.framework.rpc.ErrorCodes;
import com.pcube.management.framework.rpc.GenericSerializable;
import com.pcube.management.framework.rpc.ParameterStruct;
import com.pcube.management.framework.rpc.ParametersStruct;
import com.pcube.management.framework.rpc.ResultStruct;
import com.pcube.management.framework.rpc.RpcErrorException;
import com.pcube.management.framework.rpc.protocol.ClientMessage;
import com.pcube.management.framework.rpc.protocol.DontGetNotifications;
import com.pcube.management.framework.rpc.protocol.DontGetNotifications_target;
import com.pcube.management.framework.rpc.protocol.Error;
import com.pcube.management.framework.rpc.protocol.GetAttribute;
import com.pcube.management.framework.rpc.protocol.GetNotifications;
import com.pcube.management.framework.rpc.protocol.GetNotifications_typeFilter;
import com.pcube.management.framework.rpc.protocol.Invoke;
import com.pcube.management.framework.rpc.protocol.Notification;
import com.pcube.management.framework.rpc.protocol.Operation;
import com.pcube.management.framework.rpc.protocol.OperationResult;
import com.pcube.management.framework.rpc.protocol.OperationResult_operationResult;
import com.pcube.management.framework.rpc.protocol.Operation_operation;
import com.pcube.management.framework.rpc.protocol.Parameter;
import com.pcube.management.framework.rpc.protocol.Parameter_booleanArray;
import com.pcube.management.framework.rpc.protocol.Parameter_intArray;
import com.pcube.management.framework.rpc.protocol.Parameter_longArray;
import com.pcube.management.framework.rpc.protocol.Parameter_realArray;
import com.pcube.management.framework.rpc.protocol.Parameter_shortArray;
import com.pcube.management.framework.rpc.protocol.Parameter_stringArray;
import com.pcube.management.framework.rpc.protocol.Parameters;
import com.pcube.management.framework.rpc.protocol.ServerMessage;
import com.pcube.management.framework.rpc.protocol.SetAttribute;
import com.pcube.management.framework.rpc.protocol.Success;
import com.pcube.management.smm.DomainNotFoundException;
import com.pcube.management.smm.NotASubscriberDomainException;
import com.pcube.management.smm.SeException;
import com.pcube.management.smm.SubscriberAlreadyExistsException;
import com.pcube.management.smm.SubscriberDoesNotExistException;
import com.pcube.management.smm.SubscriberDomainMappingException;
import com.pcube.management.smm.SubscriberIllegalName;
import com.pcube.management.smm.SubscriberIpCongestionException;
import com.pcube.management.smm.SubscriberMappingException;
import com.pcube.management.smm.VpnAlreadyExistsException;
import com.pcube.management.smm.VpnDoesNotExistException;
import com.pcube.management.smm.VpnMappingException;
import com.pcube.management.smm.database.DBSqlException;
import com.scms.sce.exceptions.FatalException;
import com.scms.sce.exceptions.InvalidParameterException;
import com.scms.sce.exceptions.NoApplicationException;
import com.scms.sce.exceptions.OperationAbortedException;
import com.scms.sce.exceptions.ResourceShortageException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.HashMap;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ReflectionException;
import org.apache.log4j.Category;

final class AsnClassesEncoderDecoder
implements ErrorCodes {
    private static Category logcat = Category.getInstance(AsnClassesEncoderDecoder.class);
    private static Class OBJECT_ARRAY_CLASS = Object[].class;
    private static Class STRING_ARRAY_CLASS = String[].class;
    private static Class ARGUMENTS_CLASS = Arguments.class;
    private static final HashMap signatureConversionMap = new HashMap();
    private static final HashMap parameterConvertorsMap;
    private static final HashMap exceptionConversionMap;
    static final int CODE_STRING = 1559;
    static final int CODE_DOUBLE = 1531;
    static final int CODE_SHORT = 1456;
    static final int CODE_INTEGER = 1646;
    static final int CODE_LONG = 1328;
    static final int CODE_BOOLEAN = 1632;
    static final int CODE_BYTE_ARRAY = 157;
    static final int CODE_STRING_ARRAY = 1785;
    static final int CODE_DOUBLE_ARRAY = 159;
    static final int CODE_INT_ARRAY = 164;
    static final int CODE_LONG_ARRAY = 165;
    static final int CODE_SHORT_ARRAY = 174;
    static final int CODE_BOOLEAN_ARRAY = 181;
    private static StatsVar serializedResultCounter;

    AsnClassesEncoderDecoder() {
    }

    public static final ResultStruct createSuccessMessage(Object object) throws IOException, ClassNotFoundException {
        OperationResult_operationResult operationResult_operationResult = new OperationResult_operationResult();
        ResultStruct resultStruct = new ResultStruct(operationResult_operationResult, false);
        Success success = new Success();
        try {
            if (object instanceof ConvertsToParameters) {
                Object[] objectArray = ((ConvertsToParameters)object).getParameters();
                String[] stringArray = ((ConvertsToParameters)object).getSignature();
                success.set_result(AsnClassesEncoderDecoder.convertObjectsAndSignatureToParameters(objectArray, stringArray));
            } else if (object == null) {
                success.set_void_();
            } else if (object.getClass() == OBJECT_ARRAY_CLASS) {
                Object[] objectArray = (Object[])object;
                switch (objectArray.length) {
                    case 0: {
                        success.set_void_();
                        break;
                    }
                    case 2: {
                        if (objectArray[0] != null && objectArray[0].getClass() == OBJECT_ARRAY_CLASS && objectArray[1] != null && objectArray[1].getClass() == STRING_ARRAY_CLASS) {
                            success.set_result(AsnClassesEncoderDecoder.convertObjectsAndSignatureToParameters((Object[])objectArray[0], (String[])objectArray[1]));
                            break;
                        }
                    }
                    default: {
                        success.set_result(AsnClassesEncoderDecoder.convertObjectsAndSignatureToParameters(objectArray, InvocationHelper.createSignature(objectArray)));
                        break;
                    }
                }
            } else {
                success.set_result(AsnClassesEncoderDecoder.convertObjectsAndSignatureToParameters(new Object[]{object}, new String[]{object.getClass().getName()}));
                resultStruct.isScalar = true;
            }
            operationResult_operationResult.set_success(success);
        }
        catch (EncodingException encodingException) {
            if (logcat.isDebugEnabled()) {
                logcat.debug((Object)("failed encoding success message for " + object), (Throwable)encodingException);
            }
            Asn1OctetString asn1OctetString = new Asn1OctetString(AsnClassesEncoderDecoder.serializeObject(object));
            serializedResultCounter.increaseCount();
            operationResult_operationResult.set_proprietary(asn1OctetString);
        }
        return resultStruct;
    }

    public static final OperationResult_operationResult convertThrowableToError(Throwable throwable) {
        OperationResult_operationResult operationResult_operationResult = new OperationResult_operationResult();
        Throwable throwable2 = Exceptions.getRoot(throwable);
        if (throwable2 != null) {
            throwable = throwable2;
        }
        long l = AsnClassesEncoderDecoder.getErrorCode(throwable);
        String string = Exceptions.getExceptionDumpString(throwable, false);
        String string2 = throwable.getMessage();
        if (string2 == null) {
            string2 = "";
        }
        Parameters parameters = new Parameters(0);
        if (throwable instanceof ConvertsToParameters) {
            try {
                ConvertsToParameters convertsToParameters = (ConvertsToParameters)((Object)throwable);
                parameters = AsnClassesEncoderDecoder.convertObjectsAndSignatureToParameters(convertsToParameters.getParameters(), convertsToParameters.getSignature());
            }
            catch (Throwable throwable3) {
                logcat.error((Object)"could not convert to parameters ", throwable3);
            }
        }
        operationResult_operationResult.set_error(new Error(l, string2, parameters, string));
        return operationResult_operationResult;
    }

    private static final long getErrorCode(Throwable throwable) {
        Long l = (Long)exceptionConversionMap.get(throwable.getClass());
        if (l == null) {
            if (throwable instanceof RpcErrorException) {
                return ((RpcErrorException)throwable).getCode();
            }
            return 0L;
        }
        return l;
    }

    public static final ServerMessage createServerMessage(String string, javax.management.Notification notification) throws EncodingException {
        Object object;
        Parameters parameters = null;
        if (notification instanceof ConvertsToParameters) {
            object = (ConvertsToParameters)((Object)notification);
            parameters = AsnClassesEncoderDecoder.convertObjectsAndSignatureToParameters(object.getParameters(), object.getSignature());
        } else if (notification instanceof Serializable) {
            try {
                logcat.debug((Object)"createServerMessage: going to serialize notification");
                parameters = new Parameters(1);
                parameters.elements[0] = AsnClassesEncoderDecoder.convertJavaObjectToParameter(AsnClassesEncoderDecoder.serializeObjectForServerMsg(notification), "byte[]");
            }
            catch (IOException iOException) {
                logcat.warn((Object)iOException, (Throwable)iOException);
                throw new EncodingException(iOException.getMessage());
            }
        }
        object = new Notification(string, notification.getType(), notification.getMessage(), notification.getSequenceNumber(), notification.getTimeStamp(), parameters);
        ServerMessage serverMessage = new ServerMessage();
        serverMessage.set_notification((Notification)((Object)object));
        return serverMessage;
    }

    public static final javax.management.Notification createNotification(ServerMessage serverMessage) {
        Notification notification = (Notification)serverMessage.getElement();
        javax.management.Notification notification2 = new javax.management.Notification(notification.type.value, notification.objectName.value, notification.sequenceNumber.value, notification.timeStamp.value, notification.message.value);
        if (notification.additionalData != null) {
            notification2.setUserData(AsnClassesEncoderDecoder.convertParametersToJavaObjects((Parameters)notification.additionalData).args);
        }
        return notification2;
    }

    public static final Parameters convertObjectsAndSignatureToParameters(Object[] objectArray, String[] stringArray) throws EncodingException {
        Object object;
        AsnClassesEncoderDecoder.my_assert(objectArray.length == stringArray.length, "args length and signature length don't match");
        if (objectArray.length == 1 && objectArray[0] != null && objectArray[0] instanceof ConvertsToParameters) {
            object = (ConvertsToParameters)objectArray[0];
            objectArray = object.getParameters();
            stringArray = object.getSignature();
        }
        object = new Parameters(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            ((Parameters)((Object)object)).elements[i] = AsnClassesEncoderDecoder.convertJavaObjectToParameter(objectArray[i], stringArray[i]);
        }
        return object;
    }

    public static final ParametersStruct convertParametersToJavaObjects(Parameters parameters) {
        Object[] objectArray = new Object[parameters.elements.length];
        String[] stringArray = new String[parameters.elements.length];
        for (int i = 0; i < objectArray.length; ++i) {
            ParameterStruct parameterStruct = AsnClassesEncoderDecoder.convertParameterToJavaObject(parameters.elements[i]);
            objectArray[i] = parameterStruct.value;
            stringArray[i] = parameterStruct.signature;
        }
        return new ParametersStruct(objectArray, stringArray);
    }

    private static final Class findClassFotObjectAndSignature(Object object, String string) throws EncodingException {
        Class<?> clazz = null;
        try {
            if (object != null) {
                clazz = object.getClass();
            } else {
                Class clazz2 = (Class)signatureConversionMap.get(string);
                if (clazz2 != null) {
                    return clazz2;
                }
                clazz = Class.forName(string);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            logcat.error((Object)("convertJavaObjectToParameter could not find " + string), (Throwable)classNotFoundException);
            throw new EncodingException("convertJavaObjectToParameter could not find " + string);
        }
        return clazz;
    }

    public static final Parameter convertJavaObjectToParameter(Object object, String string) throws EncodingException {
        Class clazz = AsnClassesEncoderDecoder.findClassFotObjectAndSignature(object, string);
        int n = AsnClassesEncoderDecoder.calcClassCode(clazz);
        switch (n) {
            case 1632: {
                return AsnClassesEncoderDecoder.convertBooleanToParameter(object);
            }
            case 181: {
                return AsnClassesEncoderDecoder.convertBooleanArrayToParameter(object);
            }
            case 157: {
                return AsnClassesEncoderDecoder.convertByteArrayToParameter(object);
            }
            case 1531: {
                return AsnClassesEncoderDecoder.convertDoubleToParameter(object);
            }
            case 159: {
                return AsnClassesEncoderDecoder.convertDoubleArrayToParameter(object);
            }
            case 164: {
                return AsnClassesEncoderDecoder.convertIntegerArrayToParameter(object);
            }
            case 1646: {
                return AsnClassesEncoderDecoder.convertIntegerToParameter(object);
            }
            case 1328: {
                return AsnClassesEncoderDecoder.convertLongToParameter(object);
            }
            case 165: {
                return AsnClassesEncoderDecoder.convertLongArrayToParameter(object);
            }
            case 1456: {
                return AsnClassesEncoderDecoder.convertShortToParameter(object);
            }
            case 174: {
                return AsnClassesEncoderDecoder.convertShortArrayToParameter(object);
            }
            case 1559: {
                return AsnClassesEncoderDecoder.convertStringToParameter(object);
            }
            case 1785: {
                return AsnClassesEncoderDecoder.convertStringArrayToParameter(object);
            }
        }
        String string2 = object != null ? object.getClass().getName() : "null";
        throw new EncodingException("could not convert " + string2);
    }

    public static int calcClassCode(Class clazz) {
        byte[] byArray = clazz.getName().getBytes();
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            n += byArray[i];
        }
        return n;
    }

    public static final ParameterStruct convertParameterToJavaObject(Parameter parameter) {
        switch (parameter.getChoiceID()) {
            case 1: {
                return new ParameterStruct(((Asn1UTF8String)parameter.getElement()).value, BaseApi.STRING_CLASS_NAME);
            }
            case 8: {
                Asn1UTF8String[] asn1UTF8StringArray = ((Parameter_stringArray)parameter.getElement()).elements;
                String[] stringArray = new String[asn1UTF8StringArray.length];
                for (int i = 0; i < asn1UTF8StringArray.length; ++i) {
                    stringArray[i] = asn1UTF8StringArray[i].value;
                }
                return new ParameterStruct(stringArray, BaseApi.STRING_ARRAY_CLASS_NAME);
            }
            case 4: {
                Integer n = new Integer((int)((Asn1Integer)parameter.getElement()).value);
                return new ParameterStruct(n, "int");
            }
            case 5: {
                return new ParameterStruct(new Long(((Asn1Integer)parameter.getElement()).value), "long");
            }
            case 6: {
                Asn1Boolean asn1Boolean = (Asn1Boolean)parameter.getElement();
                Boolean bl = !asn1Boolean.value ? Boolean.FALSE : Boolean.TRUE;
                return new ParameterStruct(bl, "boolean");
            }
            case 10: {
                Asn1Integer[] asn1IntegerArray = ((Parameter_intArray)parameter.getElement()).elements;
                int[] nArray = new int[asn1IntegerArray.length];
                for (int i = 0; i < asn1IntegerArray.length; ++i) {
                    nArray[i] = (int)asn1IntegerArray[i].value;
                }
                return new ParameterStruct(nArray, BaseApi.INT_ARRAY_CLASS_NAME);
            }
            case 11: {
                Asn1Integer[] asn1IntegerArray = ((Parameter_longArray)parameter.getElement()).elements;
                long[] lArray = new long[asn1IntegerArray.length];
                for (int i = 0; i < asn1IntegerArray.length; ++i) {
                    lArray[i] = asn1IntegerArray[i].value;
                }
                return new ParameterStruct(lArray, BaseApi.LONG_ARRAY_CLASS_NAME);
            }
            case 12: {
                Asn1Integer[] asn1IntegerArray = ((Parameter_shortArray)parameter.getElement()).elements;
                short[] sArray = new short[asn1IntegerArray.length];
                for (int i = 0; i < asn1IntegerArray.length; ++i) {
                    sArray[i] = (short)asn1IntegerArray[i].value;
                }
                return new ParameterStruct(sArray, BaseApi.SHORT_ARRAY_CLASS_NAME);
            }
            case 14: {
                return new ParameterStruct(null, BaseApi.STRING_CLASS_NAME);
            }
            case 2: {
                Double d = new Double(((Asn1Real)parameter.getElement()).value);
                return new ParameterStruct(d, "double");
            }
            case 9: {
                Asn1Real[] asn1RealArray = ((Parameter_realArray)parameter.getElement()).elements;
                double[] dArray = new double[asn1RealArray.length];
                for (int i = 0; i < asn1RealArray.length; ++i) {
                    dArray[i] = asn1RealArray[i].value;
                }
                return new ParameterStruct(dArray, BaseApi.DOUBLE_ARRAY_CLASS_NAME);
            }
            case 3: {
                Short s = new Short((short)((Asn1Integer)parameter.getElement()).value);
                return new ParameterStruct(s, "short");
            }
            case 13: {
                Parameter_booleanArray parameter_booleanArray = (Parameter_booleanArray)parameter.getElement();
                boolean[] blArray = new boolean[parameter_booleanArray.elements.length];
                for (int i = 0; i < blArray.length; ++i) {
                    blArray[i] = parameter_booleanArray.elements[i].value;
                }
                return new ParameterStruct(blArray, BaseApi.BOOLEAN_ARRAY_CLASS_NAME);
            }
            case 7: {
                return new ParameterStruct(((Asn1OctetString)parameter.getElement()).value, BaseApi.BYTE_ARRAY_CLASS_NAME);
            }
            case 20: {
                return new ParameterStruct(null, BaseApi.BOOLEAN_ARRAY_CLASS_NAME);
            }
            case 21: {
                return new ParameterStruct(null, BaseApi.BYTE_ARRAY_CLASS_NAME);
            }
            case 18: {
                return new ParameterStruct(null, BaseApi.INT_ARRAY_CLASS_NAME);
            }
            case 19: {
                return new ParameterStruct(null, BaseApi.LONG_ARRAY_CLASS_NAME);
            }
            case 17: {
                return new ParameterStruct(null, BaseApi.SHORT_ARRAY_CLASS_NAME);
            }
            case 16: {
                return new ParameterStruct(null, BaseApi.DOUBLE_ARRAY_CLASS_NAME);
            }
            case 15: {
                return new ParameterStruct(null, BaseApi.STRING_ARRAY_CLASS_NAME);
            }
        }
        AsnClassesEncoderDecoder.my_assert(false, "unknown parameter choice ID-" + parameter.getChoiceID());
        return null;
    }

    private static final void my_assert(boolean bl, String string) {
        if (!bl) {
            throw new IllegalStateException("assertion failed: " + string);
        }
    }

    public static final Parameter convertStringToParameter(Object object) {
        Parameter parameter = new Parameter();
        if (object == null) {
            parameter.set_nullString();
        } else {
            parameter.set_string(new Asn1UTF8String((String)object));
        }
        return parameter;
    }

    public static final Parameter convertDoubleToParameter(Object object) {
        Parameter parameter = new Parameter();
        parameter.set_real(new Asn1Real(((Double)object).doubleValue()));
        return parameter;
    }

    public static final Parameter convertShortToParameter(Object object) {
        Parameter parameter = new Parameter();
        parameter.set_short_(new Asn1Integer(((Short)object).longValue()));
        return parameter;
    }

    public static final Parameter convertIntegerToParameter(Object object) {
        Parameter parameter = new Parameter();
        parameter.set_int_(new Asn1Integer(((Integer)object).longValue()));
        return parameter;
    }

    public static final Parameter convertLongToParameter(Object object) {
        Parameter parameter = new Parameter();
        parameter.set_long_(new Asn1Integer(((Long)object).longValue()));
        return parameter;
    }

    public static final Parameter convertBooleanToParameter(Object object) {
        Parameter parameter = new Parameter();
        parameter.set_boolean_(new Asn1Boolean(((Boolean)object).booleanValue()));
        return parameter;
    }

    public static final Parameter convertByteArrayToParameter(Object object) {
        Parameter parameter = new Parameter();
        if (object != null) {
            parameter.set_byteArray(new Asn1OctetString((byte[])object));
        } else {
            parameter.set_nullByteArray();
        }
        return parameter;
    }

    public static final Parameter convertStringArrayToParameter(Object object) {
        Parameter parameter = new Parameter();
        if (object != null) {
            String[] stringArray = (String[])object;
            Parameter_stringArray parameter_stringArray = new Parameter_stringArray(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                parameter_stringArray.elements[i] = stringArray[i] != null ? new Asn1UTF8String(stringArray[i]) : new Asn1UTF8String("");
            }
            parameter.set_stringArray(parameter_stringArray);
        } else {
            parameter.set_nullStringArray();
        }
        return parameter;
    }

    public static final Parameter convertDoubleArrayToParameter(Object object) {
        Parameter parameter = new Parameter();
        if (object != null) {
            double[] dArray = (double[])object;
            Parameter_realArray parameter_realArray = new Parameter_realArray(dArray.length);
            for (int i = 0; i < dArray.length; ++i) {
                parameter_realArray.elements[i] = new Asn1Real(dArray[i]);
            }
            parameter.set_realArray(parameter_realArray);
        } else {
            parameter.set_nullRealArray();
        }
        return parameter;
    }

    public static final Parameter convertIntegerArrayToParameter(Object object) {
        Parameter parameter = new Parameter();
        if (object != null) {
            int[] nArray = (int[])object;
            Parameter_intArray parameter_intArray = new Parameter_intArray(nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                parameter_intArray.elements[i] = new Asn1Integer((long)nArray[i]);
            }
            parameter.set_intArray(parameter_intArray);
        } else {
            parameter.set_nullIntArray();
        }
        return parameter;
    }

    public static final Parameter convertLongArrayToParameter(Object object) {
        Parameter parameter = new Parameter();
        if (object != null) {
            long[] lArray = (long[])object;
            Parameter_longArray parameter_longArray = new Parameter_longArray(lArray.length);
            for (int i = 0; i < lArray.length; ++i) {
                parameter_longArray.elements[i] = new Asn1Integer(lArray[i]);
            }
            parameter.set_longArray(parameter_longArray);
        } else {
            parameter.set_nullLongArray();
        }
        return parameter;
    }

    public static final Parameter convertShortArrayToParameter(Object object) {
        Parameter parameter = new Parameter();
        if (object != null) {
            short[] sArray = (short[])object;
            Parameter_shortArray parameter_shortArray = new Parameter_shortArray(sArray.length);
            for (int i = 0; i < sArray.length; ++i) {
                parameter_shortArray.elements[i] = new Asn1Integer((long)sArray[i]);
            }
            parameter.set_shortArray(parameter_shortArray);
        } else {
            parameter.set_nullShortArray();
        }
        return parameter;
    }

    public static final Parameter convertBooleanArrayToParameter(Object object) {
        Parameter parameter = new Parameter();
        if (object != null) {
            boolean[] blArray = (boolean[])object;
            Parameter_booleanArray parameter_booleanArray = new Parameter_booleanArray(blArray.length);
            for (int i = 0; i < blArray.length; ++i) {
                parameter_booleanArray.elements[i] = new Asn1Boolean(blArray[i]);
            }
            parameter.set_booleanArray(parameter_booleanArray);
        } else {
            parameter.set_nullBooleanArray();
        }
        return parameter;
    }

    public static final Object decodeResult(OperationResult_operationResult operationResult_operationResult, Asn1Boolean asn1Boolean) {
        switch (operationResult_operationResult.getChoiceID()) {
            case 2: {
                Error error = (Error)operationResult_operationResult.getElement();
                Parameters parameters = error.additionalData == null ? new Parameters(0) : error.additionalData;
                return new RpcErrorException(error.code.value, error.message.value, error.stackTrace.value, AsnClassesEncoderDecoder.convertParametersToJavaObjects((Parameters)parameters).args);
            }
            case 1: {
                Success success = (Success)operationResult_operationResult.getElement();
                switch (success.getChoiceID()) {
                    case 2: {
                        return null;
                    }
                    case 1: {
                        Object[] objectArray = AsnClassesEncoderDecoder.convertParametersToJavaObjects((Parameters)((Parameters)success.getElement())).args;
                        if (asn1Boolean == null || asn1Boolean.value && objectArray != null && objectArray.length == 1) {
                            return objectArray[0];
                        }
                        return objectArray;
                    }
                    case 3: {
                        return null;
                    }
                }
                AsnClassesEncoderDecoder.my_assert(false, "unknown choice ID for success " + success.getChoiceID());
            }
            case 3: {
                Asn1OctetString asn1OctetString = (Asn1OctetString)operationResult_operationResult.getElement();
                try {
                    Object object = AsnClassesEncoderDecoder.deserialize(asn1OctetString.value);
                    if (logcat.isDebugEnabled()) {
                        String string = object != null ? object.getClass().getName() : "null";
                        logcat.debug((Object)("returning serialized result " + object));
                    }
                    return object;
                }
                catch (Throwable throwable) {
                    return throwable;
                }
            }
            case 4: {
                return null;
            }
        }
        AsnClassesEncoderDecoder.my_assert(false, "unknown choice ID for result " + operationResult_operationResult.getChoiceID());
        return null;
    }

    public static final Object deserialize(byte[] byArray) throws ClassNotFoundException, IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        return objectInputStream.readObject();
    }

    public static final Object decodeResult(ServerMessage serverMessage) {
        Object object = null;
        OperationResult operationResult = (OperationResult)serverMessage.getElement();
        try {
            object = AsnClassesEncoderDecoder.decodeResult(operationResult.operationResult, operationResult.scalarResult);
        }
        catch (Throwable throwable) {
            logcat.error((Object)("could not decode result:\n" + AsnClassesEncoderDecoder.toString((Asn1TypeIF)serverMessage, "ServerMessage")), throwable);
            object = throwable;
        }
        return object;
    }

    private static final byte[] serializeObjectForServerMsg(Object object) throws IOException {
        if (object instanceof GenericSerializable) {
            try {
                byte[] byArray = new byte[10240];
                int n = ((GenericSerializable)object).writeObject(byArray, 0);
                if (n < 5120) {
                    byte[] byArray2 = new byte[n];
                    System.arraycopy(byArray, 0, byArray2, 0, n);
                    return byArray2;
                }
                return byArray;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IOException(illegalArgumentException.getMessage());
            }
        }
        return AsnClassesEncoderDecoder.serializeObject(object);
    }

    private static final byte[] serializeObject(Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1000);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        objectOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static final ClientMessage encodeProprietary(long l, long l2, Object object) throws ClassNotFoundException, IOException {
        Operation_operation operation_operation = new Operation_operation();
        Asn1OctetString asn1OctetString = new Asn1OctetString(AsnClassesEncoderDecoder.serializeObject(object));
        operation_operation.set_proprietary(asn1OctetString);
        Operation operation = new Operation(l, l2, operation_operation);
        ClientMessage clientMessage = new ClientMessage();
        clientMessage.set_operation(operation);
        return clientMessage;
    }

    public static final ClientMessage encodeInvoke(long l, long l2, String string, String string2, Object[] objectArray, String[] stringArray) throws EncodingException {
        Invoke invoke = new Invoke(string, string2, AsnClassesEncoderDecoder.convertObjectsAndSignatureToParameters(objectArray, stringArray));
        Operation_operation operation_operation = new Operation_operation();
        operation_operation.set_invoke(invoke);
        Operation operation = new Operation(l, l2, operation_operation);
        ClientMessage clientMessage = new ClientMessage();
        clientMessage.set_operation(operation);
        return clientMessage;
    }

    public static final ClientMessage encodeGetAttribute(long l, long l2, String string, String string2) {
        GetAttribute getAttribute = new GetAttribute(string, string2);
        Operation_operation operation_operation = new Operation_operation();
        operation_operation.set_getAttribute(getAttribute);
        Operation operation = new Operation(l, l2, operation_operation);
        ClientMessage clientMessage = new ClientMessage();
        clientMessage.set_operation(operation);
        return clientMessage;
    }

    public static final ClientMessage encodeSetAttribute(long l, long l2, String string, String string2, Object object, String string3) throws EncodingException {
        SetAttribute setAttribute = new SetAttribute(string, string2, AsnClassesEncoderDecoder.convertJavaObjectToParameter(object, string3));
        Operation_operation operation_operation = new Operation_operation();
        operation_operation.set_setAttribute(setAttribute);
        Operation operation = new Operation(l, l2, operation_operation);
        ClientMessage clientMessage = new ClientMessage();
        clientMessage.set_operation(operation);
        return clientMessage;
    }

    public static final ClientMessage encodeGetNotifications(long l, long l2, String string, String[] stringArray) {
        Object object;
        GetNotifications getNotifications = new GetNotifications(string);
        if (stringArray != null && stringArray.length > 0) {
            object = new GetNotifications_typeFilter(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                ((GetNotifications_typeFilter)((Object)object)).elements[i] = new Asn1UTF8String(stringArray[i]);
            }
            getNotifications.typeFilter = object;
        }
        object = new Operation_operation();
        object.set_getNotifications(getNotifications);
        Operation operation = new Operation(l, l2, (Operation_operation)((Object)object));
        ClientMessage clientMessage = new ClientMessage();
        clientMessage.set_operation(operation);
        return clientMessage;
    }

    public static final ClientMessage encodeDontGetNotifications(long l, long l2, String string) {
        DontGetNotifications_target dontGetNotifications_target = new DontGetNotifications_target();
        if (string == null) {
            dontGetNotifications_target.set_all();
        } else {
            dontGetNotifications_target.set_objectName(new Asn1UTF8String(string));
        }
        DontGetNotifications dontGetNotifications = new DontGetNotifications(dontGetNotifications_target);
        Operation_operation operation_operation = new Operation_operation();
        operation_operation.set_dontGetNotifications(dontGetNotifications);
        Operation operation = new Operation(l, l2, operation_operation);
        ClientMessage clientMessage = new ClientMessage();
        clientMessage.set_operation(operation);
        return clientMessage;
    }

    public static final String toString(Asn1TypeIF asn1TypeIF, String string) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            if (asn1TypeIF != null) {
                asn1TypeIF.print(printStream, string, 1);
            } else {
                printStream.println("NULL message received");
            }
            printStream.close();
            byteArrayOutputStream.close();
            return new String(byteArrayOutputStream.toByteArray());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public static final int getEncodedLength(Asn1Type asn1Type, AsnToWireEncoder asnToWireEncoder) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            asnToWireEncoder.encode(asn1Type, byteArrayOutputStream);
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray().length;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1;
        }
    }

    public static long getSerializedResultCounter() {
        return serializedResultCounter.getCounter();
    }

    public static void resetSerializedResultCounter() {
        serializedResultCounter.reset();
    }

    static void addExceptionToCodeMapping(Class clazz, long l) throws IllegalArgumentException {
        if (!Throwable.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz.getName() + " is not a throwable class");
        }
        if (exceptionConversionMap.containsKey(clazz)) {
            throw new IllegalArgumentException(clazz.getName() + " already has an error code");
        }
        if (exceptionConversionMap.containsValue(new Long(l))) {
            throw new IllegalArgumentException("the code " + l + " is already assigned");
        }
        exceptionConversionMap.put(clazz, new Long(l));
    }

    static {
        signatureConversionMap.put("java.lang.String[]", new String[0].getClass());
        signatureConversionMap.put("[Ljava.lang.String", new String[0].getClass());
        signatureConversionMap.put("int[]", new int[0].getClass());
        signatureConversionMap.put("[I", new int[0].getClass());
        signatureConversionMap.put("short[]", new short[0].getClass());
        signatureConversionMap.put("[S", new short[0].getClass());
        signatureConversionMap.put("double[]", new double[0].getClass());
        signatureConversionMap.put("[D", new double[0].getClass());
        signatureConversionMap.put("long[]", new long[0].getClass());
        signatureConversionMap.put("[J", new long[0].getClass());
        signatureConversionMap.put("byte[]", new byte[0].getClass());
        signatureConversionMap.put("[B", new byte[0].getClass());
        signatureConversionMap.put("boolean[]", new boolean[0].getClass());
        signatureConversionMap.put("[Z", new boolean[0].getClass());
        parameterConvertorsMap = new HashMap();
        try {
            Class[] classArray = new Class[]{Object.class};
            Class<AsnClassesEncoderDecoder> clazz = AsnClassesEncoderDecoder.class;
            parameterConvertorsMap.put(String.class, clazz.getMethod("convertStringToParameter", classArray));
            parameterConvertorsMap.put(Double.class, clazz.getMethod("convertDoubleToParameter", classArray));
            parameterConvertorsMap.put(Short.class, clazz.getMethod("convertShortToParameter", classArray));
            parameterConvertorsMap.put(Integer.class, clazz.getMethod("convertIntegerToParameter", classArray));
            parameterConvertorsMap.put(Long.class, clazz.getMethod("convertLongToParameter", classArray));
            parameterConvertorsMap.put(Boolean.class, clazz.getMethod("convertBooleanToParameter", classArray));
            parameterConvertorsMap.put(byte[].class, clazz.getMethod("convertByteArrayToParameter", classArray));
            parameterConvertorsMap.put(String[].class, clazz.getMethod("convertStringArrayToParameter", classArray));
            parameterConvertorsMap.put(double[].class, clazz.getMethod("convertDoubleArrayToParameter", classArray));
            parameterConvertorsMap.put(int[].class, clazz.getMethod("convertIntegerArrayToParameter", classArray));
            parameterConvertorsMap.put(long[].class, clazz.getMethod("convertLongArrayToParameter", classArray));
            parameterConvertorsMap.put(short[].class, clazz.getMethod("convertShortArrayToParameter", classArray));
            parameterConvertorsMap.put(boolean[].class, clazz.getMethod("convertBooleanArrayToParameter", classArray));
            parameterConvertorsMap.put(String.class.getName(), clazz.getMethod("convertStringToParameter", classArray));
            parameterConvertorsMap.put(byte[].class.getName(), clazz.getMethod("convertByteArrayToParameter", classArray));
            parameterConvertorsMap.put(String[].class.getName(), clazz.getMethod("convertStringArrayToParameter", classArray));
            parameterConvertorsMap.put(double[].class.getName(), clazz.getMethod("convertDoubleArrayToParameter", classArray));
            parameterConvertorsMap.put(int[].class.getName(), clazz.getMethod("convertIntegerArrayToParameter", classArray));
            parameterConvertorsMap.put(long[].class.getName(), clazz.getMethod("convertLongArrayToParameter", classArray));
            parameterConvertorsMap.put(short[].class.getName(), clazz.getMethod("convertShortArrayToParameter", classArray));
            parameterConvertorsMap.put(boolean[].class.getName(), clazz.getMethod("convertBooleanArrayToParameter", classArray));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            logcat.fatal((Object)"could not initiate operation table", (Throwable)noSuchMethodException);
        }
        exceptionConversionMap = new HashMap(211);
        exceptionConversionMap.put(InstanceNotFoundException.class, new Long(1L));
        exceptionConversionMap.put(ReflectionException.class, new Long(2L));
        exceptionConversionMap.put(AttributeNotFoundException.class, new Long(3L));
        exceptionConversionMap.put(InvalidAttributeValueException.class, new Long(4L));
        exceptionConversionMap.put(MalformedObjectNameException.class, new Long(5L));
        exceptionConversionMap.put(NullPointerException.class, new Long(33000L));
        exceptionConversionMap.put(ClassCastException.class, new Long(33001L));
        exceptionConversionMap.put(RuntimeException.class, new Long(33002L));
        exceptionConversionMap.put(OutOfMemoryError.class, new Long(33003L));
        exceptionConversionMap.put(ClassNotFoundException.class, new Long(33004L));
        exceptionConversionMap.put(IllegalStateException.class, new Long(33005L));
        exceptionConversionMap.put(IllegalArgumentException.class, new Long(33006L));
        exceptionConversionMap.put(ArrayIndexOutOfBoundsException.class, new Long(33007L));
        exceptionConversionMap.put(NumberFormatException.class, new Long(33008L));
        exceptionConversionMap.put(NoSuchMethodError.class, new Long(33009L));
        exceptionConversionMap.put(NoSuchMethodException.class, new Long(33009L));
        exceptionConversionMap.put(IntrospectionException.class, new Long(330010L));
        exceptionConversionMap.put(MBeanRegistrationException.class, new Long(330011L));
        exceptionConversionMap.put(InstanceAlreadyExistsException.class, new Long(330012L));
        exceptionConversionMap.put(NotCompliantMBeanException.class, new Long(330013L));
        exceptionConversionMap.put(InterruptedException.class, new Long(330014L));
        exceptionConversionMap.put(DomainNotFoundException.class, new Long(100000L));
        exceptionConversionMap.put(NotASubscriberDomainException.class, new Long(100001L));
        exceptionConversionMap.put(SeException.class, new Long(100002L));
        exceptionConversionMap.put(SubscriberAlreadyExistsException.class, new Long(100003L));
        exceptionConversionMap.put(SubscriberDoesNotExistException.class, new Long(100004L));
        exceptionConversionMap.put(SubscriberDomainMappingException.class, new Long(100005L));
        exceptionConversionMap.put(SubscriberIpCongestionException.class, new Long(100006L));
        exceptionConversionMap.put(SubscriberMappingException.class, new Long(100007L));
        exceptionConversionMap.put(SubscriberIllegalName.class, new Long(100008L));
        exceptionConversionMap.put(NativeMethodStatusFailException.class, new Long(200000L));
        exceptionConversionMap.put(FunctionArgumentException.class, new Long(200001L));
        exceptionConversionMap.put(FatalException.class, new Long(500000L));
        exceptionConversionMap.put(InvalidParameterException.class, new Long(500003L));
        exceptionConversionMap.put(NoApplicationException.class, new Long(500004L));
        exceptionConversionMap.put(OperationAbortedException.class, new Long(500002L));
        exceptionConversionMap.put(ResourceShortageException.class, new Long(500001L));
        exceptionConversionMap.put(VpnDoesNotExistException.class, new Long(7000002L));
        exceptionConversionMap.put(VpnAlreadyExistsException.class, new Long(700000L));
        exceptionConversionMap.put(VpnMappingException.class, new Long(7000003L));
        exceptionConversionMap.put(DBSqlException.class, new Long(6000001L));
        exceptionConversionMap.put(ValueDoesNotMeetConstraintsException.class, new Long(100009L));
        serializedResultCounter = new StatsVar("RPC.serializedResults");
    }
}

