/*
 * Decompiled with CFR 0.152.
 */
package com.pcube.management.framework.rpc;

import com.objsys.asn1j.runtime.Asn1Exception;
import com.objsys.asn1j.runtime.Asn1Type;
import com.objsys.asn1j.runtime.Asn1TypeIF;
import com.pcube.management.common.BufferedInputStream;
import com.pcube.management.common.Configuration;
import com.pcube.management.common.InvocationException;
import com.pcube.management.common.auth.AuthenticationFailedException;
import com.pcube.management.common.auth.SecurityUtils;
import com.pcube.management.common.threads.HandoffBox;
import com.pcube.management.common.threads.ObjectFIFO;
import com.pcube.management.framework.agent.StatsVar;
import com.pcube.management.framework.agent.StatsVarObjectFifo;
import com.pcube.management.framework.rpc.AsnClassesEncoderDecoder;
import com.pcube.management.framework.rpc.AsnToWireEncoder;
import com.pcube.management.framework.rpc.BERDecoder;
import com.pcube.management.framework.rpc.BEREncoder;
import com.pcube.management.framework.rpc.ClientNotificationDispatcher;
import com.pcube.management.framework.rpc.ConnectionEstablishmentFailedException;
import com.pcube.management.framework.rpc.DisconnectListener;
import com.pcube.management.framework.rpc.EncodingException;
import com.pcube.management.framework.rpc.IncomingMessagesDispatcher;
import com.pcube.management.framework.rpc.InputQueueWorker;
import com.pcube.management.framework.rpc.KeepAliveProvider;
import com.pcube.management.framework.rpc.NonCommittedRequestsMap;
import com.pcube.management.framework.rpc.OperationTimeoutException;
import com.pcube.management.framework.rpc.OutputQueueWorker;
import com.pcube.management.framework.rpc.ResultDispatcher;
import com.pcube.management.framework.rpc.ResultHandler;
import com.pcube.management.framework.rpc.RpcCommon;
import com.pcube.management.framework.rpc.RpcErrorException;
import com.pcube.management.framework.rpc.SessionCloseListener;
import com.pcube.management.framework.rpc.WireToAsnDecoder;
import com.pcube.management.framework.rpc.XERDecoderClient;
import com.pcube.management.framework.rpc.XEREncoder;
import com.pcube.management.framework.rpc.protocol.Challenge;
import com.pcube.management.framework.rpc.protocol.ChallengeReply;
import com.pcube.management.framework.rpc.protocol.ClientMessage;
import com.pcube.management.framework.rpc.protocol.Farewell;
import com.pcube.management.framework.rpc.protocol.Greeting;
import com.pcube.management.framework.rpc.protocol.GreetingReply;
import com.pcube.management.framework.rpc.protocol.KeepAlive;
import com.pcube.management.framework.rpc.protocol.ServerMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;
import org.xml.sax.SAXException;

public class Client
implements SessionCloseListener,
KeepAliveProvider {
    private static Category logcat;
    public static final String BER_ENCODING = "BER";
    public static final String XER_ENCODING = "XER";
    public static final int USER_CONNECTION_MODE = 1;
    public static final int MACHINE_CONNECTION_MODE = 2;
    public static final long DEFAULT_TIMEOUT = 45000L;
    private long operationTimout = 45000L;
    private boolean reliable;
    private NonCommittedRequestsMap ncrMap;
    private String version = "3.0";
    private String username = "";
    private String password = "";
    private long requestedAuthLevel;
    static final String[] CLIENT_STAT_NAMES;
    static int defaultInputQueueSize;
    static int defaultOutputQueueSize;
    static long NON_BLOCKING_THREAD_ID;
    static long BLOCKING_OPERATION_COUNTER;
    private Socket socket;
    private InputStream socketInputStream;
    private OutputStream socketOutputStream;
    private BufferedInputStream inputQueue;
    private ObjectFIFO outputQueue;
    private ObjectFIFO notificationQueue;
    StatsVarObjectFifo statsVarOutputQueue = null;
    StatsVarObjectFifo statsVarNotificationQueue = null;
    private static ThreadGroup threadGroup;
    private InputQueueWorker inputWorker;
    private OutputQueueWorker outputWorker;
    private ClientNotificationDispatcher clientNotificationDispatcher;
    private String sessionEncoding;
    private InetAddress peerAddress = null;
    private String name;
    private AsnToWireEncoder encoder;
    private WireToAsnDecoder decoder;
    private String serverMessage;
    private String serverVersion = null;
    private int connectionMode;
    private int inputReaderThreadPriority = 5;
    private int outputWriterThreadPriority = 5;
    private int messageDispatcherThreadPriority = 5;
    private int notificationsDispatcherThreadPriority = 5;
    private int inputQueueSize = 8192;
    private int outputQueueSize = 32;
    private int notificationQueueSize = 2048;
    private IncomingMessagesDispatcher incomingMessagesDispatcher;
    private boolean closed = true;
    private boolean closing = false;
    private boolean connecting = false;
    private long greetingTimeout = 10000L;
    private long challengeTimeout = 15000L;
    private StatsVar nonBlockingOperationCounter = null;
    private ResultDispatcher currentResultDispatcher;
    private DisconnectListener disconnectListener;
    private long blockingThreadID;
    private long keepAliveInterval = 10000L;
    private long sessionDeathTimeout = 20000L;
    private long readerFillPeriod = 2000L;
    private long writerYieldPeriod = 100L;
    private boolean dropNotificationsIfFull;
    private ResultHandler resutlHandler;
    private StatsVar proprietaryInvocationsCounter = null;
    private Date clientCreationDate;
    private int authLevel = -1;
    private boolean isAuthenticated = false;
    private byte[] serverChallenge = null;
    private byte[] encryptionKey;
    static final String PNAME_INPUT_READER_PRIORITY = "prpc.client.input.priority";
    static final String PNAME_OUTPUT_WRITER_PRIORITY = "prpc.client.output.priority";
    static final String PNAME_DISPATCHER_PRIORITY = "prpc.client.dispatcher.priority";
    static final String PNAME_NOTIFICATIONS_DISPATCHER_PRIORITY = "prpc.client.notifications.priority";
    static final String PNAME_MACHINE_MODE_INPUT_QUEUE_SIZE = "prpc.client.input.machinemode.bytesize";
    static final String PNAME_USER_MODE_INPUT_QUEUE_SIZE = "prpc.client.input.usermode.bytesize";
    static final String PNAME_MACHINE_MODE_OUTPUT_QUEUE_SIZE = "prpc.client.output.machinemode.recordnum";
    static final String PNAME_USER_MODE_OUTPUT_QUEUE_SIZE = "prpc.client.output.usermode.recordnum";
    static final String PNAME_NOTIFICATION_QUEUE_SIZE = "prpc.client.notification.recordnum";
    static final String PNAME_GREETING_TIMEOUT = "prpc.client.greeting.timeout";
    static final String PNAME_KEEP_ALIVE_INTERVAL = "prpc.client.keepalive.period";
    static final String PNAME_READER_FILL_PERIOD = "prpc.client.input.period";
    static final String PNAME_WRITER_YIELD_PERIOD = "prpc.client.output.period";
    static final String PNAME_SESSION_DEATH_TIMEOUT = "prpc.client.death.timeout";
    static final String PNAME_DROP_NOTIFICATIONS = "prpc.client.notifications.drop";
    static final String PNAME_OPERATION_TIMEOUT = "prpc.client.operation.timeout";
    static final int DEFAULT_READER_PRIORITY = 5;
    static final int DEFAULT_WRITER_PRIORITY = 5;
    static final int DEFAULT_DISPATCHER_PRIORITY = 5;
    static final int DEFAULT_NOTIFICATIONS_DISPATCHER_PRIORITY = 5;
    static final int DEFAULT_MACHINE_MODE_INPUT_QUEUE_SIZE = 131072;
    static final int DEFAULT_USER_MODE_INPUT_QUEUE_SIZE = 8192;
    static final int DEFAULT_MACHINE_MODE_OUTPUT_QUEUE_SIZE = 2048;
    static final int DEFAULT_USER_MODE_OUTPUT_QUEUE_SIZE = 32;
    static final int DEFAULT_NOTIFICATION_QUEUE_SIZE = 2048;
    static final long DEFAULT_GREETING_TIMEOUT = 10000L;
    static final long DEFAULT_CHALLENGE_TIMEOUT = 15000L;
    static final long DEFAULT_KEEP_ALIVE_INTERVAL = 10000L;
    static final long DEFAULT_READER_FILL_PERIOD = 2000L;
    static final long DEFAULT_WRITER_YIELD_PERIOD = 100L;
    static final long DEFAULT_SESSION_DEATH_TIMEOUT = 20000L;
    static final boolean DEFAULT_DROP_NOTIFICATIONS = false;
    public static final int DEFAULT_SERVER_PORT = 14374;

    public Client() {
        this(BER_ENCODING, 2, false);
    }

    public Client(String string, String string2) {
        this(BER_ENCODING, "rpc-client-" + new Date().toString(), 5, 5, defaultInputQueueSize, defaultOutputQueueSize, 2, false, string, string2, 15L);
    }

    public Client(String string, String string2, long l) {
        this(BER_ENCODING, "rpc-client-" + new Date().toString(), 5, 5, defaultInputQueueSize, defaultOutputQueueSize, 2, false, string, string2, l);
    }

    public Client(String string, int n) {
        this(string, "rpc-client-" + new Date().toString(), n, false);
    }

    public Client(String string, String string2, int n) {
        this(string, string2, defaultInputQueueSize, defaultOutputQueueSize, n, false);
    }

    public Client(String string, String string2, int n, int n2, int n3) {
        this(string, string2, 5, 5, n, n2, n3, false);
    }

    public Client(boolean bl) {
        this(BER_ENCODING, 2, bl);
    }

    public Client(String string, int n, boolean bl) {
        this(string, "rpc-client-" + new Date().toString(), n, bl);
    }

    public Client(String string, String string2, int n, boolean bl) {
        this(string, string2, defaultInputQueueSize, defaultOutputQueueSize, n, bl);
    }

    public Client(String string, String string2, int n, int n2, int n3, boolean bl) {
        this(string, string2, 5, 5, n, n2, n3, bl);
    }

    public Client(String string, String string2, int n, int n2, int n3, int n4, int n5) {
        this(string, string2, n, n2, n3, n4, n5, false);
    }

    public Client(String string, String string2, int n, int n2, int n3, int n4, int n5, boolean bl) {
        this(string, string2, n, n2, n3, n4, n5, bl, "", "", -1L);
    }

    public Client(String string, String string2, int n, boolean bl, String string3, String string4, long l) {
        this(string, string2, 5, 5, defaultInputQueueSize, defaultOutputQueueSize, n, bl, string3, string4, l);
    }

    public Client(String string, String string2, int n, String string3, String string4, long l) {
        this(string, string2, 5, 5, defaultInputQueueSize, defaultOutputQueueSize, n, false, string3, string4, l);
    }

    public Client(String string, String string2, int n, int n2, int n3, int n4, int n5, boolean bl, String string3, String string4, long l) {
        this.name = string2;
        this.sessionEncoding = string;
        if (!string.equals(BER_ENCODING) && !string.equals(XER_ENCODING)) {
            throw new IllegalArgumentException("encoding must be one of BER/XER");
        }
        this.nonBlockingOperationCounter = new StatsVar(string2 + ".nonBlockingOperationCounter.Client");
        this.proprietaryInvocationsCounter = new StatsVar(string2 + ".proprietaryInvocationsCounter.Client");
        this.inputReaderThreadPriority = n;
        this.outputWriterThreadPriority = n2;
        this.inputQueueSize = n3;
        this.outputQueueSize = n4;
        this.connectionMode = n5;
        this.clientCreationDate = new Date();
        this.reliable = n5 == 1 ? false : bl;
        this.username = string3;
        this.password = string4;
        this.requestedAuthLevel = l;
        this.init(new Properties());
        if (bl) {
            this.ncrMap = new NonCommittedRequestsMap(n4);
        }
        this.outputQueue = new ObjectFIFO(n4, false);
        this.statsVarOutputQueue = new StatsVarObjectFifo(string2 + ".OutputQueue.Client", this.outputQueue);
    }

    public void init(Properties properties) {
        Configuration configuration = new Configuration("client", properties);
        this.inputReaderThreadPriority = configuration.getProperty(PNAME_INPUT_READER_PRIORITY, 5);
        this.outputWriterThreadPriority = configuration.getProperty(PNAME_OUTPUT_WRITER_PRIORITY, 5);
        this.messageDispatcherThreadPriority = configuration.getProperty(PNAME_DISPATCHER_PRIORITY, 5);
        this.notificationsDispatcherThreadPriority = configuration.getProperty(PNAME_NOTIFICATIONS_DISPATCHER_PRIORITY, 5);
        if (this.connectionMode == 2) {
            this.inputQueueSize = configuration.getProperty(PNAME_MACHINE_MODE_INPUT_QUEUE_SIZE, 131072);
            this.outputQueueSize = configuration.getProperty(PNAME_MACHINE_MODE_OUTPUT_QUEUE_SIZE, 2048);
        } else {
            this.inputQueueSize = configuration.getProperty(PNAME_USER_MODE_INPUT_QUEUE_SIZE, 8192);
            this.outputQueueSize = configuration.getProperty(PNAME_USER_MODE_OUTPUT_QUEUE_SIZE, 32);
        }
        this.notificationQueueSize = configuration.getProperty(PNAME_NOTIFICATION_QUEUE_SIZE, 2048);
        this.keepAliveInterval = configuration.getProperty(PNAME_KEEP_ALIVE_INTERVAL, 10000L);
        this.greetingTimeout = configuration.getProperty(PNAME_GREETING_TIMEOUT, 10000L);
        this.sessionDeathTimeout = configuration.getProperty(PNAME_SESSION_DEATH_TIMEOUT, 20000L);
        this.readerFillPeriod = configuration.getProperty(PNAME_READER_FILL_PERIOD, 2000L);
        this.writerYieldPeriod = configuration.getProperty(PNAME_WRITER_YIELD_PERIOD, 100L);
        this.dropNotificationsIfFull = configuration.getProperty(PNAME_DROP_NOTIFICATIONS, false);
        this.operationTimout = configuration.getProperty(PNAME_OPERATION_TIMEOUT, 45000L);
    }

    public void connect(String string) throws IOException, ConnectionEstablishmentFailedException, Asn1Exception, SAXException, AuthenticationFailedException {
        this.connect(string, 14374);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(String string, int n) throws IOException, ConnectionEstablishmentFailedException, Asn1Exception, SAXException, AuthenticationFailedException {
        Object object;
        Client client = this;
        synchronized (client) {
            if (!this.closed) {
                throw new IllegalStateException("connect called when not closed");
            }
            if (this.connecting) {
                throw new IllegalStateException("connect called when already connecting");
            }
            while (this.closing) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.connecting = true;
            this.notifyAll();
        }
        boolean bl = false;
        try {
            object = new InetSocketAddress(string, n);
            this.socket = new Socket();
            this.socket.connect((SocketAddress)object, (int)this.greetingTimeout);
            this.socketInputStream = this.socket.getInputStream();
            this.socketOutputStream = this.socket.getOutputStream();
            this.inputQueue = new BufferedInputStream(this.socketInputStream, this.inputQueueSize);
            this.outputQueue = new ObjectFIFO(this.outputQueueSize, false);
            if (this.reliable) {
                this.ncrMap.setCapacity(this.outputQueueSize);
            }
            this.notificationQueue = new ObjectFIFO(this.notificationQueueSize, false);
            this.statsVarNotificationQueue = new StatsVarObjectFifo(this.name + ".NotificationQueue.Client", this.notificationQueue);
            this.initASNEncoderDecoder();
            this.establishConnection();
            try {
                Object object2;
                boolean bl2;
                boolean bl3 = bl2 = this.connectionMode == 1;
                if (!bl2) {
                    this.socket.setTcpNoDelay(true);
                } else {
                    this.socket.setTcpNoDelay(false);
                }
                this.inputWorker = new InputQueueWorker(this.inputQueue, this.name + '_' + string + "[input]", this.inputReaderThreadPriority, threadGroup, this, true, this.readerFillPeriod, this.keepAliveInterval, this.sessionDeathTimeout);
                logcat.debug((Object)"connect: calling OutputQueueWorker");
                this.outputWorker = new OutputQueueWorker(this.outputQueue, this.socketOutputStream, this.encoder, this.name + '_' + string + "[output]", this.outputWriterThreadPriority, threadGroup, this, this, true, this.keepAliveInterval, this.writerYieldPeriod, bl2, this.socket.getRemoteSocketAddress(), this.name);
                logcat.debug((Object)"connect: calling ClientNotificationDispatcher");
                this.clientNotificationDispatcher = new ClientNotificationDispatcher(this.name + '_' + string + "[notify]", threadGroup, this.notificationsDispatcherThreadPriority, this.notificationQueue, this.clientNotificationDispatcher);
                logcat.debug((Object)"connect: calling IncomingMessagesDispatcher");
                this.incomingMessagesDispatcher = new IncomingMessagesDispatcher(this.decoder, this.name + '_' + string + "[dispatcher]", this.messageDispatcherThreadPriority, threadGroup, this, this.notificationQueue, this.dropNotificationsIfFull, this.ncrMap);
                logcat.debug((Object)"connect: calling inputWorker.start");
                this.inputWorker.start();
                if (this.reliable) {
                    object2 = this.outputQueue;
                    synchronized (object2) {
                        logcat.debug((Object)"connect: calling addAllNonCommittedRequests");
                        this.ncrMap.addAllNonCommittedRequests(this.outputQueue);
                    }
                }
                logcat.debug((Object)"connect: calling thread start");
                this.outputWorker.start();
                this.clientNotificationDispatcher.start();
                this.incomingMessagesDispatcher.start();
                logcat.debug((Object)"connect: calling setResultHandler");
                this.setResultHandler();
                object2 = this;
                synchronized (object2) {
                    logcat.debug((Object)"connect: calling notifyAll");
                    this.closed = false;
                    this.notifyAll();
                }
                if (logcat.isDebugEnabled()) {
                    logcat.debug((Object)("Client::connect connect done.\n serverName=" + this.serverMessage + ", serverVersion=" + this.serverVersion + ", encoding=" + this.sessionEncoding + ", inputThreadPriority=" + (this.inputWorker != null ? this.inputWorker.getPriority() : -1) + ", outputThreadPriority=" + this.outputWorker.getPriority() + ", inputQueueSize=" + this.getInputQueueSize() + ", outputQueueSize=" + this.getOutputQueueSize()));
                }
            }
            catch (RuntimeException runtimeException) {
                logcat.error((Object)runtimeException, (Throwable)runtimeException);
                bl = true;
                throw runtimeException;
            }
            catch (IOException iOException) {
                logcat.error((Object)iOException, (Throwable)iOException);
                bl = true;
                throw iOException;
            }
        }
        finally {
            this.connecting = false;
            if (bl) {
                object = this;
                synchronized (object) {
                    this.closed = false;
                    this.closing = false;
                    this.close("closing due to exception durring connection establishment", false);
                }
            }
        }
    }

    public long invoke(String string, String string2, Object[] objectArray, String[] stringArray) throws EncodingException, InterruptedException {
        long l = this.nextNonBlockingOperationCounter();
        ClientMessage clientMessage = AsnClassesEncoderDecoder.encodeInvoke(NON_BLOCKING_THREAD_ID, l, string, string2, objectArray, stringArray);
        this.sendAndReturn(clientMessage, this.operationTimout);
        return l;
    }

    public long invoke(String string, String string2, Object[] objectArray, String[] stringArray, long l) throws EncodingException, InterruptedException {
        long l2 = this.nextNonBlockingOperationCounter();
        ClientMessage clientMessage = AsnClassesEncoderDecoder.encodeInvoke(NON_BLOCKING_THREAD_ID, l2, string, string2, objectArray, stringArray);
        this.sendAndReturn(clientMessage, l);
        return l2;
    }

    public Object invokeAndWait(String string, String string2, Object[] objectArray, String[] stringArray, long l) throws InterruptedException, OperationTimeoutException, RpcErrorException, EncodingException {
        long l2 = this.nextBlockingThreadID();
        ClientMessage clientMessage = AsnClassesEncoderDecoder.encodeInvoke(l2, BLOCKING_OPERATION_COUNTER, string, string2, objectArray, stringArray);
        return this.sendAndWait(clientMessage, l2, l);
    }

    public long getAttribute(String string, String string2) throws InterruptedException {
        long l = this.nextNonBlockingOperationCounter();
        ClientMessage clientMessage = AsnClassesEncoderDecoder.encodeGetAttribute(NON_BLOCKING_THREAD_ID, l, string, string2);
        this.sendAndReturn(clientMessage, this.operationTimout);
        return l;
    }

    public long getAttribute(String string, String string2, int n) throws InterruptedException {
        long l = this.nextNonBlockingOperationCounter();
        ClientMessage clientMessage = AsnClassesEncoderDecoder.encodeGetAttribute(NON_BLOCKING_THREAD_ID, l, string, string2);
        this.sendAndReturn(clientMessage, n);
        return l;
    }

    public Object getAttributeAndWait(String string, String string2, long l) throws InterruptedException, OperationTimeoutException, RpcErrorException {
        long l2 = this.nextBlockingThreadID();
        ClientMessage clientMessage = AsnClassesEncoderDecoder.encodeGetAttribute(l2, BLOCKING_OPERATION_COUNTER, string, string2);
        return this.sendAndWait(clientMessage, l2, l);
    }

    public long setAttribute(String string, String string2, Object object, String string3) throws EncodingException, InterruptedException {
        long l = this.nextNonBlockingOperationCounter();
        ClientMessage clientMessage = AsnClassesEncoderDecoder.encodeSetAttribute(NON_BLOCKING_THREAD_ID, l, string, string2, object, string3);
        this.sendAndReturn(clientMessage, this.operationTimout);
        return l;
    }

    public long setAttribute(String string, String string2, Object object, String string3, int n) throws EncodingException, InterruptedException {
        long l = this.nextNonBlockingOperationCounter();
        ClientMessage clientMessage = AsnClassesEncoderDecoder.encodeSetAttribute(NON_BLOCKING_THREAD_ID, l, string, string2, object, string3);
        this.sendAndReturn(clientMessage, n);
        return l;
    }

    public Object setAttributeAndWait(String string, String string2, Object object, String string3, long l) throws InterruptedException, OperationTimeoutException, RpcErrorException, EncodingException {
        long l2 = this.nextBlockingThreadID();
        ClientMessage clientMessage = AsnClassesEncoderDecoder.encodeSetAttribute(l2, BLOCKING_OPERATION_COUNTER, string, string2, object, string3);
        return this.sendAndWait(clientMessage, l2, l);
    }

    public Object getNotifications(String string, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object, long l) throws InterruptedException {
        long l2 = this.nextBlockingThreadID();
        ClientMessage clientMessage = this.clientNotificationDispatcher.addNotificationListener(string, notificationListener, notificationFilter, object, l2, BLOCKING_OPERATION_COUNTER);
        try {
            if (clientMessage != null) {
                return this.sendAndWait(clientMessage, l2, l);
            }
            return null;
        }
        catch (InterruptedException interruptedException) {
            this.clientNotificationDispatcher.removeNotificationListener(string, notificationListener, l2, BLOCKING_OPERATION_COUNTER);
            throw (InterruptedException)interruptedException.fillInStackTrace();
        }
        catch (OperationTimeoutException operationTimeoutException) {
            this.clientNotificationDispatcher.removeNotificationListener(string, notificationListener, l2, BLOCKING_OPERATION_COUNTER);
            throw (InterruptedException)operationTimeoutException.fillInStackTrace();
        }
        catch (RpcErrorException rpcErrorException) {
            this.clientNotificationDispatcher.removeNotificationListener(string, notificationListener, l2, BLOCKING_OPERATION_COUNTER);
            throw (InterruptedException)rpcErrorException.fillInStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resendGetNotifications(long l) throws InterruptedException, OperationTimeoutException, RpcErrorException {
        ArrayList<String> arrayList = new ArrayList<String>();
        ClientNotificationDispatcher clientNotificationDispatcher = this.clientNotificationDispatcher;
        synchronized (clientNotificationDispatcher) {
            Iterator iterator = this.clientNotificationDispatcher.getObjectNamesIterator();
            while (iterator.hasNext()) {
                arrayList.add((String)iterator.next());
            }
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            long l2 = this.nextBlockingThreadID();
            ClientMessage clientMessage = this.clientNotificationDispatcher.regenerateNotificationListenerMessage((String)arrayList.get(i), l2, BLOCKING_OPERATION_COUNTER);
            if (logcat.isDebugEnabled()) {
                String string = AsnClassesEncoderDecoder.toString((Asn1TypeIF)clientMessage, "ClientMessage");
                logcat.debug((Object)("resendGetNotifications:: sending " + string));
            }
            this.sendAndWait(clientMessage, l2, l);
        }
    }

    public void resetNotificationListeners() {
        this.clientNotificationDispatcher.resetNotificationListeners();
    }

    public Object dontGetNotifications(String string, NotificationListener notificationListener, long l) throws InterruptedException, OperationTimeoutException, RpcErrorException {
        long l2 = this.nextBlockingThreadID();
        ClientMessage clientMessage = this.clientNotificationDispatcher.removeNotificationListener(string, notificationListener, l2, BLOCKING_OPERATION_COUNTER);
        if (clientMessage != null) {
            return this.sendAndWait(clientMessage, l2, l);
        }
        return null;
    }

    public long proprietaryOperation(Object object) throws IOException, ClassNotFoundException, InterruptedException {
        this.proprietaryInvocationsCounter.increaseCount();
        long l = this.nextNonBlockingOperationCounter();
        ClientMessage clientMessage = AsnClassesEncoderDecoder.encodeProprietary(NON_BLOCKING_THREAD_ID, l, object);
        this.sendAndReturn(clientMessage, this.operationTimout);
        return l;
    }

    public long proprietaryOperation(Object object, int n) throws IOException, ClassNotFoundException, InterruptedException {
        this.proprietaryInvocationsCounter.increaseCount();
        long l = this.nextNonBlockingOperationCounter();
        ClientMessage clientMessage = AsnClassesEncoderDecoder.encodeProprietary(NON_BLOCKING_THREAD_ID, l, object);
        this.sendAndReturn(clientMessage, n);
        return l;
    }

    public Object proprietaryOperationAndWait(Object object, long l) throws InterruptedException, OperationTimeoutException, RpcErrorException, IOException, ClassNotFoundException {
        this.proprietaryInvocationsCounter.increaseCount();
        long l2 = this.nextBlockingThreadID();
        ClientMessage clientMessage = AsnClassesEncoderDecoder.encodeProprietary(l2, BLOCKING_OPERATION_COUNTER, object);
        return this.sendAndWait(clientMessage, l2, l);
    }

    private final Object sendAndWait(ClientMessage clientMessage, long l, long l2) throws InterruptedException, OperationTimeoutException, RpcErrorException {
        if (!this.isActive()) {
            throw new IllegalStateException("connection is not active");
        }
        HandoffBox handoffBox = new HandoffBox(l2);
        this.incomingMessagesDispatcher.addHandoffBox(l, handoffBox);
        this.outputQueue.add((Object)clientMessage);
        ServerMessage serverMessage = (ServerMessage)((Object)handoffBox.getResult());
        if (!handoffBox.resultWasSet()) {
            throw new OperationTimeoutException();
        }
        Object object = AsnClassesEncoderDecoder.decodeResult(serverMessage);
        if (object instanceof Throwable) {
            if (object instanceof RpcErrorException) {
                throw (RpcErrorException)object;
            }
            throw new InvocationException((Throwable)object);
        }
        return object;
    }

    private final void sendAndReturn(ClientMessage clientMessage, long l) throws InterruptedException {
        if (this.reliable) {
            if (!this.ncrMap.addRequest(clientMessage, l)) {
                throw new InterruptedException("could not add message to map, timeout expired");
            }
        } else if (!this.isActive()) {
            throw new IllegalStateException("connection is not active");
        }
        if (!this.outputQueue.add((Object)clientMessage, l)) {
            if (this.reliable) {
                this.ncrMap.removeRequest(clientMessage);
            }
            throw new InterruptedException("could not add message to queue, timeout expired");
        }
    }

    public void disconnect() {
        this.disconnect(false);
    }

    public void disconnect(boolean bl) {
        this.close("user request", !bl);
    }

    public void setResultHandler(ResultHandler resultHandler) {
        ResultHandler resultHandler2 = this.resutlHandler;
        this.resutlHandler = resultHandler;
        if (!this.isClosed() && (resultHandler2 == null && resultHandler != null || resultHandler == null && resultHandler2 != null || resultHandler2 != null && !resultHandler2.equals(this.resutlHandler))) {
            this.setResultHandler();
        }
    }

    private void setResultHandler() {
        if (this.resutlHandler == null) {
            this.incomingMessagesDispatcher.setNonBlockingQueue(null);
        } else {
            ObjectFIFO objectFIFO = new ObjectFIFO(100, false);
            if (this.currentResultDispatcher != null) {
                this.currentResultDispatcher.requestStop();
                try {
                    this.currentResultDispatcher.join(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.currentResultDispatcher = new ResultDispatcher(objectFIFO, this.resutlHandler, this.name + "[async-dispatcher]", 5, threadGroup);
            this.incomingMessagesDispatcher.setNonBlockingQueue(objectFIFO);
            this.currentResultDispatcher.start();
        }
    }

    public void setDisconnectListener(DisconnectListener disconnectListener) {
        this.disconnectListener = disconnectListener;
    }

    public int getInputQueueSize() {
        return this.inputQueue.getSize();
    }

    public int getInputQueueLength() {
        return this.inputQueue.getLength();
    }

    public int getOutputQueueSize() {
        return this.outputQueue.getCapacity();
    }

    int getOutputQueueLength() {
        return this.outputQueue.getSize();
    }

    public int getNotificationQueueSize() {
        return this.notificationQueue.getCapacity();
    }

    public int getNotificationQueueLength() {
        return this.notificationQueue.getSize();
    }

    public long getNotificationCount() {
        return -1L;
    }

    public void resetNotificationCount() {
    }

    public long getIgnoredNotificationCount() {
        return -1L;
    }

    public void resetIgnoredNotificationCount() {
    }

    int getNumberOfListeners(String string) {
        return this.clientNotificationDispatcher.getNumberOfListeners(string);
    }

    String[] getCombinedNotificationTypes(String string) {
        return this.clientNotificationDispatcher.getCombinedNotificationTypes(string);
    }

    synchronized boolean getAllNotifications(String string) {
        return this.clientNotificationDispatcher.getAllNotifications(string);
    }

    public long getIncomingMessageCount() {
        return this.incomingMessagesDispatcher != null ? this.incomingMessagesDispatcher.getMessageCounter() : -1L;
    }

    public void resetIncomingMessageCount() {
        if (this.incomingMessagesDispatcher != null) {
            this.incomingMessagesDispatcher.resetMessageCounter();
        }
    }

    public String getName() {
        return this.name;
    }

    public String getSessionEncoding() {
        return this.sessionEncoding;
    }

    public InetAddress getPeerAddress() {
        if (this.peerAddress == null) {
            this.peerAddress = this.socket.getInetAddress();
        }
        return this.peerAddress;
    }

    public InetAddress getLocalAddress() {
        return this.socket.getLocalAddress();
    }

    private void initASNEncoderDecoder() {
        if (this.sessionEncoding.equals(BER_ENCODING)) {
            this.encoder = new BEREncoder();
            this.decoder = new BERDecoder(this.inputQueue);
        } else {
            this.encoder = new XEREncoder();
            this.decoder = new XERDecoderClient(this.inputQueue);
        }
    }

    public static void setDebugMode(boolean bl) {
        if (bl) {
            Category.getInstance((String)"com.pcube.management.framework.rpc").setPriority(Priority.toPriority((String)"DEBUG"));
        } else {
            Category.getInstance((String)"com.pcube.management.framework.rpc").setPriority(null);
        }
    }

    private void handleGreetingReply(GreetingReply greetingReply) throws IOException, ConnectionEstablishmentFailedException, Asn1Exception, SAXException, AuthenticationFailedException {
        if (logcat.isDebugEnabled()) {
            logcat.debug((Object)("Client::establishConnection received greeting reply from server:\n" + AsnClassesEncoderDecoder.toString((Asn1TypeIF)greetingReply, "GreetingReply") + "time=" + new Date()));
        }
        boolean bl = greetingReply.connectionSucessful.value;
        if (greetingReply.authLevel != null) {
            this.authLevel = (int)greetingReply.authLevel.value;
            this.isAuthenticated = true;
            if (this.requestedAuthLevel > (long)this.authLevel) {
                logcat.warn((Object)("Client::establishConnection - auth level received from server " + this.authLevel + "is lower than requested " + this.requestedAuthLevel));
            }
        }
        if (!bl) {
            String string = greetingReply.message.value;
            if (string.startsWith("Failed to authenticate client ")) {
                throw new AuthenticationFailedException(string);
            }
            throw new ConnectionEstablishmentFailedException("server refused connection: " + string);
        }
        this.serverMessage = greetingReply.message.value;
        this.serverVersion = greetingReply.serverVersion.value;
    }

    private byte[] calculateEncriptionKey() {
        byte[] byArray = this.socket.getLocalAddress().getAddress();
        byte[] byArray2 = this.socket.getInetAddress().getAddress();
        logcat.debug((Object)("server address " + this.socket.getInetAddress().getHostAddress() + " client address " + this.socket.getLocalAddress().getHostAddress()));
        if (this.serverVersion == null || this.serverVersion.equals("2.0")) {
            return RpcCommon.calculateAuthSecret(this.serverChallenge, byArray, byArray2);
        }
        return RpcCommon.calculateAuthSecret(this.serverChallenge, byArray2);
    }

    protected byte[] getEncryptionKey() {
        return this.encryptionKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleChallenge() throws IOException, ConnectionEstablishmentFailedException, Asn1Exception, SAXException, AuthenticationFailedException {
        if (logcat.isDebugEnabled()) {
            logcat.debug((Object)("Client::establishConnection received challenge from server: time=" + new Date()));
        }
        this.encryptionKey = this.calculateEncriptionKey();
        byte[] byArray = SecurityUtils.encrypt(this.username.getBytes(), this.encryptionKey);
        byte[] byArray2 = SecurityUtils.encrypt(this.password.getBytes(), this.encryptionKey);
        if (byArray == null || byArray2 == null) {
            throw new ConnectionEstablishmentFailedException("Failed to encrypt username/password");
        }
        Timer timer = new Timer();
        try {
            TimerTask timerTask = new TimerTask(){
                Thread currentThread = Thread.currentThread();

                public void run() {
                    Thread.currentThread().setName(Client.this.getName() + "-challenge-timer");
                    this.currentThread.interrupt();
                    Client.this.destroySocket();
                }
            };
            ClientMessage clientMessage = new ClientMessage();
            ChallengeReply challengeReply = new ChallengeReply(byArray, byArray2, this.requestedAuthLevel);
            clientMessage.set_challengeReply(challengeReply);
            this.encoder.encode((Asn1Type)clientMessage, this.socketOutputStream);
            this.socketOutputStream.flush();
            timer.schedule(timerTask, this.challengeTimeout);
            logcat.debug((Object)"Client::establishConnection:: challenge reply sent");
            ServerMessage serverMessage = new ServerMessage();
            this.decoder.decode((Asn1Type)serverMessage);
            int n = serverMessage.getChoiceID();
            if (n != 1) {
                throw new ConnectionEstablishmentFailedException("message received from server isn't greeting greply[" + serverMessage.getChoiceID() + ']');
            }
            if (!timerTask.cancel()) {
                throw new ConnectionEstablishmentFailedException("Challenge reply timeout");
            }
            GreetingReply greetingReply = (GreetingReply)serverMessage.getElement();
            this.handleGreetingReply(greetingReply);
        }
        finally {
            timer.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void establishConnection() throws IOException, ConnectionEstablishmentFailedException, Asn1Exception, SAXException, AuthenticationFailedException {
        logcat.debug((Object)"Client::establishConnection:: start");
        ClientMessage clientMessage = new ClientMessage();
        int n = this.connectionMode == 2 ? 0 : 1;
        boolean bl = this.username != null && this.username.length() > 0 && this.password != null && this.password.length() > 0;
        Greeting greeting = new Greeting(this.name, this.version, n, 10L, true, true, true, bl);
        logcat.debug((Object)("Client::establishConnection:: support auth " + bl));
        clientMessage.set_greeting(greeting);
        this.encoder.encode((Asn1Type)clientMessage, this.socketOutputStream);
        this.socketOutputStream.flush();
        logcat.debug((Object)"Client::establishConnection:: greeting sent");
        Timer timer = new Timer();
        try {
            TimerTask timerTask = new TimerTask(){
                Thread currentThread = Thread.currentThread();

                public void run() {
                    Thread.currentThread().setName(Client.this.getName() + "-greeting-timer");
                    this.currentThread.interrupt();
                    Client.this.destroySocket();
                }
            };
            timer.schedule(timerTask, this.greetingTimeout);
            ServerMessage serverMessage = new ServerMessage();
            this.decoder.decode((Asn1Type)serverMessage);
            int n2 = serverMessage.getChoiceID();
            if (n2 != 1 && n2 != 6) {
                throw new ConnectionEstablishmentFailedException("message received from server isn't greeting greply or challenge[" + serverMessage.getChoiceID() + ']');
            }
            if (!timerTask.cancel()) {
                throw new ConnectionEstablishmentFailedException("greeting reply timeout");
            }
            if (serverMessage.getChoiceID() == 6) {
                logcat.debug((Object)"Client::establishConnection Challenge received");
                Challenge challenge = (Challenge)serverMessage.getElement();
                this.serverChallenge = challenge.challenge.value;
                if (challenge.versionString != null) {
                    this.serverVersion = challenge.versionString.value;
                }
                this.handleChallenge();
            } else {
                GreetingReply greetingReply = (GreetingReply)serverMessage.getElement();
                logcat.debug((Object)"Client::establishConnection Greeting reply received");
                this.handleGreetingReply(greetingReply);
                this.encryptionKey = this.calculateEncriptionKey();
            }
        }
        finally {
            timer.cancel();
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    private final boolean isActive() {
        return !this.closed && !this.closing && !this.connecting;
    }

    public void close() {
        this.close("session closed", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(String string, boolean bl) {
        logcat.debug((Object)("Client:: close session " + this.name + " START"));
        if (this.statsVarOutputQueue != null) {
            this.statsVarOutputQueue.close();
        }
        if (this.statsVarNotificationQueue != null) {
            this.statsVarNotificationQueue.close();
        }
        if (this.nonBlockingOperationCounter != null) {
            this.nonBlockingOperationCounter.close();
        }
        if (this.proprietaryInvocationsCounter != null) {
            this.proprietaryInvocationsCounter.close();
        }
        Client client = this;
        synchronized (client) {
            if (this.closed) {
                logcat.debug((Object)"close called when already closed");
                return;
            }
            if (this.closing) {
                logcat.debug((Object)"close called when closing");
                return;
            }
            while (this.connecting) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.closing = true;
            this.notifyAll();
        }
        try {
            logcat.debug((Object)("Client:: close session " + this.name + " BEFORE NOTIFICATION DISPATCHER STOP"));
            if (this.clientNotificationDispatcher != null) {
                this.clientNotificationDispatcher.requestStop();
            }
            logcat.debug((Object)("Client::close session " + this.name + " BEFORE SEND FAREWELL"));
            try {
                if (bl && this.socketOutputStream != null && this.encoder != null) {
                    this.socketOutputStream.flush();
                    this.sendFarewell(string);
                    this.socketOutputStream.flush();
                }
            }
            catch (Exception exception) {
                logcat.debug((Object)"Client::could not send farewell", (Throwable)exception);
            }
            logcat.debug((Object)("Client:: close session " + this.name + " BEFORE MESSAGE DISPATCHER STOP"));
            if (this.incomingMessagesDispatcher != null) {
                this.incomingMessagesDispatcher.requestStop();
            }
            this.destroySocket();
            logcat.debug((Object)("Client::close session " + this.name + " BEFORE RESULT DISPATCHER STOP"));
            if (this.currentResultDispatcher != null) {
                this.currentResultDispatcher.requestStop();
            }
            logcat.debug((Object)("Client::close session " + this.name + " BEFORE INPUT WORKER STOP"));
            if (this.inputWorker != null) {
                this.inputWorker.requestStop();
            }
            logcat.debug((Object)("Client::close session " + this.name + " BEFORE OUTPUT WORKER STOP"));
            if (this.outputWorker != null) {
                this.outputWorker.requestStop();
            }
            logcat.debug((Object)("Client::session " + this.name + " closed"));
            client = this;
            synchronized (client) {
                this.closed = true;
                this.notifyAll();
            }
        }
        finally {
            this.closing = false;
        }
        if (this.disconnectListener != null) {
            try {
                this.disconnectListener.connectionIsDown();
            }
            catch (Throwable throwable) {
                logcat.error((Object)"Client::close while calling connection-is-down on listener", throwable);
            }
        }
    }

    private final void destroySocket() {
        logcat.debug((Object)("Client::destroySocket session " + this.name + " BEFORE SOCKET OUTPUT"));
        try {
            if (this.socket != null) {
                this.socket.shutdownOutput();
            }
            if (this.socketOutputStream != null) {
                this.socketOutputStream.close();
            }
        }
        catch (IOException iOException) {
            logcat.debug((Object)"Client::destroySocket not close socket output stream", (Throwable)iOException);
        }
        logcat.debug((Object)("Client::destroySocket session " + this.name + " BEFORE SOCKET CLOSE"));
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            logcat.debug((Object)"Client::destroySocket not close socket", (Throwable)iOException);
        }
        logcat.debug((Object)("Client::destroySocket session " + this.name + " BEFORE SOCKET INPUT"));
        try {
            if (this.socket != null) {
                this.socket.shutdownInput();
            }
            if (this.socketInputStream != null) {
                this.socketInputStream.close();
            }
        }
        catch (IOException iOException) {
            logcat.debug((Object)"Client::destroySocket not close socket input stream", (Throwable)iOException);
        }
    }

    void sendFarewell(String string) throws IOException, Asn1Exception {
        ClientMessage clientMessage = new ClientMessage();
        Farewell farewell = new Farewell(System.currentTimeMillis(), string);
        clientMessage.set_farewell(farewell);
        this.encoder.encode((Asn1Type)clientMessage, this.socketOutputStream);
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public Asn1Type createKeepAlive(KeepAlive keepAlive) {
        ClientMessage clientMessage = new ClientMessage();
        clientMessage.set_keepAlive(keepAlive);
        return clientMessage;
    }

    final synchronized long nextNonBlockingOperationCounter() {
        this.nonBlockingOperationCounter.increaseCount();
        return this.nonBlockingOperationCounter.getCounter() - 1L;
    }

    final synchronized long nextBlockingThreadID() {
        if (++this.blockingThreadID == NON_BLOCKING_THREAD_ID) {
            ++this.blockingThreadID;
        }
        return this.blockingThreadID;
    }

    public long getProprietaryInvocationCounter() {
        return this.proprietaryInvocationsCounter.getCounter();
    }

    public Date getClientCreationDate() {
        return this.clientCreationDate;
    }

    public long getReceivedMessagesCounter() {
        return this.incomingMessagesDispatcher.getMessageCounter();
    }

    public long getSentMessagesCounter() {
        return this.outputWorker.getSentMessagesCounter();
    }

    public long getReceivedNotificationsCounter() {
        return this.clientNotificationDispatcher.getNotificationsCount();
    }

    public long getIgnoredNotificationsCounter() {
        return this.clientNotificationDispatcher.getIgnoredNotificationsCount();
    }

    public long getDroppedNotificationsCounter() {
        return this.incomingMessagesDispatcher.getDroppedNotificationsCounter();
    }

    public long getReceviedKeepAliveCounter() {
        return this.incomingMessagesDispatcher.getKeepAliveCounter();
    }

    public long getUnknownMessagesCounter() {
        return this.incomingMessagesDispatcher.getUnknownMessageCounter();
    }

    public int getAuthLevel() {
        return this.authLevel;
    }

    public boolean isAuthenticated() {
        return this.isAuthenticated;
    }

    public double getOutputQueueUtilization() {
        if (this.ncrMap == null) {
            return this.outputQueue.getUtilization();
        }
        return Math.max(this.outputQueue.getUtilization(), this.ncrMap.getUtilization());
    }

    String getClientInfoString(String string) {
        String[][] stringArray = this.getClientInfo();
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray2 = stringArray[0];
        String[] stringArray3 = stringArray[1];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringBuffer.append(stringArray2[i] + '=' + stringArray3[i] + string);
        }
        return stringBuffer.toString();
    }

    String[][] getClientInfo() {
        String[] stringArray = new String[]{this.getName() + "", this.isActive() + "", this.isClosed() + "", this.getServerVersion() + "", this.getPeerAddress() + "", this.getSessionEncoding() + "", this.getClientCreationDate() + "", this.getInputQueueSize() + "", this.getInputQueueLength() + "", this.getReceivedMessagesCounter() + "", this.getOutputQueueSize() + "", this.getOutputQueueLength() + "", this.getSentMessagesCounter() + "", this.getReceivedNotificationsCounter() + "", this.getDroppedNotificationsCounter() + "", this.getIgnoredNotificationsCounter() + "", this.getReceviedKeepAliveCounter() + "", this.getUnknownMessagesCounter() + ""};
        return new String[][]{CLIENT_STAT_NAMES, stringArray};
    }

    static {
        System.setProperty("jmx.serial.form", "1.0");
        logcat = Category.getInstance(Client.class);
        CLIENT_STAT_NAMES = new String[]{"name", "active", "closed", "server-version", "server-address", "encoding", "started", "input-queue-size", "input-queue-length", "received-message-num", "output-queue-size", "output-queue-length", "sent-message-num", "received-notifications-num", "dropped-notifications-num", "ignored-notifications-num", "keep-alive-received-num", "unknown-messages-received-num"};
        defaultInputQueueSize = 0x200000;
        defaultOutputQueueSize = 8192;
        NON_BLOCKING_THREAD_ID = 0L;
        BLOCKING_OPERATION_COUNTER = 0L;
        threadGroup = new ThreadGroup("PRPC.Client");
    }
}

