/*
 * Decompiled with CFR 0.152.
 */
package com.pcube.management.framework.rpc;

import com.pcube.management.common.ArrayUtilities;
import com.pcube.management.common.threads.ObjectFIFO;
import com.pcube.management.framework.rpc.AsnClassesEncoderDecoder;
import com.pcube.management.framework.rpc.ClientObjectNotificationBroadcaster;
import com.pcube.management.framework.rpc.protocol.ClientMessage;
import com.pcube.management.framework.rpc.protocol.ServerMessage;
import java.util.HashMap;
import java.util.Iterator;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import org.apache.log4j.Category;

class ClientNotificationDispatcher
extends Thread {
    private static Category logcat = Category.getInstance(ClientNotificationDispatcher.class);
    private ObjectFIFO notificationQueue;
    private long ignoredNotificationsCount;
    private long notificationsCount;
    private boolean done;
    private HashMap objectNotificationBroadcasters;
    private int count = 0;

    ClientNotificationDispatcher(String string, ThreadGroup threadGroup, int n, ObjectFIFO objectFIFO, ClientNotificationDispatcher clientNotificationDispatcher) {
        super(threadGroup, string);
        this.setPriority(n);
        this.notificationQueue = objectFIFO;
        this.objectNotificationBroadcasters = clientNotificationDispatcher == null || clientNotificationDispatcher.objectNotificationBroadcasters == null ? new HashMap() : clientNotificationDispatcher.objectNotificationBroadcasters;
    }

    void assignBroadcasters(ClientNotificationDispatcher clientNotificationDispatcher) {
        clientNotificationDispatcher.objectNotificationBroadcasters = this.objectNotificationBroadcasters;
    }

    synchronized ClientMessage addNotificationListener(String string, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object, long l, long l2) {
        String[] stringArray;
        ClientObjectNotificationBroadcaster clientObjectNotificationBroadcaster = (ClientObjectNotificationBroadcaster)this.objectNotificationBroadcasters.get(string);
        if (clientObjectNotificationBroadcaster == null) {
            clientObjectNotificationBroadcaster = new ClientObjectNotificationBroadcaster();
            this.objectNotificationBroadcasters.put(string, clientObjectNotificationBroadcaster);
        }
        boolean bl = clientObjectNotificationBroadcaster.getNumberOfListeners() == 0;
        boolean bl2 = clientObjectNotificationBroadcaster.getAllNotifications();
        String[] stringArray2 = bl2 || bl ? null : clientObjectNotificationBroadcaster.getCombinedNotificationTypes();
        boolean bl3 = true;
        clientObjectNotificationBroadcaster.addNotificationListener(notificationListener, notificationFilter, object);
        boolean bl4 = clientObjectNotificationBroadcaster.getAllNotifications();
        String[] stringArray3 = stringArray = bl4 ? null : clientObjectNotificationBroadcaster.getCombinedNotificationTypes();
        if (bl2 == bl4 && ArrayUtilities.compare(stringArray, stringArray2)) {
            bl3 = false;
        }
        if (bl3) {
            return AsnClassesEncoderDecoder.encodeGetNotifications(l, l2, string, stringArray);
        }
        return null;
    }

    synchronized ClientMessage removeNotificationListener(String string, NotificationListener notificationListener, long l, long l2) {
        String[] stringArray;
        boolean bl;
        String[] stringArray2;
        ClientObjectNotificationBroadcaster clientObjectNotificationBroadcaster = this.getBroadcaster(string);
        boolean bl2 = clientObjectNotificationBroadcaster.getAllNotifications();
        String[] stringArray3 = stringArray2 = bl2 ? null : clientObjectNotificationBroadcaster.getCombinedNotificationTypes();
        if (!clientObjectNotificationBroadcaster.removeNotificationListener(notificationListener)) {
            logcat.debug((Object)"remove called when nothing to do");
            return null;
        }
        boolean bl3 = true;
        boolean bl4 = bl = clientObjectNotificationBroadcaster.getNumberOfListeners() == 0;
        if (bl) {
            this.objectNotificationBroadcasters.remove(string);
            return AsnClassesEncoderDecoder.encodeDontGetNotifications(l, l2, string);
        }
        boolean bl5 = clientObjectNotificationBroadcaster.getAllNotifications();
        String[] stringArray4 = stringArray = bl5 ? null : clientObjectNotificationBroadcaster.getCombinedNotificationTypes();
        if (bl2 == bl5 && ArrayUtilities.compare(stringArray, stringArray2)) {
            bl3 = false;
        }
        if (bl3) {
            return AsnClassesEncoderDecoder.encodeGetNotifications(l, l2, string, stringArray);
        }
        return null;
    }

    private final ClientObjectNotificationBroadcaster getBroadcaster(String string) {
        ClientObjectNotificationBroadcaster clientObjectNotificationBroadcaster = (ClientObjectNotificationBroadcaster)this.objectNotificationBroadcasters.get(string);
        if (clientObjectNotificationBroadcaster == null) {
            throw new IllegalArgumentException("no one listens to " + string);
        }
        return clientObjectNotificationBroadcaster;
    }

    int getNumberOfListeners(String string) {
        ClientObjectNotificationBroadcaster clientObjectNotificationBroadcaster = this.getBroadcaster(string);
        return clientObjectNotificationBroadcaster.getNumberOfListeners();
    }

    String[] getCombinedNotificationTypes(String string) {
        ClientObjectNotificationBroadcaster clientObjectNotificationBroadcaster = this.getBroadcaster(string);
        return clientObjectNotificationBroadcaster.getCombinedNotificationTypes();
    }

    boolean getAllNotifications(String string) {
        ClientObjectNotificationBroadcaster clientObjectNotificationBroadcaster = this.getBroadcaster(string);
        return clientObjectNotificationBroadcaster.getAllNotifications();
    }

    Iterator getObjectNamesIterator() {
        Iterator iterator = this.objectNotificationBroadcasters.keySet().iterator();
        return iterator;
    }

    synchronized void resetNotificationListeners() {
        this.objectNotificationBroadcasters = new HashMap();
    }

    int getNumberOfObjects() {
        return this.objectNotificationBroadcasters.size();
    }

    ClientMessage regenerateNotificationListenerMessage(String string, long l, long l2) {
        ClientObjectNotificationBroadcaster clientObjectNotificationBroadcaster = this.getBroadcaster(string);
        boolean bl = clientObjectNotificationBroadcaster.getAllNotifications();
        String[] stringArray = bl ? null : clientObjectNotificationBroadcaster.getCombinedNotificationTypes();
        return AsnClassesEncoderDecoder.encodeGetNotifications(l, l2, string, stringArray);
    }

    public void run() {
        while (!this.done) {
            try {
                ServerMessage serverMessage = (ServerMessage)((Object)this.notificationQueue.remove());
                ++this.notificationsCount;
                Notification notification = AsnClassesEncoderDecoder.createNotification(serverMessage);
                ClientObjectNotificationBroadcaster clientObjectNotificationBroadcaster = (ClientObjectNotificationBroadcaster)this.objectNotificationBroadcasters.get(notification.getSource());
                if (clientObjectNotificationBroadcaster == null) {
                    ++this.ignoredNotificationsCount;
                    logcat.debug((Object)("ignored notification from " + notification.getSource()));
                    continue;
                }
                clientObjectNotificationBroadcaster.sendNotification(notification);
            }
            catch (InterruptedException interruptedException) {
                if (this.done) continue;
                logcat.warn((Object)"could not remove notification from queue ", (Throwable)interruptedException);
            }
            catch (Throwable throwable) {
                logcat.error((Object)"error while broadcasting notification ", throwable);
            }
        }
    }

    long getIgnoredNotificationsCount() {
        return this.ignoredNotificationsCount;
    }

    void resetIgnoredNotificationsCount() {
        this.ignoredNotificationsCount = 0L;
    }

    long getNotificationsCount() {
        return this.notificationsCount;
    }

    void resetNotificationsCount() {
        this.notificationsCount = 0L;
    }

    public void start() {
        this.done = false;
        super.start();
    }

    void requestStop() {
        this.done = true;
        this.interrupt();
        try {
            this.join(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

