/*
 * Decompiled with CFR 0.152.
 */
package com.pcube.management.framework.rpc;

import com.pcube.management.framework.rpc.ListenerStruct;
import com.pcube.management.framework.rpc.RpcNotificationFilter;
import com.pcube.management.framework.rpc.RpcNotificationListener;
import com.pcube.management.framework.rpc.ServerSessionNotificationListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import org.apache.log4j.Category;

class ClientObjectNotificationBroadcaster {
    private static Category logcat = Category.getInstance(ServerSessionNotificationListener.class);
    private ArrayList listeners = new ArrayList();

    ClientObjectNotificationBroadcaster() {
    }

    void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
        if (notificationListener == null) {
            throw new IllegalArgumentException("null listener");
        }
        if (notificationListener instanceof RpcNotificationListener) {
            if (notificationFilter != null) {
                throw new IllegalArgumentException("filter should be null when passing RpcNotificationListener");
            }
            notificationFilter = new RpcNotificationFilter((RpcNotificationListener)notificationListener);
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            ListenerStruct listenerStruct = (ListenerStruct)this.listeners.get(i);
            if (!listenerStruct.listener.equals(notificationListener)) continue;
            listenerStruct.filter = notificationFilter;
            return;
        }
        this.listeners.add(new ListenerStruct(notificationListener, notificationFilter, object));
    }

    boolean removeNotificationListener(NotificationListener notificationListener) {
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            NotificationListener notificationListener2 = ((ListenerStruct)this.listeners.get((int)i)).listener;
            if (!notificationListener2.equals(notificationListener)) continue;
            this.listeners.remove(i);
            return true;
        }
        return false;
    }

    void sendNotification(Notification notification) {
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            ListenerStruct listenerStruct = (ListenerStruct)this.listeners.get(i);
            if (listenerStruct.filter != null && !listenerStruct.filter.isNotificationEnabled(notification)) continue;
            try {
                listenerStruct.listener.handleNotification(notification, listenerStruct.handback);
                continue;
            }
            catch (Throwable throwable) {
                logcat.error((Object)"listener threw an exception while handling notification", throwable);
            }
        }
    }

    String[] getCombinedNotificationTypes() {
        HashSet<String> hashSet = new HashSet<String>(163);
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            NotificationListener notificationListener = ((ListenerStruct)this.listeners.get((int)i)).listener;
            if (notificationListener instanceof RpcNotificationListener) {
                if (!((RpcNotificationListener)notificationListener).getAllNotifications()) {
                    String[] stringArray = ((RpcNotificationListener)notificationListener).getNotificationTypes();
                    for (int j = 0; j < stringArray.length; ++j) {
                        hashSet.add(stringArray[j]);
                    }
                    continue;
                }
                return null;
            }
            return null;
        }
        Object[] objectArray = new String[hashSet.size()];
        hashSet.toArray(objectArray);
        Arrays.sort(objectArray);
        return objectArray;
    }

    boolean getAllNotifications() {
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            NotificationListener notificationListener = ((ListenerStruct)this.listeners.get((int)i)).listener;
            if (notificationListener instanceof RpcNotificationListener) {
                if (!((RpcNotificationListener)notificationListener).getAllNotifications()) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    int getNumberOfListeners() {
        return this.listeners.size();
    }

    void clear() {
        this.listeners = new ArrayList();
    }
}

