/*
 * Decompiled with CFR 0.152.
 */
package com.pcube.management.framework.rpc;

import com.objsys.asn1j.runtime.Asn1Type;
import com.objsys.asn1j.runtime.Asn1TypeIF;
import com.pcube.management.common.threads.HandoffBox;
import com.pcube.management.common.threads.ObjectFIFO;
import com.pcube.management.framework.rpc.AsnClassesEncoderDecoder;
import com.pcube.management.framework.rpc.Client;
import com.pcube.management.framework.rpc.ResponseListener;
import com.pcube.management.framework.rpc.SessionCloseListener;
import com.pcube.management.framework.rpc.WireToAsnDecoder;
import com.pcube.management.framework.rpc.protocol.Farewell;
import com.pcube.management.framework.rpc.protocol.OperationResult;
import com.pcube.management.framework.rpc.protocol.ServerMessage;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Category;

class IncomingMessagesDispatcher
extends Thread {
    private static Category logcat = Category.getInstance(IncomingMessagesDispatcher.class);
    private WireToAsnDecoder decoder;
    private Map handoffBoxesMap;
    private ObjectFIFO nonBlockingQueue;
    private ObjectFIFO notificationQueue;
    ResponseListener responseListener = null;
    private SessionCloseListener sessionCloseListener;
    private long messageCount;
    private long droppedNotificationsCounter;
    private long keepAliveCounter;
    private long unknownMessageCounter;
    private boolean done;
    private boolean dropNotificationsIfFull;

    IncomingMessagesDispatcher(WireToAsnDecoder wireToAsnDecoder, String string, int n, ThreadGroup threadGroup, SessionCloseListener sessionCloseListener, ObjectFIFO objectFIFO, boolean bl, ResponseListener responseListener) {
        super(threadGroup, string);
        this.decoder = wireToAsnDecoder;
        this.setPriority(n);
        this.sessionCloseListener = sessionCloseListener;
        this.handoffBoxesMap = Collections.synchronizedMap(new HashMap());
        this.notificationQueue = objectFIFO;
        this.dropNotificationsIfFull = bl;
        this.responseListener = responseListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHandoffBox(long l, HandoffBox handoffBox) {
        Map map = this.handoffBoxesMap;
        synchronized (map) {
            if (this.done) {
                throw new IllegalStateException("connection is down");
            }
            this.handoffBoxesMap.put(new Long(l), handoffBox);
        }
    }

    public void setNonBlockingQueue(ObjectFIFO objectFIFO) {
        this.nonBlockingQueue = objectFIFO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block15: while (!this.done) {
            ServerMessage serverMessage = new ServerMessage();
            try {
                this.decoder.decode((Asn1Type)serverMessage);
                ++this.messageCount;
                if (logcat.isDebugEnabled()) {
                    logcat.debug((Object)("received message from peer:\n" + AsnClassesEncoderDecoder.toString((Asn1TypeIF)serverMessage, "ServerMessage") + "time=" + new Date()));
                }
            }
            catch (Throwable throwable) {
                if (!this.done) {
                    logcat.warn((Object)"could not decode server message", throwable);
                    this.sessionCloseListener.close("could not decode server message " + throwable.getMessage(), false);
                    return;
                }
            }
            finally {
                if (this.done) {
                    return;
                }
            }
            switch (serverMessage.getChoiceID()) {
                case 3: {
                    long l = ((OperationResult)serverMessage.getElement()).threadNumber.value;
                    if (l == Client.NON_BLOCKING_THREAD_ID) {
                        if (this.responseListener != null) {
                            this.responseListener.commitRequest(((OperationResult)serverMessage.getElement()).operationCounter.value);
                        }
                        if (this.nonBlockingQueue == null) continue block15;
                        try {
                            this.nonBlockingQueue.add((Object)serverMessage);
                        }
                        catch (InterruptedException interruptedException) {
                            logcat.error((Object)"could not add message to queue");
                        }
                        break;
                    }
                    HandoffBox handoffBox = (HandoffBox)this.handoffBoxesMap.remove(new Long(l));
                    if (handoffBox != null) {
                        handoffBox.putResult((Object)serverMessage);
                        break;
                    }
                    logcat.error((Object)("could not find handoff box for thread id " + l));
                    break;
                }
                case 2: {
                    if (logcat.isDebugEnabled()) {
                        logcat.debug((Object)("farewell:\n" + AsnClassesEncoderDecoder.toString((Asn1TypeIF)serverMessage, "ServerMessage")));
                    }
                    if (!this.done) {
                        this.sessionCloseListener.close("server terminated connection: " + ((Farewell)serverMessage.getElement()).reason.value, false);
                    }
                    return;
                }
                case 5: {
                    ++this.keepAliveCounter;
                    if (!logcat.isDebugEnabled()) continue block15;
                    logcat.debug((Object)("keep-alive:\n" + AsnClassesEncoderDecoder.toString((Asn1TypeIF)serverMessage, "ServerMessage")));
                    break;
                }
                case 4: {
                    try {
                        if (this.dropNotificationsIfFull && this.notificationQueue.isFull()) {
                            ++this.droppedNotificationsCounter;
                            logcat.debug((Object)"dropping notification");
                            break;
                        }
                        this.notificationQueue.add((Object)serverMessage);
                    }
                    catch (InterruptedException interruptedException) {
                        logcat.error((Object)"could not add notification to queue");
                    }
                    break;
                }
                default: {
                    ++this.unknownMessageCounter;
                    logcat.debug((Object)("unexpected message id " + serverMessage.getChoiceID()));
                }
            }
        }
    }

    public void start() {
        this.done = false;
        super.start();
    }

    void requestStop() {
        this.done = true;
        this.interrupt();
        try {
            this.join(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            this.interruptAllHandoffBoxes();
        }
        catch (Throwable throwable) {
            logcat.error((Object)"while interrupting handoff boxes", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interruptAllHandoffBoxes() {
        Map map = this.handoffBoxesMap;
        synchronized (map) {
            for (HandoffBox handoffBox : this.handoffBoxesMap.values()) {
                handoffBox.interruptWaitingThread();
            }
        }
    }

    void resetMessageCounter() {
        this.messageCount = 0L;
    }

    long getMessageCounter() {
        return this.messageCount;
    }

    void resetDroppedNotificationsCounter() {
        this.droppedNotificationsCounter = 0L;
    }

    long getDroppedNotificationsCounter() {
        return this.droppedNotificationsCounter;
    }

    void resetKeepAliveCounter() {
        this.keepAliveCounter = 0L;
    }

    long getKeepAliveCounter() {
        return this.keepAliveCounter;
    }

    void resetUnknownMessageCounter() {
        this.unknownMessageCounter = 0L;
    }

    long getUnknownMessageCounter() {
        return this.unknownMessageCounter;
    }
}

