/*
 * Decompiled with CFR 0.152.
 */
package com.pcube.management.framework.rpc;

import com.pcube.management.common.BufferedInputStream;
import com.pcube.management.common.time.Timestamp;
import com.pcube.management.framework.rpc.SessionCloseListener;
import org.apache.log4j.Category;

class InputQueueWorker
extends Thread {
    private static Category logcat = Category.getInstance(InputQueueWorker.class);
    private long CLOCK_CHANGE_MARGIN;
    private BufferedInputStream inputQueue;
    private boolean done;
    private long keepAliveTimeout;
    private long sessionDeathTimeout;
    private long sleepAmount;
    private SessionCloseListener sessionCloseListener;
    private boolean closeIfNoKeepAlive;

    public String toString() {
        return super.toString();
    }

    InputQueueWorker(BufferedInputStream bufferedInputStream, String string, int n, ThreadGroup threadGroup, SessionCloseListener sessionCloseListener, boolean bl, long l, long l2, long l3) {
        super(threadGroup, string);
        this.inputQueue = bufferedInputStream;
        this.setPriority(n);
        this.sessionCloseListener = sessionCloseListener;
        this.closeIfNoKeepAlive = bl;
        this.sleepAmount = l;
        this.keepAliveTimeout = l2 + 2000L;
        this.sessionDeathTimeout = l3;
        this.CLOCK_CHANGE_MARGIN = Math.max(l * 3L, 20000L);
    }

    public void run() {
        try {
            long l = 0L;
            long l2 = 0L;
            while (!this.done) {
                l2 = l;
                long l3 = this.inputQueue.fill();
                l = Timestamp.getCurrentTimeStampInMilli();
                if (this.closeIfNoKeepAlive && l - l3 > this.keepAliveTimeout) {
                    if (Math.abs(l2 - l) < this.CLOCK_CHANGE_MARGIN) {
                        logcat.debug((Object)("keep alive timeout violation detected current=" + l + ", last=" + l3));
                        if (l - l3 > this.keepAliveTimeout + this.sessionDeathTimeout) {
                            logcat.info((Object)"session death timeout violation");
                            this.sessionCloseListener.close("session death timer expired [did not receive keep alive]", false);
                        }
                    } else {
                        logcat.warn((Object)"Clock change event detected updating last-received to current time");
                        l3 = System.currentTimeMillis();
                    }
                }
                if (this.sleepAmount == 0L) {
                    InputQueueWorker.yield();
                    continue;
                }
                try {
                    Thread.sleep(this.sleepAmount);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (Throwable throwable) {
            logcat.debug((Object)"could not fill buffer, stopping.", throwable);
        }
    }

    public void start() {
        this.done = false;
        super.start();
    }

    void requestStop() {
        this.done = true;
        this.interrupt();
        try {
            this.join(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

