/*
 * Decompiled with CFR 0.152.
 */
package com.pcube.management.framework.rpc;

import com.pcube.management.common.threads.ObjectFIFO;
import com.pcube.management.framework.rpc.ResponseListener;
import com.pcube.management.framework.rpc.protocol.ClientMessage;
import com.pcube.management.framework.rpc.protocol.Operation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import org.apache.log4j.Category;

public class NonCommittedRequestsMap
implements ResponseListener {
    private static Category logcat = Category.getInstance(NonCommittedRequestsMap.class);
    private HashMap nonCommittedRequests;
    private int capacity;

    public NonCommittedRequestsMap(int n) {
        this.setCapacity(n);
        this.nonCommittedRequests = new HashMap(this.capacity);
    }

    public void setCapacity(int n) {
        logcat.debug((Object)("NCR capacity was set to: " + n));
        this.capacity = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean commitRequest(long l) {
        boolean bl = false;
        Object object = this.nonCommittedRequests;
        synchronized (object) {
            bl = this.nonCommittedRequests.remove(new Long(l)) != null;
        }
        logcat.debug((Object)("Commit request " + l));
        if (!bl) {
            logcat.warn((Object)("commitRequest was called with non-existing operation ID: " + l));
        } else {
            object = this;
            synchronized (object) {
                this.notifyAll();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAllNonCommittedRequests(ObjectFIFO objectFIFO) {
        try {
            objectFIFO.removeAll();
        }
        catch (InterruptedException interruptedException) {
            logcat.error((Object)interruptedException, (Throwable)interruptedException);
        }
        ArrayList arrayList = null;
        HashMap hashMap = this.nonCommittedRequests;
        synchronized (hashMap) {
            arrayList = new ArrayList(this.nonCommittedRequests.values());
            Collections.sort(arrayList, new ClientMessageComparator());
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            try {
                objectFIFO.add(arrayList.get(i));
                continue;
            }
            catch (InterruptedException interruptedException) {
                logcat.error((Object)interruptedException, (Throwable)interruptedException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addRequest(ClientMessage clientMessage, long l) throws InterruptedException {
        if (this.isFull() && !this.waitWhileFull(l)) {
            return false;
        }
        long l2 = this.extractOperationId(clientMessage);
        HashMap hashMap = this.nonCommittedRequests;
        synchronized (hashMap) {
            if (this.nonCommittedRequests.put(new Long(l2), clientMessage) != null) {
                logcat.warn((Object)("addRequest was called with an existing operation ID: " + l2));
            }
        }
        logcat.debug((Object)("Successfully added request " + l2));
        return true;
    }

    private long extractOperationId(ClientMessage clientMessage) {
        return ((Operation)clientMessage.getElement()).operationCounter.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeRequest(ClientMessage clientMessage) {
        long l = this.extractOperationId(clientMessage);
        boolean bl = false;
        HashMap hashMap = this.nonCommittedRequests;
        synchronized (hashMap) {
            bl = this.nonCommittedRequests.remove(new Long(l)) != null;
        }
        return bl;
    }

    public synchronized boolean waitWhileFull(long l) throws InterruptedException {
        while (l > 0L && this.isFull()) {
            long l2 = System.currentTimeMillis();
            this.wait(l);
            l -= Math.max(0L, System.currentTimeMillis() - l2);
        }
        return !this.isFull();
    }

    public boolean isFull() {
        return this.nonCommittedRequests.size() >= this.capacity;
    }

    public double getUtilization() {
        return (double)this.nonCommittedRequests.size() / (double)this.capacity;
    }

    private class ClientMessageComparator
    implements Comparator {
        private ClientMessageComparator() {
        }

        public int compare(Object object, Object object2) {
            long l;
            long l2 = NonCommittedRequestsMap.this.extractOperationId((ClientMessage)((Object)object));
            if (l2 == (l = NonCommittedRequestsMap.this.extractOperationId((ClientMessage)((Object)object2)))) {
                return 0;
            }
            if (l2 < l) {
                return -1;
            }
            return 1;
        }
    }
}

