/*
 * Decompiled with CFR 0.152.
 */
package com.pcube.management.framework.rpc;

import com.objsys.asn1j.runtime.Asn1Type;
import com.objsys.asn1j.runtime.Asn1TypeIF;
import com.pcube.management.common.threads.ObjectFIFO;
import com.pcube.management.framework.agent.StatsVar;
import com.pcube.management.framework.rpc.AsnClassesEncoderDecoder;
import com.pcube.management.framework.rpc.AsnToWireEncoder;
import com.pcube.management.framework.rpc.KeepAliveProvider;
import com.pcube.management.framework.rpc.SessionCloseListener;
import com.pcube.management.framework.rpc.protocol.KeepAlive;
import java.io.OutputStream;
import java.net.SocketAddress;
import java.util.Date;
import org.apache.log4j.Category;

class OutputQueueWorker
extends Thread {
    private static Category logcat = Category.getInstance(OutputQueueWorker.class);
    private long CLOCK_CHANGE_MARGIN;
    private ObjectFIFO outputQueue;
    private OutputStream sockout;
    private AsnToWireEncoder encoder;
    private boolean done;
    private SessionCloseListener sessionCloseListener;
    private KeepAliveProvider keepAliveProvider;
    private long sleepAmount;
    private boolean sendKeepAlive;
    private long keepAlivePeriod;
    boolean userMode;
    boolean sessionDebug = false;
    private StatsVar sentMessagesCounter = null;

    OutputQueueWorker(ObjectFIFO objectFIFO, OutputStream outputStream, AsnToWireEncoder asnToWireEncoder, String string, int n, ThreadGroup threadGroup, SessionCloseListener sessionCloseListener, KeepAliveProvider keepAliveProvider, boolean bl, long l, long l2, boolean bl2, SocketAddress socketAddress, String string2) {
        super(threadGroup, string);
        this.outputQueue = objectFIFO;
        this.sockout = outputStream;
        this.encoder = asnToWireEncoder;
        this.setPriority(n);
        this.sessionCloseListener = sessionCloseListener;
        this.keepAliveProvider = keepAliveProvider;
        this.sendKeepAlive = bl;
        this.keepAlivePeriod = l / 2L;
        this.sleepAmount = l2;
        this.userMode = bl2;
        this.CLOCK_CHANGE_MARGIN = Math.max(l2 * 3L, 20000L);
        this.sentMessagesCounter = new StatsVar(string2 + ".RPC.OutputQueue.sentMessages");
    }

    public void run() {
        Asn1Type asn1Type = null;
        long l = System.currentTimeMillis();
        long l2 = System.currentTimeMillis();
        this.sentMessagesCounter.reset();
        while (!this.done) {
            if (!this.outputQueue.isEmpty()) {
                try {
                    asn1Type = (Asn1Type)this.outputQueue.remove();
                    if (logcat.isDebugEnabled()) {
                        logcat.debug((Object)("sending message to peer:\n" + AsnClassesEncoderDecoder.toString((Asn1TypeIF)asn1Type, "ServerMessage") + "time=" + new Date() + "\nmessage len=" + AsnClassesEncoderDecoder.getEncodedLength(asn1Type, this.encoder) + "\nThread name=" + Thread.currentThread().getName()));
                    } else if (this.sessionDebug) {
                        logcat.info((Object)("sending message to peer:\n" + AsnClassesEncoderDecoder.toString((Asn1TypeIF)asn1Type, "ServerMessage") + "time=" + new Date() + "\nmessage len=" + AsnClassesEncoderDecoder.getEncodedLength(asn1Type, this.encoder) + "\nThread name=" + Thread.currentThread().getName()));
                    }
                    this.encoder.encode(asn1Type, this.sockout);
                    if (this.userMode || this.outputQueue.isEmpty()) {
                        this.sockout.flush();
                    }
                    this.sentMessagesCounter.increaseCount();
                    l = l2 = System.currentTimeMillis();
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    if (this.done) continue;
                    logcat.warn((Object)"could not remove message from queue ", (Throwable)interruptedException);
                    continue;
                }
                catch (Throwable throwable) {
                    if (logcat.isDebugEnabled()) {
                        logcat.debug((Object)("error while sending message " + AsnClassesEncoderDecoder.toString((Asn1TypeIF)asn1Type, "ServerMessage")), throwable);
                    } else if (this.sessionDebug) {
                        logcat.warn((Object)("error while sending message " + AsnClassesEncoderDecoder.toString((Asn1TypeIF)asn1Type, "ServerMessage")), throwable);
                    }
                    if (!this.done) {
                        this.sessionCloseListener.close("could not write message " + throwable.getMessage(), false);
                    }
                    return;
                }
            }
            if (!this.sendKeepAlive) continue;
            long l3 = l;
            if (Math.abs(l3 - (l = System.currentTimeMillis())) > this.CLOCK_CHANGE_MARGIN || l - l2 > this.keepAlivePeriod) {
                if (Math.abs(l3 - l) > this.CLOCK_CHANGE_MARGIN) {
                    logcat.warn((Object)"Clock change event detected, sending keep alive to peer");
                }
                KeepAlive keepAlive = new KeepAlive(l);
                Asn1Type asn1Type2 = this.keepAliveProvider.createKeepAlive(keepAlive);
                if (this.sessionDebug) {
                    logcat.info((Object)("sent keep-alive to peer:\n" + AsnClassesEncoderDecoder.toString((Asn1TypeIF)asn1Type2, "KeepAlive") + "time=" + new Date() + "\nThread name=" + Thread.currentThread().getName()));
                }
                try {
                    this.outputQueue.add(asn1Type2);
                }
                catch (InterruptedException interruptedException) {
                    logcat.error((Object)"could not add keepalive message to queue ", (Throwable)interruptedException);
                }
                continue;
            }
            try {
                this.outputQueue.waitWhileEmpty((int)this.keepAlivePeriod);
            }
            catch (InterruptedException interruptedException) {
                if (this.done) continue;
                logcat.warn((Object)"could not remove message from queue ", (Throwable)interruptedException);
            }
        }
    }

    long getSentMessagesCounter() {
        return this.sentMessagesCounter.getCounter();
    }

    void resetSentMessagesCounter() {
        this.sentMessagesCounter.reset();
    }

    public void start() {
        this.done = false;
        super.start();
    }

    void requestStop() {
        this.done = true;
        this.sentMessagesCounter.close();
        this.interrupt();
        try {
            this.outputQueue.removeAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            this.join(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    void setSessionDebugFlag(boolean bl) {
        this.sessionDebug = bl;
    }
}

