/*
 * Decompiled with CFR 0.152.
 */
package com.pcube.management.framework.rpc;

import com.pcube.management.common.threads.ObjectFIFO;
import com.pcube.management.framework.rpc.AsnClassesEncoderDecoder;
import com.pcube.management.framework.rpc.ResultHandler;
import com.pcube.management.framework.rpc.WireToAsnDecoder;
import com.pcube.management.framework.rpc.protocol.OperationResult;
import com.pcube.management.framework.rpc.protocol.ServerMessage;
import org.apache.log4j.Category;

class ResultDispatcher
extends Thread {
    private static Category logcat = Category.getInstance(ResultDispatcher.class);
    private ResultHandler resultHandler;
    private ObjectFIFO resultQueue;
    private WireToAsnDecoder decoder;
    private boolean done;

    ResultDispatcher(ObjectFIFO objectFIFO, ResultHandler resultHandler, String string, int n, ThreadGroup threadGroup) {
        super(threadGroup, string);
        this.setPriority(n);
        this.resultQueue = objectFIFO;
        this.resultHandler = resultHandler;
    }

    public void run() {
        Object object = null;
        while (!this.done) {
            ServerMessage serverMessage;
            try {
                serverMessage = (ServerMessage)((Object)this.resultQueue.remove());
            }
            catch (InterruptedException interruptedException) {
                if (this.done) continue;
                logcat.error((Object)"could not remove message from queue", (Throwable)interruptedException);
                continue;
            }
            OperationResult operationResult = (OperationResult)serverMessage.getElement();
            object = AsnClassesEncoderDecoder.decodeResult(serverMessage);
            if (this.resultHandler == null) continue;
            try {
                if (object instanceof Throwable) {
                    this.resultHandler.handleError(operationResult.operationCounter.value, object);
                    continue;
                }
                this.resultHandler.handleSuccess(operationResult.operationCounter.value, object);
            }
            catch (Throwable throwable) {
                logcat.error((Object)"result handler error", throwable);
            }
        }
    }

    void setResultHandler(ResultHandler resultHandler) {
        this.resultHandler = resultHandler;
    }

    public void start() {
        this.done = false;
        super.start();
    }

    void requestStop() {
        this.done = true;
        this.interrupt();
        try {
            this.join(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

