/*
 * Decompiled with CFR 0.152.
 */
package com.pcube.management.framework.rpc;

import com.objsys.asn1j.runtime.Asn1TypeIF;
import com.pcube.management.common.ArrayUtilities;
import com.pcube.management.common.threads.ObjectFIFO;
import com.pcube.management.framework.agent.StatsVar;
import com.pcube.management.framework.rpc.AsnClassesEncoderDecoder;
import com.pcube.management.framework.rpc.protocol.ServerMessage;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Category;

class ServerSessionNotificationListener {
    private ObjectFIFO outputQueue;
    private HashMap objectsToListenTo;
    private boolean dropNotificationsIfQueueIsFull;
    private String sessionName;
    private boolean stopped;
    private Thread currentSenderThread;
    private boolean sessionDebug = false;
    private StatsVar sentNotificationsCounter;
    private StatsVar droppedNotificationsCounter;
    private static Category logcat = Category.getInstance(ServerSessionNotificationListener.class);

    ServerSessionNotificationListener(ObjectFIFO objectFIFO, boolean bl, String string, String string2) {
        this.outputQueue = objectFIFO;
        this.dropNotificationsIfQueueIsFull = bl;
        this.sessionName = string;
        this.objectsToListenTo = new HashMap();
        this.stopped = false;
        this.sentNotificationsCounter = new StatsVar(string2 + ".RPC.NotificationListener.sentNotifications");
        this.droppedNotificationsCounter = new StatsVar(string2 + ".RPC.NotificationListener.droppedNotifications");
    }

    synchronized boolean acceptByType(String string, String string2) {
        Set set = (Set)this.objectsToListenTo.get(string);
        return set != null && (set.size() == 0 || set.contains(string2));
    }

    synchronized void register(String string, String[] stringArray) {
        this.registerInfoMessage(string, stringArray);
        HashSet hashSet = new HashSet();
        ServerSessionNotificationListener.addNotificationTypes(hashSet, stringArray);
        this.objectsToListenTo.put(string, hashSet);
    }

    private final void registerInfoMessage(String string, String[] stringArray) {
        String string2;
        Set set = (Set)this.objectsToListenTo.get(string);
        String string3 = string2 = null == stringArray || 0 == stringArray.length ? "\"ALL\"" : ArrayUtilities.stringArrayToString(stringArray, ",");
        if (set == null) {
            this.info(this.sessionName + ": registering to listen to notifications from " + string + " notification types are " + string2);
        } else {
            this.info(this.sessionName + ": replacing notification filter for " + string + " notification types are " + string2);
        }
    }

    private static final void addNotificationTypes(Set set, String[] stringArray) {
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                set.add(stringArray[i]);
            }
        }
    }

    synchronized void deregister(String string) throws IllegalStateException {
        Set set = (Set)this.objectsToListenTo.remove(string);
        if (set == null) {
            String string2 = this.sessionName + ": requested not to listen to " + string + " while not listening to it";
            this.warn(string2, null);
            throw new IllegalStateException(string2);
        }
        this.info(this.sessionName + ": dergistered from listening to " + string);
    }

    synchronized void deregisterAll() {
        this.objectsToListenTo = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendNotification(ServerMessage serverMessage, boolean bl) throws InterruptedException {
        if ((bl || this.dropNotificationsIfQueueIsFull) && this.outputQueue.isFull()) {
            this.droppedNotificationsCounter.increaseCount();
            return;
        }
        try {
            this.currentSenderThread = Thread.currentThread();
            if (this.sessionDebug) {
                logcat.info((Object)("sent notification to peer:\n" + AsnClassesEncoderDecoder.toString((Asn1TypeIF)serverMessage, "Notification") + "time=" + new Date() + "\nSession name=" + this.sessionName));
            }
            if (!this.stopped) {
                this.outputQueue.add((Object)serverMessage);
            }
            this.sentNotificationsCounter.increaseCount();
        }
        finally {
            this.currentSenderThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        this.sentNotificationsCounter.close();
        this.droppedNotificationsCounter.close();
        ObjectFIFO objectFIFO = this.outputQueue;
        synchronized (objectFIFO) {
            this.stopped = true;
            if (this.currentSenderThread != null && this.outputQueue.isFull()) {
                try {
                    this.currentSenderThread.interrupt();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
    }

    long getSentNotificationsCounter() {
        return this.sentNotificationsCounter.getCounter();
    }

    void resetSentNotificationsCounter() {
        this.sentNotificationsCounter.reset();
    }

    long getDroppedNotificationsCounter() {
        return this.droppedNotificationsCounter.getCounter();
    }

    void resetDroppedNotificationsCounter() {
        this.droppedNotificationsCounter.reset();
    }

    String getSessionName() {
        return this.sessionName;
    }

    void setSessionDebugFlag(boolean bl) {
        this.sessionDebug = bl;
    }

    private final void debug(String string, Throwable throwable) {
        logcat.warn((Object)(this.sessionName + ":: " + string), throwable);
    }

    private final void error(String string, Throwable throwable) {
        logcat.warn((Object)(this.sessionName + ":: " + string), throwable);
    }

    private final void warn(String string, Throwable throwable) {
        logcat.warn((Object)(this.sessionName + ":: " + string), throwable);
    }

    private final void info(String string) {
        logcat.info((Object)(this.sessionName + ":: " + string));
    }
}

