/*
 * Decompiled with CFR 0.152.
 */
package com.pcube.management.framework.rpc;

import com.pcube.management.common.StreamKMP;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Category;

public class XMLDocumentSeparatorInputStream
extends InputStream {
    private static final int BUFFER_SIZE = 32768;
    private static final byte LT = 60;
    private static final byte GT = 62;
    private static Category logcat = Category.getInstance(XMLDocumentSeparatorInputStream.class);
    StreamKMP pattern;
    StreamKMP xmlCommentStart = new StreamKMP("<!--");
    StreamKMP xmlCommentEnd = new StreamKMP("-->");
    boolean inXMLComment = false;
    boolean realEOF = false;
    boolean nextEOF = false;
    int markPatternState;
    int markXMLCommentStartState;
    int markXMLCommentEndState;
    byte[] buf = new byte[32768];
    int bufpos = 0;
    int buflen = 0;
    private InputStream in;

    public XMLDocumentSeparatorInputStream(InputStream inputStream, String string) {
        this.in = inputStream;
        this.pattern = new StreamKMP(string);
    }

    public synchronized int read() throws IOException {
        this.fill();
        if (this.realEOF || this.nextEOF) {
            return -1;
        }
        byte by = this.buf[this.bufpos++];
        if (!this.inXMLComment && this.xmlCommentStart.matchNext(by)) {
            this.inXMLComment = true;
            this.pattern.reset();
            this.xmlCommentEnd.reset();
        } else if (this.inXMLComment && this.xmlCommentEnd.matchNext(by)) {
            this.inXMLComment = false;
            this.xmlCommentEnd.reset();
        } else if (this.pattern.matchNext(by)) {
            this.nextEOF = true;
            this.pattern.reset();
        }
        return by;
    }

    public synchronized void mark(int n) {
        System.err.println("#$%#$%#$% mark was called");
        if (this.in.markSupported()) {
            this.in.mark(n);
            this.markPatternState = this.pattern.getState();
            this.markXMLCommentStartState = this.xmlCommentStart.getState();
            this.markXMLCommentEndState = this.xmlCommentEnd.getState();
        }
    }

    public long skip(long l) throws IOException {
        System.err.println("#$%#$%#$% skip was called");
        return this.in.skip(l);
    }

    public int available() throws IOException {
        return this.in.available() + this.buflen - this.bufpos;
    }

    public void close() throws IOException {
        this.nextEOF = true;
    }

    public void realClose() throws IOException {
        this.in.close();
    }

    public synchronized void reset() throws IOException {
        if (this.in.markSupported()) {
            this.in.reset();
            this.pattern.setState(this.markPatternState);
            this.xmlCommentStart.setState(this.markXMLCommentStartState);
            this.xmlCommentEnd.setState(this.markXMLCommentEndState);
        }
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    void fill() throws IOException {
        if (this.bufpos == this.buflen && !this.nextEOF) {
            this.buflen = this.in.read(this.buf);
            this.bufpos = 0;
            if (this.buflen < 0) {
                this.realEOF = true;
            }
        }
    }

    public void release() {
        this.nextEOF = false;
    }

    public boolean isEOF() {
        return this.realEOF;
    }
}

