/*
 * Decompiled with CFR 0.152.
 */
package com.pcube.management.framework.rpc.protocol;

import com.objsys.asn1j.runtime.Asn1BerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerDecodeContext;
import com.objsys.asn1j.runtime.Asn1BerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1Exception;
import com.objsys.asn1j.runtime.Asn1Integer;
import com.objsys.asn1j.runtime.Asn1MissingRequiredException;
import com.objsys.asn1j.runtime.Asn1OpenExt;
import com.objsys.asn1j.runtime.Asn1Tag;
import com.objsys.asn1j.runtime.Asn1Type;
import com.objsys.asn1j.runtime.Asn1UTF8String;
import com.objsys.asn1j.runtime.Asn1XerElemInfo;
import com.objsys.asn1j.runtime.Asn1XerEncoder;
import com.objsys.asn1j.runtime.Asn1XerSaxHandler;
import com.objsys.asn1j.runtime.IntHolder;
import com.pcube.management.framework.rpc.protocol.Parameters;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class Notification
extends Asn1Type {
    public Asn1UTF8String objectName;
    public Asn1UTF8String type;
    public Asn1UTF8String message;
    public Asn1Integer sequenceNumber;
    public Asn1Integer timeStamp;
    public Parameters additionalData;
    public Asn1OpenExt extElem1;
    private transient Asn1XerSaxHandler mSaxHandler = null;

    public Notification() {
    }

    public Notification(Asn1UTF8String asn1UTF8String, Asn1UTF8String asn1UTF8String2, Asn1UTF8String asn1UTF8String3, Asn1Integer asn1Integer, Asn1Integer asn1Integer2, Parameters parameters) {
        this.objectName = asn1UTF8String;
        this.type = asn1UTF8String2;
        this.message = asn1UTF8String3;
        this.sequenceNumber = asn1Integer;
        this.timeStamp = asn1Integer2;
        this.additionalData = parameters;
    }

    public Notification(Asn1UTF8String asn1UTF8String, Asn1UTF8String asn1UTF8String2, Asn1UTF8String asn1UTF8String3) {
        this.objectName = asn1UTF8String;
        this.type = asn1UTF8String2;
        this.message = asn1UTF8String3;
    }

    public Notification(String string, String string2, String string3, long l, long l2, Parameters parameters) {
        this.objectName = new Asn1UTF8String(string);
        this.type = new Asn1UTF8String(string2);
        this.message = new Asn1UTF8String(string3);
        this.sequenceNumber = new Asn1Integer(l);
        this.timeStamp = new Asn1Integer(l2);
        this.additionalData = parameters;
    }

    public Notification(String string, String string2, String string3) {
        this.objectName = new Asn1UTF8String(string);
        this.type = new Asn1UTF8String(string2);
        this.message = new Asn1UTF8String(string3);
    }

    public void init() {
        this.objectName = null;
        this.type = null;
        this.message = null;
        this.sequenceNumber = null;
        this.timeStamp = null;
        this.additionalData = null;
        this.extElem1 = null;
    }

    public void decode(Asn1BerDecodeBuffer asn1BerDecodeBuffer, boolean bl, int n) throws Asn1Exception, IOException {
        int n2 = bl ? this.matchTag(asn1BerDecodeBuffer, Asn1Tag.SEQUENCE) : n;
        this.init();
        Asn1BerDecodeContext asn1BerDecodeContext = new Asn1BerDecodeContext(asn1BerDecodeBuffer, n2);
        IntHolder intHolder = new IntHolder();
        if (!asn1BerDecodeContext.matchElemTag((short)128, (short)0, 0, intHolder, true)) {
            throw new Asn1MissingRequiredException(asn1BerDecodeBuffer);
        }
        this.objectName = new Asn1UTF8String();
        this.objectName.decode(asn1BerDecodeBuffer, false, intHolder.value);
        if (!asn1BerDecodeContext.matchElemTag((short)128, (short)0, 1, intHolder, true)) {
            throw new Asn1MissingRequiredException(asn1BerDecodeBuffer);
        }
        this.type = new Asn1UTF8String();
        this.type.decode(asn1BerDecodeBuffer, false, intHolder.value);
        if (!asn1BerDecodeContext.matchElemTag((short)128, (short)0, 2, intHolder, true)) {
            throw new Asn1MissingRequiredException(asn1BerDecodeBuffer);
        }
        this.message = new Asn1UTF8String();
        this.message.decode(asn1BerDecodeBuffer, false, intHolder.value);
        if (asn1BerDecodeContext.matchElemTag((short)128, (short)0, 3, intHolder, true)) {
            this.sequenceNumber = new Asn1Integer();
            this.sequenceNumber.decode(asn1BerDecodeBuffer, false, intHolder.value);
        }
        if (asn1BerDecodeContext.matchElemTag((short)128, (short)0, 4, intHolder, true)) {
            this.timeStamp = new Asn1Integer();
            this.timeStamp.decode(asn1BerDecodeBuffer, false, intHolder.value);
        }
        if (asn1BerDecodeContext.matchElemTag((short)128, (short)32, 5, intHolder, true)) {
            this.additionalData = new Parameters();
            this.additionalData.decode(asn1BerDecodeBuffer, false, intHolder.value);
            if (intHolder.value == -9999) {
                this.matchTag(asn1BerDecodeBuffer, Asn1Tag.EOC);
            }
        }
        if (!asn1BerDecodeContext.expired()) {
            this.extElem1 = new Asn1OpenExt();
            while (!asn1BerDecodeContext.expired()) {
                this.extElem1.decodeComponent(asn1BerDecodeBuffer);
            }
        } else {
            this.extElem1 = null;
        }
        if (bl && n2 == -9999) {
            this.matchTag(asn1BerDecodeBuffer, Asn1Tag.EOC);
        }
    }

    public int encode(Asn1BerEncodeBuffer asn1BerEncodeBuffer, boolean bl) throws Asn1Exception {
        int n;
        int n2 = 0;
        if (this.extElem1 != null) {
            n = this.extElem1.encode(asn1BerEncodeBuffer, false);
            n2 += n;
        }
        if (this.additionalData != null) {
            n = this.additionalData.encode(asn1BerEncodeBuffer, false);
            n2 += n;
            n2 += asn1BerEncodeBuffer.encodeTagAndLength((short)128, (short)32, 5, n);
        }
        if (this.timeStamp != null) {
            n = this.timeStamp.encode(asn1BerEncodeBuffer, false);
            n2 += n;
            n2 += asn1BerEncodeBuffer.encodeTagAndLength((short)128, (short)0, 4, n);
        }
        if (this.sequenceNumber != null) {
            n = this.sequenceNumber.encode(asn1BerEncodeBuffer, false);
            n2 += n;
            n2 += asn1BerEncodeBuffer.encodeTagAndLength((short)128, (short)0, 3, n);
        }
        n = this.message.encode(asn1BerEncodeBuffer, false);
        n2 += n;
        n2 += asn1BerEncodeBuffer.encodeTagAndLength((short)128, (short)0, 2, n);
        n = this.type.encode(asn1BerEncodeBuffer, false);
        n2 += n;
        n2 += asn1BerEncodeBuffer.encodeTagAndLength((short)128, (short)0, 1, n);
        n = this.objectName.encode(asn1BerEncodeBuffer, false);
        n2 += n;
        n2 += asn1BerEncodeBuffer.encodeTagAndLength((short)128, (short)0, 0, n);
        if (bl) {
            n2 += asn1BerEncodeBuffer.encodeTagAndLength(Asn1Tag.SEQUENCE, n2);
        }
        return n2;
    }

    public void decode(Object object, String string) throws Asn1Exception, IOException {
        XMLReader xMLReader = (XMLReader)object;
        try {
            SaxHandler saxHandler = (SaxHandler)this.getSaxHandler();
            xMLReader.setContentHandler((ContentHandler)((Object)saxHandler));
            xMLReader.setErrorHandler((ErrorHandler)((Object)saxHandler));
            xMLReader.parse(new InputSource(string));
        }
        catch (SAXException sAXException) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            sAXException.printStackTrace(new PrintStream(byteArrayOutputStream));
            throw new Asn1Exception(byteArrayOutputStream.toString());
        }
    }

    public void decode(Object object, InputStream inputStream) throws Asn1Exception, IOException {
        XMLReader xMLReader = (XMLReader)object;
        try {
            SaxHandler saxHandler = (SaxHandler)this.getSaxHandler();
            xMLReader.setContentHandler((ContentHandler)((Object)saxHandler));
            xMLReader.setErrorHandler((ErrorHandler)((Object)saxHandler));
            xMLReader.parse(new InputSource(inputStream));
        }
        catch (SAXException sAXException) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            sAXException.printStackTrace(new PrintStream(byteArrayOutputStream));
            throw new Asn1Exception(byteArrayOutputStream.toString());
        }
    }

    public boolean matchTypeName(String string) {
        return string.equals("Notification");
    }

    public Asn1XerSaxHandler getSaxHandler() {
        if (this.mSaxHandler == null) {
            this.mSaxHandler = new SaxHandler();
        }
        this.mSaxHandler.init(0);
        return this.mSaxHandler;
    }

    public void encode(Asn1XerEncoder asn1XerEncoder, String string) throws Asn1Exception, IOException {
        if (string == null) {
            string = "Notification";
        }
        asn1XerEncoder.encodeStartElement(string);
        asn1XerEncoder.incrLevel();
        this.objectName.encode(asn1XerEncoder, "objectName");
        this.type.encode(asn1XerEncoder, "type");
        this.message.encode(asn1XerEncoder, "message");
        if (this.sequenceNumber != null) {
            this.sequenceNumber.encode(asn1XerEncoder, "sequenceNumber");
        }
        if (this.timeStamp != null) {
            this.timeStamp.encode(asn1XerEncoder, "timeStamp");
        }
        if (this.additionalData != null) {
            this.additionalData.encode(asn1XerEncoder, "additionalData");
        }
        if (this.extElem1 != null) {
            // empty if block
        }
        asn1XerEncoder.decrLevel();
        asn1XerEncoder.encodeEndElement(string);
    }

    public void print(PrintStream printStream, String string, int n) {
        this.indent(printStream, n);
        printStream.println(string + " {");
        if (this.objectName != null) {
            this.objectName.print(printStream, "objectName", n + 1);
        }
        if (this.type != null) {
            this.type.print(printStream, "type", n + 1);
        }
        if (this.message != null) {
            this.message.print(printStream, "message", n + 1);
        }
        if (this.sequenceNumber != null) {
            this.sequenceNumber.print(printStream, "sequenceNumber", n + 1);
        }
        if (this.timeStamp != null) {
            this.timeStamp.print(printStream, "timeStamp", n + 1);
        }
        if (this.additionalData != null) {
            this.additionalData.print(printStream, "additionalData", n + 1);
        }
        if (this.extElem1 != null) {
            this.extElem1.print(printStream, "extElem1", n + 1);
        }
        this.indent(printStream, n);
        printStream.println("}");
    }

    public class SaxHandler
    extends Asn1XerSaxHandler {
        private static final byte _OBJECTNAME = 1;
        private static final byte _TYPE = 2;
        private static final byte _MESSAGE = 3;
        private static final byte _SEQUENCENUMBER = 4;
        private static final byte _TIMESTAMP = 5;
        private static final byte _ADDITIONALDATA = 6;
        private static final byte _EXTELEM1 = 7;
        Asn1XerSaxHandler mElemSaxHandler = null;
        StringBuffer mCurrElemValue = new StringBuffer();
        int mReqElemCnt;

        SaxHandler() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (this.mLevel == 0) {
                if (!Notification.this.matchTypeName(string2)) {
                    throw new SAXException("unexpected tag: " + string2);
                }
            } else if (this.mLevel == 1) {
                this.mCurrState = 1;
                this.mCurrElemID = this.getElementID(string, string2, string3);
                if (this.mCurrElemID == -1) {
                    throw new SAXException("unexpected tag: " + string2);
                }
                this.mCurrElemValue.setLength(0);
                switch (this.mCurrElemID) {
                    case 6: {
                        Notification.this.additionalData = new Parameters(0);
                        this.mElemSaxHandler = Notification.this.additionalData.getSaxHandler();
                        this.mElemSaxHandler.init(1);
                    }
                }
            } else if (this.mElemSaxHandler != null) {
                this.mElemSaxHandler.startElement(string, string2, string3, attributes);
            }
            ++this.mLevel;
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if ((this.mCurrState == 1 || this.mCurrState == 2) && this.mLevel >= 2) {
                if (this.mElemSaxHandler != null) {
                    this.mElemSaxHandler.characters(cArray, n, n2);
                } else if (this.mCurrElemID == 1 || this.mCurrElemID == 2 || this.mCurrElemID == 3 || this.mCurrElemID == 4 || this.mCurrElemID == 5) {
                    this.mCurrState = 2;
                    this.mCurrElemValue.append(cArray, n, n2);
                }
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (--this.mLevel == 0) {
                if (this.mReqElemCnt != 3) {
                    throw new SAXException("missing required fields");
                }
            } else if (this.mLevel == 1) {
                if (this.mCurrState == 2) {
                    try {
                        switch (this.mCurrElemID) {
                            case 1: {
                                Notification.this.objectName = new Asn1UTF8String();
                                Notification.this.objectName.decodeXER(this.mCurrElemValue.toString(), null);
                                break;
                            }
                            case 2: {
                                Notification.this.type = new Asn1UTF8String();
                                Notification.this.type.decodeXER(this.mCurrElemValue.toString(), null);
                                break;
                            }
                            case 3: {
                                Notification.this.message = new Asn1UTF8String();
                                Notification.this.message.decodeXER(this.mCurrElemValue.toString(), null);
                                break;
                            }
                            case 4: {
                                Notification.this.sequenceNumber = new Asn1Integer();
                                Notification.this.sequenceNumber.decodeXER(this.mCurrElemValue.toString(), null);
                                break;
                            }
                            case 5: {
                                Notification.this.timeStamp = new Asn1Integer();
                                Notification.this.timeStamp.decodeXER(this.mCurrElemValue.toString(), null);
                                break;
                            }
                        }
                    }
                    catch (Asn1Exception asn1Exception) {
                        throw new SAXException(asn1Exception.getMessage());
                    }
                }
                if (this.mElemSaxHandler != null) {
                    if (this.mElemSaxHandler.isComplete()) {
                        this.mElemSaxHandler.endElement(string, string2, string3);
                        this.mElemSaxHandler = null;
                    } else {
                        throw new SAXException("child endElement not complete");
                    }
                }
                this.mCurrState = 3;
            } else if (this.mElemSaxHandler != null) {
                this.mElemSaxHandler.endElement(string, string2, string3);
            }
        }

        protected int getElementID(String string, String string2, String string3) {
            Asn1XerElemInfo[] asn1XerElemInfoArray = new Asn1XerElemInfo[]{new Asn1XerElemInfo("objectName", false), new Asn1XerElemInfo("type", false), new Asn1XerElemInfo("message", false), new Asn1XerElemInfo("sequenceNumber", true), new Asn1XerElemInfo("timeStamp", true), new Asn1XerElemInfo("additionalData", true)};
            for (int i = this.mCurrElemID; i < 6; ++i) {
                if (asn1XerElemInfoArray[i].equals(string2)) {
                    if (!asn1XerElemInfoArray[i].isOptional()) {
                        ++this.mReqElemCnt;
                    }
                    return i + 1;
                }
                if (!asn1XerElemInfoArray[i].isOptional()) break;
            }
            return -1;
        }

        public void init(int n) {
            super.init(n);
            this.mElemSaxHandler = null;
            this.mReqElemCnt = 0;
            Notification.this.objectName = null;
            Notification.this.type = null;
            Notification.this.message = null;
            Notification.this.sequenceNumber = null;
            Notification.this.timeStamp = null;
            Notification.this.additionalData = null;
            Notification.this.extElem1 = null;
        }
    }
}

