/*
 * Decompiled with CFR 0.152.
 */
package com.pcube.management.framework.rpc.protocol;

import com.objsys.asn1j.runtime.Asn1BerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerDecodeContext;
import com.objsys.asn1j.runtime.Asn1BerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1Exception;
import com.objsys.asn1j.runtime.Asn1Integer;
import com.objsys.asn1j.runtime.Asn1MissingRequiredException;
import com.objsys.asn1j.runtime.Asn1OpenExt;
import com.objsys.asn1j.runtime.Asn1Tag;
import com.objsys.asn1j.runtime.Asn1Type;
import com.objsys.asn1j.runtime.Asn1XerElemInfo;
import com.objsys.asn1j.runtime.Asn1XerEncoder;
import com.objsys.asn1j.runtime.Asn1XerSaxHandler;
import com.objsys.asn1j.runtime.IntHolder;
import com.pcube.management.framework.rpc.protocol.Operation_operation;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class Operation
extends Asn1Type {
    public Asn1Integer threadNumber;
    public Asn1Integer operationCounter;
    public Operation_operation operation;
    public Asn1OpenExt extElem1;
    private transient Asn1XerSaxHandler mSaxHandler = null;

    public Operation() {
    }

    public Operation(Asn1Integer asn1Integer, Asn1Integer asn1Integer2, Operation_operation operation_operation) {
        this.threadNumber = asn1Integer;
        this.operationCounter = asn1Integer2;
        this.operation = operation_operation;
    }

    public Operation(long l, long l2, Operation_operation operation_operation) {
        this.threadNumber = new Asn1Integer(l);
        this.operationCounter = new Asn1Integer(l2);
        this.operation = operation_operation;
    }

    public void init() {
        this.threadNumber = null;
        this.operationCounter = null;
        this.operation = null;
        this.extElem1 = null;
    }

    public void decode(Asn1BerDecodeBuffer asn1BerDecodeBuffer, boolean bl, int n) throws Asn1Exception, IOException {
        int n2 = bl ? this.matchTag(asn1BerDecodeBuffer, Asn1Tag.SEQUENCE) : n;
        this.init();
        Asn1BerDecodeContext asn1BerDecodeContext = new Asn1BerDecodeContext(asn1BerDecodeBuffer, n2);
        IntHolder intHolder = new IntHolder();
        if (!asn1BerDecodeContext.matchElemTag((short)128, (short)0, 0, intHolder, true)) {
            throw new Asn1MissingRequiredException(asn1BerDecodeBuffer);
        }
        this.threadNumber = new Asn1Integer();
        this.threadNumber.decode(asn1BerDecodeBuffer, false, intHolder.value);
        if (!asn1BerDecodeContext.matchElemTag((short)128, (short)0, 1, intHolder, true)) {
            throw new Asn1MissingRequiredException(asn1BerDecodeBuffer);
        }
        this.operationCounter = new Asn1Integer();
        this.operationCounter.decode(asn1BerDecodeBuffer, false, intHolder.value);
        if (asn1BerDecodeContext.matchElemTag((short)128, (short)32, 2, intHolder, true)) {
            this.operation = new Operation_operation();
            this.operation.decode(asn1BerDecodeBuffer, false, intHolder.value);
            if (intHolder.value == -9999) {
                this.matchTag(asn1BerDecodeBuffer, Asn1Tag.EOC);
            }
        } else {
            throw new Asn1MissingRequiredException(asn1BerDecodeBuffer);
        }
        if (!asn1BerDecodeContext.expired()) {
            this.extElem1 = new Asn1OpenExt();
            while (!asn1BerDecodeContext.expired()) {
                this.extElem1.decodeComponent(asn1BerDecodeBuffer);
            }
        } else {
            this.extElem1 = null;
        }
        if (bl && n2 == -9999) {
            this.matchTag(asn1BerDecodeBuffer, Asn1Tag.EOC);
        }
    }

    public int encode(Asn1BerEncodeBuffer asn1BerEncodeBuffer, boolean bl) throws Asn1Exception {
        int n;
        int n2 = 0;
        if (this.extElem1 != null) {
            n = this.extElem1.encode(asn1BerEncodeBuffer, false);
            n2 += n;
        }
        n = this.operation.encode(asn1BerEncodeBuffer, false);
        n2 += n;
        n2 += asn1BerEncodeBuffer.encodeTagAndLength((short)128, (short)32, 2, n);
        n = this.operationCounter.encode(asn1BerEncodeBuffer, false);
        n2 += n;
        n2 += asn1BerEncodeBuffer.encodeTagAndLength((short)128, (short)0, 1, n);
        n = this.threadNumber.encode(asn1BerEncodeBuffer, false);
        n2 += n;
        n2 += asn1BerEncodeBuffer.encodeTagAndLength((short)128, (short)0, 0, n);
        if (bl) {
            n2 += asn1BerEncodeBuffer.encodeTagAndLength(Asn1Tag.SEQUENCE, n2);
        }
        return n2;
    }

    public void decode(Object object, String string) throws Asn1Exception, IOException {
        XMLReader xMLReader = (XMLReader)object;
        try {
            SaxHandler saxHandler = (SaxHandler)this.getSaxHandler();
            xMLReader.setContentHandler((ContentHandler)((Object)saxHandler));
            xMLReader.setErrorHandler((ErrorHandler)((Object)saxHandler));
            xMLReader.parse(new InputSource(string));
        }
        catch (SAXException sAXException) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            sAXException.printStackTrace(new PrintStream(byteArrayOutputStream));
            throw new Asn1Exception(byteArrayOutputStream.toString());
        }
    }

    public void decode(Object object, InputStream inputStream) throws Asn1Exception, IOException {
        XMLReader xMLReader = (XMLReader)object;
        try {
            SaxHandler saxHandler = (SaxHandler)this.getSaxHandler();
            xMLReader.setContentHandler((ContentHandler)((Object)saxHandler));
            xMLReader.setErrorHandler((ErrorHandler)((Object)saxHandler));
            xMLReader.parse(new InputSource(inputStream));
        }
        catch (SAXException sAXException) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            sAXException.printStackTrace(new PrintStream(byteArrayOutputStream));
            throw new Asn1Exception(byteArrayOutputStream.toString());
        }
    }

    public boolean matchTypeName(String string) {
        return string.equals("Operation");
    }

    public Asn1XerSaxHandler getSaxHandler() {
        if (this.mSaxHandler == null) {
            this.mSaxHandler = new SaxHandler();
        }
        this.mSaxHandler.init(0);
        return this.mSaxHandler;
    }

    public void encode(Asn1XerEncoder asn1XerEncoder, String string) throws Asn1Exception, IOException {
        if (string == null) {
            string = "Operation";
        }
        asn1XerEncoder.encodeStartElement(string);
        asn1XerEncoder.incrLevel();
        this.threadNumber.encode(asn1XerEncoder, "threadNumber");
        this.operationCounter.encode(asn1XerEncoder, "operationCounter");
        this.operation.encode(asn1XerEncoder, "operation");
        if (this.extElem1 != null) {
            // empty if block
        }
        asn1XerEncoder.decrLevel();
        asn1XerEncoder.encodeEndElement(string);
    }

    public void print(PrintStream printStream, String string, int n) {
        this.indent(printStream, n);
        printStream.println(string + " {");
        if (this.threadNumber != null) {
            this.threadNumber.print(printStream, "threadNumber", n + 1);
        }
        if (this.operationCounter != null) {
            this.operationCounter.print(printStream, "operationCounter", n + 1);
        }
        if (this.operation != null) {
            this.operation.print(printStream, "operation", n + 1);
        }
        if (this.extElem1 != null) {
            this.extElem1.print(printStream, "extElem1", n + 1);
        }
        this.indent(printStream, n);
        printStream.println("}");
    }

    public class SaxHandler
    extends Asn1XerSaxHandler {
        private static final byte _THREADNUMBER = 1;
        private static final byte _OPERATIONCOUNTER = 2;
        private static final byte _OPERATION = 3;
        private static final byte _EXTELEM1 = 4;
        Asn1XerSaxHandler mElemSaxHandler = null;
        StringBuffer mCurrElemValue = new StringBuffer();
        int mReqElemCnt;

        SaxHandler() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (this.mLevel == 0) {
                if (!Operation.this.matchTypeName(string2)) {
                    throw new SAXException("unexpected tag: " + string2);
                }
            } else if (this.mLevel == 1) {
                this.mCurrState = 1;
                this.mCurrElemID = this.getElementID(string, string2, string3);
                if (this.mCurrElemID == -1) {
                    throw new SAXException("unexpected tag: " + string2);
                }
                this.mCurrElemValue.setLength(0);
                switch (this.mCurrElemID) {
                    case 3: {
                        Operation.this.operation = new Operation_operation();
                        this.mElemSaxHandler = Operation.this.operation.getSaxHandler();
                        this.mElemSaxHandler.init(1);
                    }
                }
            } else if (this.mElemSaxHandler != null) {
                this.mElemSaxHandler.startElement(string, string2, string3, attributes);
            }
            ++this.mLevel;
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if ((this.mCurrState == 1 || this.mCurrState == 2) && this.mLevel >= 2) {
                if (this.mElemSaxHandler != null) {
                    this.mElemSaxHandler.characters(cArray, n, n2);
                } else if (this.mCurrElemID == 1 || this.mCurrElemID == 2) {
                    this.mCurrState = 2;
                    this.mCurrElemValue.append(cArray, n, n2);
                }
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (--this.mLevel == 0) {
                if (this.mReqElemCnt != 3) {
                    throw new SAXException("missing required fields");
                }
            } else if (this.mLevel == 1) {
                if (this.mCurrState == 2) {
                    try {
                        switch (this.mCurrElemID) {
                            case 1: {
                                Operation.this.threadNumber = new Asn1Integer();
                                Operation.this.threadNumber.decodeXER(this.mCurrElemValue.toString(), null);
                                break;
                            }
                            case 2: {
                                Operation.this.operationCounter = new Asn1Integer();
                                Operation.this.operationCounter.decodeXER(this.mCurrElemValue.toString(), null);
                                break;
                            }
                        }
                    }
                    catch (Asn1Exception asn1Exception) {
                        throw new SAXException(asn1Exception.getMessage());
                    }
                }
                if (this.mElemSaxHandler != null) {
                    if (this.mElemSaxHandler.isComplete()) {
                        this.mElemSaxHandler.endElement(string, string2, string3);
                        this.mElemSaxHandler = null;
                    } else {
                        throw new SAXException("child endElement not complete");
                    }
                }
                this.mCurrState = 3;
            } else if (this.mElemSaxHandler != null) {
                this.mElemSaxHandler.endElement(string, string2, string3);
            }
        }

        protected int getElementID(String string, String string2, String string3) {
            Asn1XerElemInfo[] asn1XerElemInfoArray = new Asn1XerElemInfo[]{new Asn1XerElemInfo("threadNumber", false), new Asn1XerElemInfo("operationCounter", false), new Asn1XerElemInfo("operation", false)};
            for (int i = this.mCurrElemID; i < 3; ++i) {
                if (asn1XerElemInfoArray[i].equals(string2)) {
                    if (!asn1XerElemInfoArray[i].isOptional()) {
                        ++this.mReqElemCnt;
                    }
                    return i + 1;
                }
                if (!asn1XerElemInfoArray[i].isOptional()) break;
            }
            return -1;
        }

        public void init(int n) {
            super.init(n);
            this.mElemSaxHandler = null;
            this.mReqElemCnt = 0;
            Operation.this.threadNumber = null;
            Operation.this.operationCounter = null;
            Operation.this.operation = null;
            Operation.this.extElem1 = null;
        }
    }
}

