/*
 * Decompiled with CFR 0.152.
 */
package com.pcube.management.framework.rpc.protocol;

import com.objsys.asn1j.runtime.Asn1BerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerDecodeContext;
import com.objsys.asn1j.runtime.Asn1BerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1Exception;
import com.objsys.asn1j.runtime.Asn1Real;
import com.objsys.asn1j.runtime.Asn1Tag;
import com.objsys.asn1j.runtime.Asn1Type;
import com.objsys.asn1j.runtime.Asn1XerEncoder;
import com.objsys.asn1j.runtime.Asn1XerSaxHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.LinkedList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class Parameter_realArray
extends Asn1Type {
    public Asn1Real[] elements;
    private transient Asn1XerSaxHandler mSaxHandler = null;

    public Parameter_realArray() {
        this.elements = null;
    }

    public Parameter_realArray(int n) {
        this.elements = new Asn1Real[n];
    }

    public Parameter_realArray(Asn1Real[] asn1RealArray) {
        this.elements = asn1RealArray;
    }

    public void decode(Asn1BerDecodeBuffer asn1BerDecodeBuffer, boolean bl, int n) throws Asn1Exception, IOException {
        int n2 = bl ? this.matchTag(asn1BerDecodeBuffer, Asn1Tag.SEQUENCE) : n;
        LinkedList<Asn1Real> linkedList = new LinkedList<Asn1Real>();
        Asn1BerDecodeContext asn1BerDecodeContext = new Asn1BerDecodeContext(asn1BerDecodeBuffer, n2);
        int n3 = 0;
        while (!asn1BerDecodeContext.expired()) {
            Asn1Real asn1Real = new Asn1Real();
            asn1Real.decode(asn1BerDecodeBuffer, true, n3);
            linkedList.add(asn1Real);
        }
        this.elements = new Asn1Real[linkedList.size()];
        linkedList.toArray(this.elements);
        if (bl && n2 == -9999) {
            this.matchTag(asn1BerDecodeBuffer, Asn1Tag.EOC);
        }
    }

    public int encode(Asn1BerEncodeBuffer asn1BerEncodeBuffer, boolean bl) throws Asn1Exception {
        int n = 0;
        for (int i = this.elements.length - 1; i >= 0; --i) {
            int n2 = this.elements[i].encode(asn1BerEncodeBuffer, true);
            n += n2;
        }
        if (bl) {
            n += asn1BerEncodeBuffer.encodeTagAndLength(Asn1Tag.SEQUENCE, n);
        }
        return n;
    }

    public void decode(Object object, String string) throws Asn1Exception, IOException {
        XMLReader xMLReader = (XMLReader)object;
        try {
            SaxHandler saxHandler = (SaxHandler)this.getSaxHandler();
            xMLReader.setContentHandler((ContentHandler)((Object)saxHandler));
            xMLReader.setErrorHandler((ErrorHandler)((Object)saxHandler));
            xMLReader.parse(new InputSource(string));
        }
        catch (SAXException sAXException) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            sAXException.printStackTrace(new PrintStream(byteArrayOutputStream));
            throw new Asn1Exception(byteArrayOutputStream.toString());
        }
    }

    public void decode(Object object, InputStream inputStream) throws Asn1Exception, IOException {
        XMLReader xMLReader = (XMLReader)object;
        try {
            SaxHandler saxHandler = (SaxHandler)this.getSaxHandler();
            xMLReader.setContentHandler((ContentHandler)((Object)saxHandler));
            xMLReader.setErrorHandler((ErrorHandler)((Object)saxHandler));
            xMLReader.parse(new InputSource(inputStream));
        }
        catch (SAXException sAXException) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            sAXException.printStackTrace(new PrintStream(byteArrayOutputStream));
            throw new Asn1Exception(byteArrayOutputStream.toString());
        }
    }

    public boolean matchTypeName(String string) {
        return string.equals("SEQUENCE_OF");
    }

    public Asn1XerSaxHandler getSaxHandler() {
        if (this.mSaxHandler == null) {
            this.mSaxHandler = new SaxHandler();
        }
        this.mSaxHandler.init(0);
        return this.mSaxHandler;
    }

    public void encode(Asn1XerEncoder asn1XerEncoder, String string) throws Asn1Exception, IOException {
        if (string == null) {
            string = "SEQUENCE_OF";
        }
        asn1XerEncoder.encodeStartElement(string);
        asn1XerEncoder.incrLevel();
        for (int i = 0; i < this.elements.length; ++i) {
            this.elements[i].encode(asn1XerEncoder, "REAL");
        }
        asn1XerEncoder.decrLevel();
        asn1XerEncoder.encodeEndElement(string);
    }

    public void print(PrintStream printStream, String string, int n) {
        if (this.elements != null) {
            for (int i = 0; i < this.elements.length; ++i) {
                String string2 = string + "[" + i + "]";
                this.elements[i].print(printStream, string2, n);
            }
        }
    }

    public class SaxHandler
    extends Asn1XerSaxHandler {
        StringBuffer mCurrElemValue = new StringBuffer();
        int mElemIndex = 0;

        SaxHandler() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.mCurrState = 1;
            if (this.mLevel == 0) {
                if (!Parameter_realArray.this.matchTypeName(string2)) {
                    throw new SAXException("Invalid top-level element:" + string2);
                }
            } else if (this.mLevel == 2) {
                try {
                    Asn1Real asn1Real = this.newElement();
                    asn1Real.decodeXER(string2, null);
                }
                catch (Asn1Exception asn1Exception) {
                    throw new SAXException(asn1Exception.getMessage());
                }
                this.mCurrState = 3;
                ++this.mElemIndex;
            }
            ++this.mLevel;
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.mCurrState == 1 || this.mCurrState == 2) {
                this.mCurrState = 2;
                this.mCurrElemValue.append(cArray, n, n2);
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (--this.mLevel != 0 && (this.mCurrState == 2 || this.mCurrState == 1)) {
                try {
                    Asn1Real asn1Real = this.newElement();
                    asn1Real.decodeXER(this.mCurrElemValue.toString(), null);
                }
                catch (Asn1Exception asn1Exception) {
                    throw new SAXException(asn1Exception.getMessage());
                }
                this.mCurrState = 3;
                ++this.mElemIndex;
                this.mCurrElemValue.setLength(0);
            }
        }

        public void init(int n) {
            super.init(n);
            this.mElemIndex = 0;
        }

        private Asn1Real newElement() {
            Asn1Real[] asn1RealArray = Parameter_realArray.this.elements;
            Parameter_realArray.this.elements = new Asn1Real[this.mElemIndex + 1];
            if (asn1RealArray != null) {
                System.arraycopy(asn1RealArray, 0, Parameter_realArray.this.elements, 0, this.mElemIndex);
            }
            Parameter_realArray.this.elements[this.mElemIndex] = new Asn1Real();
            return Parameter_realArray.this.elements[this.mElemIndex];
        }
    }
}

