/*
 * Decompiled with CFR 0.152.
 */
package com.pcube.management.framework.rpc.protocol;

import com.objsys.asn1j.runtime.Asn1BerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerDecodeContext;
import com.objsys.asn1j.runtime.Asn1BerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1Exception;
import com.objsys.asn1j.runtime.Asn1Tag;
import com.objsys.asn1j.runtime.Asn1Type;
import com.objsys.asn1j.runtime.Asn1XerEncoder;
import com.objsys.asn1j.runtime.Asn1XerSaxHandler;
import com.pcube.management.framework.rpc.protocol.Parameter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.LinkedList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class Parameters
extends Asn1Type {
    public Parameter[] elements;
    private transient Asn1XerSaxHandler mSaxHandler = null;

    public Parameters() {
        this.elements = null;
    }

    public Parameters(int n) {
        this.elements = new Parameter[n];
    }

    public Parameters(Parameter[] parameterArray) {
        this.elements = parameterArray;
    }

    public void decode(Asn1BerDecodeBuffer asn1BerDecodeBuffer, boolean bl, int n) throws Asn1Exception, IOException {
        int n2 = bl ? this.matchTag(asn1BerDecodeBuffer, Asn1Tag.SEQUENCE) : n;
        LinkedList<Parameter> linkedList = new LinkedList<Parameter>();
        Asn1BerDecodeContext asn1BerDecodeContext = new Asn1BerDecodeContext(asn1BerDecodeBuffer, n2);
        int n3 = 0;
        while (!asn1BerDecodeContext.expired()) {
            Parameter parameter = new Parameter();
            parameter.decode(asn1BerDecodeBuffer, true, n3);
            linkedList.add(parameter);
        }
        this.elements = new Parameter[linkedList.size()];
        linkedList.toArray(this.elements);
        if (bl && n2 == -9999) {
            this.matchTag(asn1BerDecodeBuffer, Asn1Tag.EOC);
        }
    }

    public int encode(Asn1BerEncodeBuffer asn1BerEncodeBuffer, boolean bl) throws Asn1Exception {
        int n = 0;
        for (int i = this.elements.length - 1; i >= 0; --i) {
            int n2 = this.elements[i].encode(asn1BerEncodeBuffer, true);
            n += n2;
        }
        if (bl) {
            n += asn1BerEncodeBuffer.encodeTagAndLength(Asn1Tag.SEQUENCE, n);
        }
        return n;
    }

    public void decode(Object object, String string) throws Asn1Exception, IOException {
        XMLReader xMLReader = (XMLReader)object;
        try {
            SaxHandler saxHandler = (SaxHandler)this.getSaxHandler();
            xMLReader.setContentHandler((ContentHandler)((Object)saxHandler));
            xMLReader.setErrorHandler((ErrorHandler)((Object)saxHandler));
            xMLReader.parse(new InputSource(string));
        }
        catch (SAXException sAXException) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            sAXException.printStackTrace(new PrintStream(byteArrayOutputStream));
            throw new Asn1Exception(byteArrayOutputStream.toString());
        }
    }

    public void decode(Object object, InputStream inputStream) throws Asn1Exception, IOException {
        XMLReader xMLReader = (XMLReader)object;
        try {
            SaxHandler saxHandler = (SaxHandler)this.getSaxHandler();
            xMLReader.setContentHandler((ContentHandler)((Object)saxHandler));
            xMLReader.setErrorHandler((ErrorHandler)((Object)saxHandler));
            xMLReader.parse(new InputSource(inputStream));
        }
        catch (SAXException sAXException) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            sAXException.printStackTrace(new PrintStream(byteArrayOutputStream));
            throw new Asn1Exception(byteArrayOutputStream.toString());
        }
    }

    public boolean matchTypeName(String string) {
        return string.equals("Parameters");
    }

    public Asn1XerSaxHandler getSaxHandler() {
        if (this.mSaxHandler == null) {
            this.mSaxHandler = new SaxHandler();
        }
        this.mSaxHandler.init(0);
        return this.mSaxHandler;
    }

    public void encode(Asn1XerEncoder asn1XerEncoder, String string) throws Asn1Exception, IOException {
        if (string == null) {
            string = "Parameters";
        }
        asn1XerEncoder.encodeStartElement(string);
        asn1XerEncoder.incrLevel();
        for (int i = 0; i < this.elements.length; ++i) {
            this.elements[i].encode(asn1XerEncoder, "");
        }
        asn1XerEncoder.decrLevel();
        asn1XerEncoder.encodeEndElement(string);
    }

    public void print(PrintStream printStream, String string, int n) {
        if (this.elements != null) {
            for (int i = 0; i < this.elements.length; ++i) {
                String string2 = string + "[" + i + "]";
                this.elements[i].print(printStream, string2, n);
            }
        }
    }

    public class SaxHandler
    extends Asn1XerSaxHandler {
        Asn1XerSaxHandler mElemSaxHandler = null;
        int mElemIndex = 0;

        SaxHandler() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.mCurrState = 1;
            if (this.mLevel == 0) {
                if (!Parameters.this.matchTypeName(string2)) {
                    throw new SAXException("Invalid top-level element:" + string2);
                }
            } else if (this.mLevel >= 1) {
                if (this.mElemSaxHandler == null) {
                    Parameter parameter = this.newElement();
                    this.mElemSaxHandler = parameter.getSaxHandler();
                    this.mElemSaxHandler.init(1);
                }
                this.mElemSaxHandler.startElement(string, string2, string3, attributes);
            }
            ++this.mLevel;
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if ((this.mCurrState == 1 || this.mCurrState == 2) && this.mElemSaxHandler != null) {
                this.mElemSaxHandler.characters(cArray, n, n2);
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (--this.mLevel != 0) {
                this.mElemSaxHandler.endElement(string, string2, string3);
                if (this.mElemSaxHandler.isComplete()) {
                    this.mElemSaxHandler = null;
                    this.mCurrState = 3;
                    ++this.mElemIndex;
                }
            }
        }

        public void init(int n) {
            super.init(n);
            this.mElemSaxHandler = null;
            this.mElemIndex = 0;
        }

        private Parameter newElement() {
            Parameter[] parameterArray = Parameters.this.elements;
            Parameters.this.elements = new Parameter[this.mElemIndex + 1];
            if (parameterArray != null) {
                System.arraycopy(parameterArray, 0, Parameters.this.elements, 0, this.mElemIndex);
            }
            Parameters.this.elements[this.mElemIndex] = new Parameter();
            return Parameters.this.elements[this.mElemIndex];
        }
    }
}

