/*
 * Decompiled with CFR 0.152.
 */
package com.pcube.management.smm;

import com.pcube.management.common.Community;
import com.pcube.management.common.IPUtilities;
import com.pcube.management.common.IpRange;
import com.pcube.management.common.TunneledIpRange;
import com.pcube.management.smm.SubscriberMappingException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Category;

public class SubscriberMappings {
    private static Category logcat = Category.getInstance(SubscriberMappings.class);
    public static final String FULL_RANGE_IP = "0.0.0.0/0";
    public static final char VPN_SEPARATOR = '@';
    public static final char COMMUNITY_SEPERATOR = ':';
    public static final short TYPE_IP = 0;
    public static final short TYPE_VPN = 1;
    public static final short TYPE_COMMUNITY = 2;
    public static final String[] TYPE_LABELS = new String[]{"IP", "VPN", "COMMUNITY"};
    public static final short[] ALL_IP_MAPPINGS = new short[]{0};
    public static final short[] ALL_TYPE_VPN = new short[]{1};
    public static final short[] ALL_COMMUNITY_MAPPINGS = new short[]{2};
    private IpRange[] ipRanges = null;
    protected long[] ips = null;
    protected int[] sigbits = null;
    protected TunneledIpRange[] tunneledIpRanges = null;
    protected long[] tunneledIps = null;
    protected int[] tunneledSigbits = null;
    protected String[] vpns = null;
    protected long[] communitiesOfTunneledIps = null;
    protected Community[] communities = null;
    protected long[] comms = null;
    protected String[] commVpns = null;

    public boolean isEmpty() {
        return this.ipRanges == null && this.tunneledIpRanges == null && this.communities == null;
    }

    public IpRange[] getIpRanges() {
        return this.ipRanges;
    }

    public long[] getIPs() {
        return this.ips;
    }

    public int[] getSigbits() {
        return this.sigbits;
    }

    public Community[] getCommunities() {
        return this.communities;
    }

    public long[] getCommunitiesAsLongArray() {
        return this.comms;
    }

    public String[] getCommunityVpns() {
        return this.commVpns;
    }

    public TunneledIpRange[] getTunneledIpRanges() {
        return this.tunneledIpRanges;
    }

    public long[] getTunneledIPs() {
        return this.tunneledIps;
    }

    public int[] getTunnneledSigbits() {
        return this.tunneledSigbits;
    }

    public String[] getTunneledVpns() {
        return this.vpns;
    }

    public long[] getCommunitiesOfTunneledIps() {
        return this.communitiesOfTunneledIps;
    }

    public SubscriberMappings(String[] stringArray, short[] sArray) throws SubscriberMappingException {
        if (stringArray == null) {
            return;
        }
        if (sArray.length != 1 && sArray.length != stringArray.length) {
            throw new SubscriberMappingException("Got " + stringArray.length + " mappings and " + sArray.length + " mapping types.  " + "Number of mapping types must be the same as number " + "of mappings, or 1.");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].trim().length() == 0) {
                throw new SubscriberMappingException("Got empty mapping for subscriber.");
            }
            String string = stringArray[i];
            int n2 = string.indexOf(64);
            switch (sArray[n]) {
                case 0: {
                    Object object;
                    Object object2;
                    Object object3;
                    if (n2 != -1) {
                        object3 = string.substring(0, n2);
                        String string2 = string.substring(n2 + 1);
                        TunneledIpRange tunneledIpRange = null;
                        int n3 = string2.indexOf(58);
                        if (n3 != -1) {
                            object2 = string2.substring(n3 + 1);
                            string2 = string2.substring(0, n3);
                            tunneledIpRange = new TunneledIpRange(IPUtilities.parseToRange((String)object3), new Community((String)object2, string2));
                        } else {
                            tunneledIpRange = new TunneledIpRange(IPUtilities.parseToRange((String)object3), string2);
                        }
                        if (arrayList2.size() > 0) {
                            for (int j = 0; j < arrayList2.size(); ++j) {
                                object = (TunneledIpRange)arrayList2.get(j);
                                if (tunneledIpRange.getVpn().equals(((TunneledIpRange)object).getVpn()) || ((TunneledIpRange)object).getIpRange().getIpMask() == 0L && tunneledIpRange.getIpRange().getIpMask() == 0L) continue;
                                throw new SubscriberMappingException(object + " and " + tunneledIpRange + " are part of two different VPNs");
                            }
                        }
                        if (hashMap.get(object2 = tunneledIpRange.toString()) == null) {
                            arrayList2.add(tunneledIpRange);
                            hashMap.put(object2, tunneledIpRange);
                            break;
                        }
                        logcat.debug((Object)("Duplicate tunneled IP detected: " + (String)object2));
                        break;
                    }
                    object3 = IPUtilities.parseToRange(string);
                    boolean bl = true;
                    for (int j = 0; j < arrayList.size(); ++j) {
                        IpRange ipRange = (IpRange)arrayList.get(j);
                        if (ipRange.contains((IpRange)object3)) {
                            bl = false;
                            logcat.debug((Object)("Duplicate IP range detected: " + ((IpRange)object3).toString() + " and " + ipRange.toString()));
                            break;
                        }
                        if (!((IpRange)object3).contains(ipRange)) continue;
                        arrayList.remove(j);
                        logcat.debug((Object)("Duplicate IP range detected: " + ((IpRange)object3).toString() + " and " + ipRange.toString()));
                        break;
                    }
                    if (!bl) break;
                    arrayList.add(object3);
                    break;
                }
                case 1: {
                    Object object3 = new TunneledIpRange(IPUtilities.parseToRange(FULL_RANGE_IP), string);
                    String string3 = ((TunneledIpRange)object3).toString();
                    if (hashMap.get(string3) != null) break;
                    arrayList2.add(object3);
                    hashMap.put(string3, object3);
                    break;
                }
                case 2: {
                    Object object;
                    if (n2 == -1) {
                        throw new SubscriberMappingException("Vpn is required for community mapping.");
                    }
                    String string4 = string.substring(0, n2);
                    String string5 = string.substring(n2 + 1);
                    Object object2 = new Community(string4, string5);
                    if (arrayList3.size() > 0) {
                        for (int j = 0; j < arrayList3.size(); ++j) {
                            Community community = (Community)arrayList3.get(j);
                            if (((Community)object2).getVpn().equals(community.getVpn())) continue;
                            throw new SubscriberMappingException(community + " and " + object2 + " are part of two different VPNs");
                        }
                    }
                    if (hashMap.get(object = ((Community)object2).toString()) == null) {
                        arrayList3.add(object2);
                        hashMap.put(object, object2);
                        break;
                    }
                    logcat.debug((Object)("Duplicate community detected: " + (String)object));
                    break;
                }
                default: {
                    throw new SubscriberMappingException("Mapping type " + sArray[n] + " is not supported");
                }
            }
            if (sArray.length == 1) continue;
            ++n;
        }
        if (arrayList.size() > 0) {
            this.ipRanges = new IpRange[arrayList.size()];
            arrayList.toArray(this.ipRanges);
        }
        if (arrayList2.size() > 0) {
            this.tunneledIpRanges = new TunneledIpRange[arrayList2.size()];
            arrayList2.toArray(this.tunneledIpRanges);
        }
        if (arrayList3.size() > 0) {
            this.communities = new Community[arrayList3.size()];
            arrayList3.toArray(this.communities);
        }
        if (arrayList.size() > 0 && arrayList2.size() > 0 || arrayList.size() > 0 && arrayList3.size() > 0) {
            throw new SubscriberMappingException("Different mapping types are not allowed together");
        }
        this.translateIpRanges();
        this.translateTunneledIpRanges();
        this.translateCommunities();
    }

    public SubscriberMappings(IpRange[] ipRangeArray) {
        this.ipRanges = ipRangeArray;
        this.translateIpRanges();
    }

    public SubscriberMappings(IpRange[] ipRangeArray, TunneledIpRange[] tunneledIpRangeArray) {
        this.ipRanges = ipRangeArray;
        this.tunneledIpRanges = tunneledIpRangeArray;
        this.translateIpRanges();
        this.translateTunneledIpRanges();
    }

    public SubscriberMappings(IpRange[] ipRangeArray, TunneledIpRange[] tunneledIpRangeArray, Community[] communityArray) {
        this.ipRanges = ipRangeArray;
        this.tunneledIpRanges = tunneledIpRangeArray;
        this.communities = communityArray;
        this.translateIpRanges();
        this.translateTunneledIpRanges();
        this.translateCommunities();
    }

    SubscriberMappings(long[] lArray, int[] nArray) throws SubscriberMappingException {
        if (lArray != null) {
            this.ipRanges = new IpRange[lArray.length];
            for (int i = 0; i < lArray.length; ++i) {
                this.ipRanges[i] = IpRange.createFromMask(lArray[i], nArray[i]);
            }
        }
        this.ips = lArray;
        this.sigbits = nArray;
    }

    SubscriberMappings(long[] lArray, int[] nArray, String[] stringArray) throws SubscriberMappingException {
        if (lArray != null && stringArray != null && lArray.length != stringArray.length) {
            throw new SubscriberMappingException("Got " + lArray.length + " mappings and " + stringArray.length + " vpn names.  " + "Number of vpn names must be the same as number of mappings.");
        }
        if (lArray != null) {
            this.tunneledIpRanges = new TunneledIpRange[lArray.length];
            for (int i = 0; i < lArray.length; ++i) {
                this.tunneledIpRanges[i] = new TunneledIpRange(IpRange.createFromMask(lArray[i], nArray[i]), stringArray[i]);
            }
        }
        this.tunneledIps = lArray;
        this.tunneledSigbits = nArray;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.ipRanges != null) {
            stringBuffer.append("IP Ranges: (");
            for (n = 0; n < this.ipRanges.length; ++n) {
                if (n > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(this.ipRanges[n].toString());
            }
            stringBuffer.append(") ");
        }
        if (this.tunneledIpRanges != null) {
            stringBuffer.append("Tunneled IP Ranges: (");
            for (n = 0; n < this.tunneledIpRanges.length; ++n) {
                if (n > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(this.tunneledIpRanges[n].toString());
            }
            stringBuffer.append(") ");
        }
        if (this.communities != null) {
            stringBuffer.append("Communities: (");
            for (n = 0; n < this.communities.length; ++n) {
                if (n > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(this.communities[n].getCommunityAsString());
            }
            stringBuffer.append(") ");
        }
        return stringBuffer.toString();
    }

    void translateIpRanges() {
        if (this.ipRanges != null) {
            this.ips = new long[this.ipRanges.length];
            this.sigbits = new int[this.ipRanges.length];
            for (int i = 0; i < this.ips.length; ++i) {
                this.ips[i] = this.ipRanges[i].getIpAddr();
                this.sigbits[i] = this.ipRanges[i].getNumOfSignificantBits();
            }
        }
    }

    void translateTunneledIpRanges() {
        if (this.tunneledIpRanges != null) {
            this.tunneledIps = new long[this.tunneledIpRanges.length];
            this.tunneledSigbits = new int[this.tunneledIpRanges.length];
            this.vpns = new String[this.tunneledIpRanges.length];
            this.communitiesOfTunneledIps = new long[this.tunneledIpRanges.length];
            for (int i = 0; i < this.tunneledIpRanges.length; ++i) {
                this.tunneledIps[i] = this.tunneledIpRanges[i].getIpRange().getIpAddr();
                this.tunneledSigbits[i] = this.tunneledIpRanges[i].getIpRange().getNumOfSignificantBits();
                this.vpns[i] = this.tunneledIpRanges[i].getVpn();
                this.communitiesOfTunneledIps[i] = this.tunneledIpRanges[i].getCommunity() == null ? -1L : this.tunneledIpRanges[i].getCommunity().getCommunity();
            }
        }
    }

    void translateCommunities() {
        if (this.communities != null) {
            this.comms = new long[this.communities.length];
            this.commVpns = new String[this.communities.length];
            for (int i = 0; i < this.communities.length; ++i) {
                this.comms[i] = this.communities[i].getCommunity();
                this.commVpns[i] = this.communities[i].getVpn();
            }
        }
    }
}

