/*
 * Decompiled with CFR 0.152.
 */
package com.pcube.management.smm;

import com.pcube.management.smm.SubscriberIllegalName;
import java.io.Serializable;

public class SubscriberName
implements Serializable {
    private static final int CHAR_31 = 31;
    private static final int CHAR_127 = 127;
    private static final long serialVersionUID = 6175986830667373337L;
    public static final int MAX_SUBSCRIBER_NAME_LENGTH = 64;
    private String name;

    public SubscriberName(String string) throws SubscriberIllegalName {
        SubscriberName.checkValidity(string);
        this.name = string;
    }

    public SubscriberName(byte[] byArray) {
        this.name = new String(byArray);
    }

    public final String getName() {
        return this.name;
    }

    public byte[] getBytes() {
        return this.name.getBytes();
    }

    public void toLowerCase() {
        this.name = this.name.toLowerCase();
    }

    public static void checkValidity(String string) throws SubscriberIllegalName {
        if (string == null) {
            throw new SubscriberIllegalName("Name is null");
        }
        if (string.length() == 0) {
            throw new SubscriberIllegalName("Name is empty");
        }
        if (string.length() > 64) {
            throw new SubscriberIllegalName("Name '" + string + "' is too long. Only " + 64 + " characters are allowed");
        }
        if (string.charAt(string.length() - 1) == ' ') {
            throw new SubscriberIllegalName("Name with a trailing space character is not allowed");
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c > '\u001f' && c < '\u007f' && c != '\"' && c != '\'' && c != '`') continue;
            throw new SubscriberIllegalName("Invalid name '" + string + "'. the character at position " + i + " ('" + c + "') is not allowed");
        }
    }

    public boolean equals(Object object) {
        if (object instanceof SubscriberName) {
            return this.name.equals(((SubscriberName)object).name);
        }
        return false;
    }

    public int hashCode() {
        int n = this.name.length();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 = 31 * n2 + this.name.charAt(i);
        }
        return n2;
    }

    public final String toString() {
        return this.name;
    }
}

