/*
 * Decompiled with CFR 0.152.
 */
package com.scms.common;

public class BufferUtils {
    public static boolean getBoolean(byte[] byArray, int n) throws IllegalArgumentException {
        if (byArray == null || byArray.length < n + 1) {
            throw new IllegalArgumentException("invalid buffer (null or too small)");
        }
        return byArray[n] != 0;
    }

    public static int setBoolean(byte[] byArray, int n, boolean bl) throws IllegalArgumentException {
        if (byArray == null || byArray.length < n + 1) {
            throw new IllegalArgumentException("invalid buffer (null or too small)");
        }
        byArray[n] = (byte)(bl ? 1 : 0);
        return n + 1;
    }

    public static short getShort(byte[] byArray, int n) throws IllegalArgumentException {
        if (byArray == null || byArray.length < n + 2) {
            throw new IllegalArgumentException("invalid buffer (null or too small)");
        }
        return (short)((short)byArray[n] << 8 & 0xFF00 | (short)byArray[n + 1] & 0xFF);
    }

    public static int setShort(byte[] byArray, int n, int n2) throws IllegalArgumentException {
        if (byArray == null || byArray.length < n + 2) {
            throw new IllegalArgumentException("invalid buffer (null or too small)");
        }
        byArray[n] = (byte)(n2 >> 8 & 0xFF);
        byArray[n + 1] = (byte)(n2 & 0xFF);
        return n + 2;
    }

    public static int getInt(byte[] byArray, int n) throws IllegalArgumentException {
        if (byArray == null || byArray.length < n + 4) {
            throw new IllegalArgumentException("invalid buffer (null or too small)");
        }
        return byArray[n] << 24 & 0xFF000000 | byArray[n + 1] << 16 & 0xFF0000 | byArray[n + 2] << 8 & 0xFF00 | byArray[n + 3] & 0xFF;
    }

    public static int setInt(byte[] byArray, int n, int n2) throws IllegalArgumentException {
        if (byArray == null || byArray.length < n + 4) {
            throw new IllegalArgumentException("invalid buffer (null or too small)");
        }
        byArray[n] = (byte)(n2 >> 24 & 0xFF);
        byArray[n + 1] = (byte)(n2 >> 16 & 0xFF);
        byArray[n + 2] = (byte)(n2 >> 8 & 0xFF);
        byArray[n + 3] = (byte)(n2 & 0xFF);
        return n + 4;
    }

    public static long getLong(byte[] byArray, int n) throws IllegalArgumentException {
        if (byArray == null || byArray.length < n + 8) {
            throw new IllegalArgumentException("invalid buffer (null or too small)");
        }
        return (long)byArray[n] << 56 & 0xFF00000000000000L | (long)byArray[n + 1] << 48 & 0xFF000000000000L | (long)byArray[n + 2] << 40 & 0xFF0000000000L | (long)byArray[n + 3] << 32 & 0xFF00000000L | (long)byArray[n + 4] << 24 & 0xFF000000L | (long)byArray[n + 5] << 16 & 0xFF0000L | (long)byArray[n + 6] << 8 & 0xFF00L | (long)byArray[n + 7] & 0xFFL;
    }

    public static int setLong(byte[] byArray, int n, long l) throws IllegalArgumentException {
        if (byArray == null || byArray.length < n + 8) {
            throw new IllegalArgumentException("invalid buffer (null or too small)");
        }
        byArray[n] = (byte)(l >> 56 & 0xFFL);
        byArray[n + 1] = (byte)(l >> 48 & 0xFFL);
        byArray[n + 2] = (byte)(l >> 40 & 0xFFL);
        byArray[n + 3] = (byte)(l >> 32 & 0xFFL);
        byArray[n + 4] = (byte)(l >> 24 & 0xFFL);
        byArray[n + 5] = (byte)(l >> 16 & 0xFFL);
        byArray[n + 6] = (byte)(l >> 8 & 0xFFL);
        byArray[n + 7] = (byte)(l & 0xFFL);
        return n + 8;
    }

    public static String getString(byte[] byArray, int n) throws IllegalArgumentException {
        if (byArray == null || byArray.length < n + 4) {
            throw new IllegalArgumentException("invalid buffer (null or too small)");
        }
        int n2 = BufferUtils.getInt(byArray, n);
        if (n2 < 0) {
            return null;
        }
        if (byArray.length < n + 4 + n2) {
            throw new IllegalArgumentException("buffer too small");
        }
        return new String(byArray, n + 4, n2);
    }

    public static int calcStringNewPosition(String string, int n) {
        return n + (string == null ? 4 : string.length() + 4);
    }

    public static int setString(byte[] byArray, int n, String string) throws IllegalArgumentException {
        if (byArray == null || byArray.length < n + 4) {
            throw new IllegalArgumentException("invalid buffer (null or too small)");
        }
        if (string == null) {
            return BufferUtils.setInt(byArray, n, -1);
        }
        if (byArray.length < n + 4 + string.length()) {
            throw new IllegalArgumentException("buffer too small");
        }
        byte[] byArray2 = string.getBytes();
        int n2 = BufferUtils.setInt(byArray, n, byArray2.length);
        System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
        return n2 + byArray2.length;
    }

    public static short[] getShortArray(byte[] byArray, int n) throws IllegalArgumentException {
        if (byArray == null || byArray.length < n + 4) {
            throw new IllegalArgumentException("invalid buffer (null or too small)");
        }
        int n2 = BufferUtils.getInt(byArray, n);
        int n3 = n + 4;
        if (n2 < 0) {
            return null;
        }
        short[] sArray = new short[n2];
        for (int i = 0; i < n2; ++i) {
            sArray[i] = BufferUtils.getShort(byArray, n3);
            n3 += 2;
        }
        return sArray;
    }

    public static int calcShortArrayNewPosition(short[] sArray, int n) {
        return n + (sArray == null ? 4 : sArray.length * 2 + 4);
    }

    public static int setShortArray(byte[] byArray, int n, short[] sArray) throws IllegalArgumentException {
        if (byArray == null || byArray.length < n + 4) {
            throw new IllegalArgumentException("invalid buffer (null or too small)");
        }
        if (sArray == null) {
            return BufferUtils.setInt(byArray, n, -1);
        }
        int n2 = BufferUtils.setInt(byArray, n, sArray.length);
        for (int i = 0; i < sArray.length; ++i) {
            n2 = BufferUtils.setShort(byArray, n2, sArray[i]);
        }
        return n2;
    }

    public static int[] getIntArray(byte[] byArray, int n) throws IllegalArgumentException {
        if (byArray == null || byArray.length < n + 4) {
            throw new IllegalArgumentException("invalid buffer (null or too small)");
        }
        int n2 = BufferUtils.getInt(byArray, n);
        int n3 = n + 4;
        if (n2 < 0) {
            return null;
        }
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = BufferUtils.getInt(byArray, n3);
            n3 += 4;
        }
        return nArray;
    }

    public static int calcIntArrayNewPosition(int[] nArray, int n) {
        return n + (nArray == null ? 4 : nArray.length * 4 + 4);
    }

    public static int setIntArray(byte[] byArray, int n, int[] nArray) throws IllegalArgumentException {
        if (byArray == null || byArray.length < n + 4) {
            throw new IllegalArgumentException("invalid buffer (null or too small)");
        }
        if (nArray == null) {
            return BufferUtils.setInt(byArray, n, -1);
        }
        int n2 = BufferUtils.setInt(byArray, n, nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            n2 = BufferUtils.setInt(byArray, n2, nArray[i]);
        }
        return n2;
    }

    public static long[] getLongArray(byte[] byArray, int n) throws IllegalArgumentException {
        if (byArray == null || byArray.length < n + 4) {
            throw new IllegalArgumentException("invalid buffer (null or too small)");
        }
        int n2 = BufferUtils.getInt(byArray, n);
        int n3 = n + 4;
        if (n2 < 0) {
            return null;
        }
        long[] lArray = new long[n2];
        for (int i = 0; i < n2; ++i) {
            lArray[i] = BufferUtils.getLong(byArray, n3);
            n3 += 8;
        }
        return lArray;
    }

    public static int calcLongArrayNewPosition(long[] lArray, int n) {
        return n + (lArray == null ? 4 : lArray.length * 8 + 4);
    }

    public static int setLongArray(byte[] byArray, int n, long[] lArray) throws IllegalArgumentException {
        if (byArray == null || byArray.length < n + 4) {
            throw new IllegalArgumentException("invalid buffer (null or too small)");
        }
        if (lArray == null) {
            return BufferUtils.setInt(byArray, n, -1);
        }
        int n2 = BufferUtils.setInt(byArray, n, lArray.length);
        for (int i = 0; i < lArray.length; ++i) {
            n2 = BufferUtils.setLong(byArray, n2, lArray[i]);
        }
        return n2;
    }

    public static GetResult getStringArray(byte[] byArray, int n) throws IllegalArgumentException {
        if (byArray == null || byArray.length < n + 4) {
            throw new IllegalArgumentException("invalid buffer (null or too small)");
        }
        int n2 = BufferUtils.getInt(byArray, n);
        GetResult getResult = new GetResult();
        getResult.newPos = n + 4;
        if (n2 < 0) {
            getResult.result = null;
            return getResult;
        }
        String[] stringArray = new String[n2];
        for (int i = 0; i < n2; ++i) {
            stringArray[i] = BufferUtils.getString(byArray, getResult.newPos);
            getResult.newPos = BufferUtils.calcStringNewPosition(stringArray[i], getResult.newPos);
        }
        getResult.result = stringArray;
        return getResult;
    }

    public static int setStringArray(byte[] byArray, int n, String[] stringArray) throws IllegalArgumentException {
        if (byArray == null || byArray.length < n + 4) {
            throw new IllegalArgumentException("invalid buffer (null or too small)");
        }
        if (stringArray == null) {
            return BufferUtils.setInt(byArray, n, -1);
        }
        int n2 = BufferUtils.setInt(byArray, n, stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            n2 = BufferUtils.setString(byArray, n2, stringArray[i]);
        }
        return n2;
    }

    public static class GetResult {
        public int newPos = 0;
        public Object result = null;
    }
}

