/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import com.pcube.management.common.Exceptions;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import javax.management.JMException;

public class ReflectionException
extends JMException {
    static final long serialVersionUID = 9170809325636915553L;
    private String stackTrace;
    private Exception exception;

    public ReflectionException(Exception exception) {
        this.exception = exception;
    }

    public ReflectionException(Exception exception, String string) {
        super(string);
        this.exception = exception;
    }

    public Exception getTargetException() {
        return this.exception;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        String string = null;
        try {
            string = "" + InetAddress.getLocalHost();
        }
        catch (Exception exception) {
            string = "Unknown (" + exception + ")";
        }
        if (this.stackTrace == null) {
            this.stackTrace = "*** Exception stack serialized from " + string + "\n" + Exceptions.getExceptionDumpString(this, false) + "*** End of stack serialization from " + string;
            objectOutputStream.defaultWriteObject();
            this.stackTrace = null;
        } else {
            objectOutputStream.defaultWriteObject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace() {
        if (this.stackTrace != null) {
            PrintStream printStream = System.err;
            synchronized (printStream) {
                System.err.println(this);
                System.err.println(this.stackTrace);
            }
        }
        super.printStackTrace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream printStream) {
        if (this.stackTrace != null) {
            PrintStream printStream2 = printStream;
            synchronized (printStream2) {
                printStream.println(this);
                printStream.println(this.stackTrace);
            }
        }
        super.printStackTrace(printStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter printWriter) {
        if (this.stackTrace != null) {
            PrintWriter printWriter2 = printWriter;
            synchronized (printWriter2) {
                printWriter.println(this);
                printWriter.println(this.stackTrace);
            }
        }
        super.printStackTrace(printWriter);
    }
}

