/*
 * Decompiled with CFR 0.152.
 */
package com.objsys.asn1j.runtime;

import com.objsys.asn1j.runtime.Asn1BerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerMessageDumpHandler;
import com.objsys.asn1j.runtime.Asn1EncodeBuffer;
import com.objsys.asn1j.runtime.Asn1Exception;
import com.objsys.asn1j.runtime.Asn1Tag;
import com.objsys.asn1j.runtime.Asn1Type;
import com.objsys.asn1j.runtime.Asn1Util;
import com.objsys.asn1j.runtime.c;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class Asn1BerEncodeBuffer
extends Asn1EncodeBuffer {
    private static c b = c.b(1);

    public Asn1BerEncodeBuffer() {
        this.mByteIndex = this.mSizeIncrement - 1;
    }

    public Asn1BerEncodeBuffer(int n) {
        super(n);
        this.mByteIndex = this.mSizeIncrement - 1;
    }

    protected void checkSize(int n) {
        block3: {
            int n2;
            int n3;
            block2: {
                n3 = n;
                n2 = this.mByteIndex + 1;
                if (Asn1Type.a != 0) break block2;
                if (n3 <= n2) break block3;
                n3 = (n - 1) / this.mSizeIncrement;
                n2 = 1;
            }
            int n4 = n3 + n2;
            int n5 = n4 * this.mSizeIncrement;
            byte[] byArray = new byte[this.mData.length + n5];
            int n6 = this.mByteIndex + n5 + 1;
            int n7 = this.mData.length - (this.mByteIndex + 1);
            System.arraycopy(this.mData, this.mByteIndex + 1, byArray, n6, n7);
            this.mData = byArray;
            this.mByteIndex = n6 - 1;
        }
    }

    public void copy(byte by) {
        if (this.mByteIndex < 0) {
            this.checkSize(1);
        }
        this.mData[this.mByteIndex--] = by;
    }

    public void copy(byte[] byArray) throws Asn1Exception {
        this.checkSize(byArray.length);
        this.mByteIndex -= byArray.length;
        System.arraycopy(byArray, 0, this.mData, this.mByteIndex + 1, byArray.length);
    }

    public void copy(String string) {
        int n = string.length();
        this.checkSize(n);
        this.mByteIndex -= n;
        int n2 = 0;
        while (n2 < n) {
            this.mData[this.mByteIndex + n2 + 1] = (byte)string.charAt(n2);
            ++n2;
        }
    }

    public int encodeIdentifier(int n) {
        boolean bl = true;
        int n2 = 0;
        int n3 = n;
        do {
            if (this.mByteIndex < 0) {
                this.checkSize(1);
            }
            this.mData[this.mByteIndex] = (byte)(n3 % 128);
            if (!bl) {
                int n4 = this.mByteIndex;
                this.mData[n4] = (byte)(this.mData[n4] | 0x80);
            } else {
                bl = false;
            }
            --this.mByteIndex;
            ++n2;
        } while ((n3 /= 128) > 0);
        return n2;
    }

    public int encodeIntValue(long l2) {
        long l3;
        long l4 = l2;
        int n = 0;
        do {
            l3 = l4 % 256L;
            if ((l4 /= 256L) < 0L && l3 != 0L) {
                --l4;
            }
            this.copy((byte)l3);
            ++n;
        } while (l4 != 0L && l4 != -1L);
        if (l2 > 0L && (l3 & 0x80L) == 128L) {
            this.copy((byte)0);
            ++n;
        } else if (l2 < 0L && (l3 & 0x80L) == 0L) {
            this.copy((byte)-1);
            ++n;
        }
        return n;
    }

    public int encodeLength(int n) {
        int n2 = 0;
        boolean bl = false;
        if (n >= 0) {
            bl = n > 127;
            int n3 = n;
            do {
                if (this.mByteIndex < 0) {
                    this.checkSize(1);
                }
                Short s = new Short((short)(n3 % 256));
                this.mData[this.mByteIndex--] = s.byteValue();
                ++n2;
            } while ((n3 /= 256) > 0);
        } else {
            boolean bl2 = bl = n == -9999;
        }
        if (bl) {
            if (this.mByteIndex < 0) {
                this.checkSize(1);
            }
            this.mData[this.mByteIndex--] = (byte)(n2 | 0x80);
            ++n2;
        }
        return n2;
    }

    public int encodeTag(Asn1Tag asn1Tag) {
        byte by = (byte)(asn1Tag.mClass | asn1Tag.mForm);
        int n = 0;
        if (asn1Tag.mIDCode < 31) {
            this.copy((byte)(by | asn1Tag.mIDCode));
            ++n;
        } else {
            n += this.encodeIdentifier(asn1Tag.mIDCode);
            this.copy((byte)(by | 0x1F));
            ++n;
        }
        return n;
    }

    public int encodeTagAndLength(Asn1Tag asn1Tag, int n) {
        int n2 = this.encodeLength(n);
        return n2 += this.encodeTag(asn1Tag);
    }

    public int encodeTagAndLength(short s, short s2, int n, int n2) {
        Asn1Tag asn1Tag = new Asn1Tag(s, s2, n);
        return this.encodeTagAndLength(asn1Tag, n2);
    }

    public ByteArrayInputStream getByteArrayInputStream() {
        int n = this.mByteIndex + 1;
        return new ByteArrayInputStream(this.mData, n, this.mData.length - n);
    }

    public InputStream getInputStream() {
        return this.getByteArrayInputStream();
    }

    public byte[] getMsgCopy() {
        int n = this.mByteIndex + 1;
        int n2 = this.mData.length - n;
        byte[] byArray = new byte[n2];
        System.arraycopy(this.mData, n, byArray, 0, n2);
        return byArray;
    }

    public int getMsgLength() {
        int n = this.mByteIndex + 1;
        return this.mData.length - n;
    }

    public void binDump(PrintStream printStream, String string) {
        Asn1BerDecodeBuffer asn1BerDecodeBuffer = new Asn1BerDecodeBuffer(this.getByteArrayInputStream());
        try {
            asn1BerDecodeBuffer.parse(new Asn1BerMessageDumpHandler(printStream));
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    public void binDump() {
        super.binDump(null);
    }

    public void reset() {
        this.mByteIndex = this.mData.length - 1;
    }

    /*
     * Unable to fully structure code
     */
    public String toString() {
        var5_1 = Asn1Type.a;
        var1_2 = this.mByteIndex + 1;
        var2_3 = this.mData.length - var1_2;
        var3_4 = new String("");
        var4_5 = 0;
        if (var5_1 == 0) ** GOTO lbl12
        block0: while (true) {
            v0 = var3_4 + Asn1Util.toHexString(this.mData[var4_5 + var1_2]);
            do {
                var3_4 = v0;
                ++var4_5;
lbl12:
                // 2 sources

                if (var4_5 < var2_3) continue block0;
                v0 = var3_4;
            } while (var5_1 != 0);
            break;
        }
        return v0;
    }

    public void write(OutputStream outputStream) throws IOException {
        int n = this.mByteIndex + 1;
        outputStream.write(this.mData, n, this.mData.length - n);
    }
}

