/*
 * Decompiled with CFR 0.152.
 */
package com.objsys.asn1j.runtime;

import com.objsys.asn1j.runtime.Asn1BerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerOutputStream;
import com.objsys.asn1j.runtime.Asn1DecodeBuffer;
import com.objsys.asn1j.runtime.Asn1EncodeBuffer;
import com.objsys.asn1j.runtime.Asn1EndOfBufferException;
import com.objsys.asn1j.runtime.Asn1Exception;
import com.objsys.asn1j.runtime.Asn1PerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1PerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1PerOutputStream;
import com.objsys.asn1j.runtime.Asn1Tag;
import com.objsys.asn1j.runtime.Asn1Type;
import com.objsys.asn1j.runtime.Asn1XerEncoder;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;

public class Asn1BigInteger
extends Asn1Type {
    public static final Asn1Tag TAG = new Asn1Tag(0, 0, 2);
    static final BigInteger e = new BigInteger("256");
    static final BigInteger f = new BigInteger("-1");
    static final BigInteger g = BigInteger.ZERO;
    static final int h = 10000;
    protected transient boolean mbSignExtend;
    public transient BigInteger value;
    private static final long serialVersionUID = 2009412881072054788L;

    public Asn1BigInteger() {
        this.mbSignExtend = true;
        this.value = null;
    }

    public Asn1BigInteger(BigInteger bigInteger) {
        this.mbSignExtend = true;
        this.value = bigInteger;
    }

    public Asn1BigInteger(String string) {
        int n;
        String string2;
        String string3;
        block7: {
            block11: {
                int n2;
                int n3;
                block10: {
                    block8: {
                        block9: {
                            block5: {
                                block6: {
                                    n3 = Asn1Type.a;
                                    this.mbSignExtend = true;
                                    string3 = "";
                                    string2 = string;
                                    n2 = string2.charAt(0);
                                    if (n3 == 0) {
                                        if (n2 == 45) {
                                            string2 = string2.substring(1);
                                            string3 = "-";
                                        }
                                        n2 = string2.startsWith("0x") ? 1 : 0;
                                    }
                                    if (n3 != 0) break block5;
                                    if (n2 == 0) break block6;
                                    n = 16;
                                    string2 = string2.substring(2);
                                    if (n3 == 0) break block7;
                                }
                                n2 = string2.startsWith("0b") ? 1 : 0;
                            }
                            if (n3 != 0) break block8;
                            if (n2 == 0) break block9;
                            n = 2;
                            string2 = string2.substring(2);
                            if (n3 == 0) break block7;
                        }
                        n2 = string2.startsWith("0o") ? 1 : 0;
                    }
                    if (n3 != 0) break block10;
                    if (n2 == 0) break block11;
                    n2 = 8;
                }
                n = n2;
                string2 = string2.substring(2);
                if (n3 == 0) break block7;
            }
            this.value = new BigInteger(string);
            return;
        }
        this.a(string3 + string2, n);
    }

    public Asn1BigInteger(String string, int n) {
        this.mbSignExtend = true;
        this.a(string, n);
    }

    /*
     * Unable to fully structure code
     */
    private void a(String var1_1, int var2_2) {
        block8: {
            block6: {
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                block7: {
                                    var9_3 = Asn1Type.a;
                                    this.mbSignExtend = true;
                                    this.value = new BigInteger(var1_1, var2_2);
                                    v0 = var2_2;
                                    if (var9_3 != 0) break block7;
                                    if (v0 == 10) break block8;
                                    v0 = var1_1.length();
                                }
                                if (var9_3 != 0) break block9;
                                if (v0 <= 0) break block8;
                                v0 = var1_1.charAt(0);
                            }
                            v1 = 45;
                            if (var9_3 != 0) break block10;
                            if (v0 == v1) break block8;
                            v0 = var1_1.charAt(0);
                            if (var9_3 != 0) break block11;
                            v1 = 48;
                        }
                        if (v0 == v1) break block8;
                        v0 = var2_2;
                    }
                    if (var9_3 != 0) ** GOTO lbl27
                    switch (v0) {
                        case 2: {
                            v0 = 8;
lbl27:
                            // 2 sources

                            var3_4 = v0;
                            var4_5 = 1;
                            if (var9_3 == 0) break;
                        }
                        case 8: {
                            var3_4 = 3;
                            var4_5 = 4;
                            if (var9_3 == 0) break;
                        }
                        case 16: {
                            var3_4 = 2;
                            var4_5 = 8;
                            if (var9_3 == 0) break;
                        }
                        default: {
                            return;
                        }
                    }
                    v2 = var1_1.length() % var3_4;
                    if (var9_3 != 0) break block12;
                    if (v2 != 0) break block8;
                    v2 = Character.digit(var1_1.charAt(0), var2_2);
                }
                if ((var5_6 = v2) < var4_5) break block8;
                var6_7 = this.value.toByteArray();
                var7_8 = 0;
                if (var9_3 == 0) ** GOTO lbl51
                do {
                    ++var7_8;
lbl51:
                    // 2 sources

                    if (var7_8 >= var6_7.length) break;
                    v3 = var6_7[var7_8];
                    if (var9_3 != 0 || var9_3 != 0) break block6;
                } while (v3 == 0);
                v3 = var6_7.length - var7_8;
            }
            var8_9 = new byte[v3];
            System.arraycopy(var6_7, var7_8, var8_9, 0, var8_9.length);
            this.value = new BigInteger(var8_9);
        }
    }

    public static BigInteger decodeValue(Asn1DecodeBuffer asn1DecodeBuffer, int n) throws Asn1Exception, IOException {
        BigInteger bigInteger = null;
        if (n > 10000) {
            throw new Asn1Exception("too big integer value (length is " + n + ")");
        }
        int n2 = 0;
        while (n2 < n) {
            int n3 = asn1DecodeBuffer.readByte();
            if (n3 < 0) {
                throw new Asn1EndOfBufferException(asn1DecodeBuffer);
            }
            if (n2 == 0) {
                bigInteger = new BigInteger(n3 > 127 ? "-1" : "0");
            }
            bigInteger = bigInteger.multiply(e);
            bigInteger = bigInteger.add(new BigInteger(Integer.toString(n3)));
            ++n2;
        }
        if (bigInteger == null) {
            bigInteger = g;
        }
        return bigInteger;
    }

    protected static int encodeValue(Asn1EncodeBuffer asn1EncodeBuffer, BigInteger bigInteger, boolean bl, boolean bl2) {
        int n;
        BigInteger bigInteger2 = bigInteger;
        int n2 = 0;
        do {
            BigInteger[] bigIntegerArray = bigInteger2.divideAndRemainder(e);
            bigInteger2 = bigIntegerArray[0];
            n = bigIntegerArray[1].intValue();
            if (bigInteger2.compareTo(g) == -1 && n != 0) {
                bigInteger2 = bigInteger2.add(f);
            }
            if (bl2) {
                asn1EncodeBuffer.copy((byte)n);
            }
            ++n2;
        } while (bigInteger2.compareTo(g) != 0 && bigInteger2.compareTo(f) != 0);
        if (bl && bigInteger.compareTo(g) > 0 && (n & 0x80) == 128) {
            if (bl2) {
                asn1EncodeBuffer.copy((byte)0);
            }
            ++n2;
        } else if (bl && bigInteger.compareTo(g) < 0 && (n & 0x80) == 0) {
            if (bl2) {
                asn1EncodeBuffer.copy((byte)-1);
            }
            ++n2;
        }
        return n2;
    }

    public void decode(Asn1BerDecodeBuffer asn1BerDecodeBuffer, boolean n, int n2) throws Asn1Exception, IOException {
        int n3 = n;
        if (Asn1Type.a == 0) {
            n3 = n3 != 0 ? this.matchTag(asn1BerDecodeBuffer, TAG) : n2;
        }
        int n4 = n3;
        this.value = Asn1BigInteger.decodeValue(asn1BerDecodeBuffer, n4);
        asn1BerDecodeBuffer.setTypeCode((short)2);
    }

    public int encode(Asn1BerEncodeBuffer asn1BerEncodeBuffer, boolean bl) throws Asn1Exception {
        int n = Asn1BigInteger.encodeValue(asn1BerEncodeBuffer, this.value, this.mbSignExtend, true);
        int n2 = bl;
        if (Asn1Type.a == 0) {
            if (n2 != 0) {
                n += asn1BerEncodeBuffer.encodeTagAndLength(TAG, n);
            }
            n2 = n;
        }
        return n2;
    }

    public void decode(Asn1PerDecodeBuffer asn1PerDecodeBuffer) throws Asn1Exception, IOException {
        int n = (int)asn1PerDecodeBuffer.decodeLength();
        asn1PerDecodeBuffer.byteAlign();
        asn1PerDecodeBuffer.getTraceHandler().newBitField("value", n * 8);
        this.value = Asn1BigInteger.decodeValue(asn1PerDecodeBuffer, n);
        asn1PerDecodeBuffer.setTypeCode((short)2);
    }

    /*
     * Unable to fully structure code
     */
    public void encode(Asn1PerEncodeBuffer var1_1) throws Asn1Exception, IOException {
        block6: {
            block5: {
                var7_2 = Asn1Type.a;
                var2_3 = null;
                var4_4 = Asn1BigInteger.encodeValue(var1_1, this.value, this.mbSignExtend, false);
                var1_1.encodeLength(var4_4);
                v0 = var5_5 = var1_1.isAligned();
                if (var7_2 != 0) ** GOTO lbl15
                if (v0 == 0) {
                    var2_3 = var1_1;
                    var1_1 = new Asn1PerEncodeBuffer(true, var4_4);
                    var3_6 = 0;
                } else {
                    var1_1.getTraceHandler().newBitField("value", var4_4 * 8);
                    v0 = var1_1.getByteIndex() + 1;
lbl15:
                    // 2 sources

                    var3_6 = v0;
                }
                Asn1BigInteger.encodeValue(var1_1, this.value, this.mbSignExtend, true);
                v1 = var1_1;
                if (var7_2 != 0) break block5;
                v1.reverseBytes(var3_6, var4_4);
                if (var5_5 != 0) break block6;
                v1 = var1_1;
            }
            var6_7 = v1.getBuffer();
            var1_1 = var2_3;
            var1_1.encodeBits(var6_7, 0, var4_4 * 8);
        }
    }

    public void encode(Asn1XerEncoder asn1XerEncoder, String string) throws IOException, Asn1Exception {
        block3: {
            String string2;
            block2: {
                string2 = string;
                if (Asn1Type.a != 0) break block2;
                if (string2 != null) break block3;
                string2 = "INTEGER";
            }
            string = string2;
        }
        asn1XerEncoder.encodeStartElement(string);
        asn1XerEncoder.copy(this.toString());
        asn1XerEncoder.encodeEndElement(string);
    }

    public void decodeXER(String string, String string2) throws Asn1Exception {
        this.value = new BigInteger(string);
    }

    public String toString() {
        return this.value.toString();
    }

    public void encode(Asn1BerOutputStream asn1BerOutputStream, boolean bl) throws Asn1Exception, IOException {
        if (bl) {
            asn1BerOutputStream.encodeTag(TAG);
        }
        Asn1BerEncodeBuffer asn1BerEncodeBuffer = new Asn1BerEncodeBuffer();
        int n = Asn1BigInteger.encodeValue(asn1BerEncodeBuffer, this.value, this.mbSignExtend, true);
        asn1BerOutputStream.encodeLength(n);
        asn1BerOutputStream.write(asn1BerEncodeBuffer.getMsgCopy());
    }

    public void encode(Asn1PerOutputStream asn1PerOutputStream) throws Asn1Exception, IOException {
        this.encode(asn1PerOutputStream.a);
        asn1PerOutputStream.a(false);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeShort(1);
        objectOutputStream.writeBoolean(this.mbSignExtend);
        objectOutputStream.writeObject(this.value);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        objectInputStream.readShort();
        this.mbSignExtend = objectInputStream.readBoolean();
        this.value = (BigInteger)objectInputStream.readObject();
    }
}

